;**********************************************
;*	          DSKCPY.ASM                  *	
;*          PI/O OR DMA CONTROLLER            * 
;*           BRUCE JONES MAY 23, 1986         *
;**********************************************


	.Z80
	.PABS
	.PHEX
	.XLINK
	.XSYM
	.LOC	100H

	TRUE	==	0FFFFH
	FALSE	==	#TRUE



;BDOS FUNCTIONS

	GCON	==	1	;GET CONSOL
	WCON	==	2	;OUTPUT CONSOL
	PRINT	==	9	;PRINT STRING
	GBUF	==	10	;GET CONSOL BUFFER
	RESET	==	13
	SLDSK	==	14
	MRECS	==	1	;JUST ONE RECORD NEEDED
	BDOS	==	5


	CR	==	13
	LF	==	10
	BELL	==	7

;*****************************************************
;*         GET CURRENT DRIVE STATUS & SAVE
;*****************************************************

INIT:

; MAKE BIOS ENTRY FOR TESTING

	LHLD	1		;GET WARM BOOT
	MVI	L,0
	LXI	D,24
	DAD	D
	SHLD	HOME+1
	LXI	D,3
	DAD	D
	SHLD	SELDSK+1
	DAD	D
	SHLD	SETTRK+1
	DAD	D
	SHLD	SETSEC+1
	DAD	D
	SHLD	SETDMA+1
	DAD	D
	SHLD	READ+1
	DAD	D
	SHLD	WRITE+1
	DAD	D
	DAD	D
	SHLD	SECTRA+1
ENTRE0:
OVER:
SIGON:
SIGON1:

HUH:
	LXI	SP,100H
	LXI	D,MESS1
	MVI	C,PRINT
	CALL	BDOS
	LXI	H,OKMES1
	CALL	GETOK

	STA	INCON
	CPI	3
	JZ	0
GOHERE:
	LDA	INCON
	CPI	'Q'
	JZ	0

	CPI	CR
	JZ	YESAB
	CPI	'D'
	JZ	GETDRV
	JMP	HUH


YESAB:
	XRA	A
	STA	FROM
	INR	A
	STA	TO

	LXI	D,ATOBOK
	MVI	C,PRINT
	CALL	BDOS

	LXI	H,OKYES
	CALL	GETOK
	CPI	3
	JZ	0

	CPI	'N'
	JZ	HUH
	CPI	'Y'
	JZ	FILTAB
	JMP	HUH

GETDRV:
	LXI	D,FROMMS
	MVI	C,PRINT
	CALL	BDOS

	LXI	H,OKDISK
	CALL	GETOK

	CPI	3
	JZ	0
UPRF:
	STA	FMSCK
	SUI	'A'
	STA	FROM
	LXI	D,TOMES
	MVI	C,PRINT
	CALL	BDOS
	LXI	H,OKDISK
	CALL	GETOK

	CPI	3
	JZ	0
	STA	TMSCK
	SUI	'A'
	STA	TO

	LXI	D,CHKER
	MVI	C,PRINT
	CALL	BDOS
	LXI	H,OKR
	CALL	GETOK
	CPI	3
	JZ	0
	CPI	CR
	JNZ	GETDRV
	JMP	FILTAB


INCON:	.BYTE	0
FROM:	.BYTE	0
TO:	.BYTE	0

FROMMS:
	.BYTE	CR,LF,LF
	.ASCII	\Enter drive to copy from $\

TOMES:	
	.BYTE	CR,LF
	.ASCII	\Enter drive to copy to $\

CHKER:
	.BYTE	CR,LF,LF
	.ASCII	\Copy from drive \
FMSCK:	.BYTE	'A'
	.ASCII	\  to drive \
TMSCK:	.BYTE	'B'
	.ASCII	\  <CR> if O.K. or R to re-enter $\


;FILL THE SECTOR TABLE FIRST ( CLEARS AN 88 BYTE AREA FOR THE 
;SEQUENCE OF SECTORS ON THE USER TRACKS TO BE FOUND IN THE
;DDB READ ROUTINE DONE LATER)

FILTAB:

	LXI	H,SKEWTB	;POINT TO TABLE
	XRA	A		;CLEAR ACC.
	MVI	C,88		;POSSIBLE SECTORS
FLOP:	MOV	M,A		;CLEAR BYTE
	INX	H
	DCR	C
	JRNZ	FLOP
	

;             HOME THE DRIVES NOW & GET THEIR DDB.
;           PUT # OF SECTORS PER USER TRACK AT 'NDSR'
;           PUT # OF SECTORS PER SYSTEM TRACK AT SYSSEC
 
GETDDB:

;               FIRST GET DRIVE A PARAMETERES

	CALL	DSKNIT	

	LDA	FROM		;GET SOURCE DRIVE
	STA	CURDRV		;SAVE IT IN CURRENT DRIVE BYTE
	CALL	DDBIN		;GET THE DDB
	LXI	H,DDBB		;POINT TO DDB
	LXI	D,DDB1		;POINT TO SAVE BLOCK
	LXI	B,128		;BYTES TO MOVE
	LDIR			;MOVE IT
	LDA	NDSR		;GET # OF SECTORS
	STA	NDSR1		;SAVE FOR A:
	LHLD	TLENS		;GET TRACK LENGTH
	SHLD	TLENS1		;SAVE HERE


;             NOW GET DRIVE B PARAMETERS

BPARMS:

	LDA	TO		;GET TO DESTINATION DRIVE
	STA	CURDRV		;SAVE IT IN CURRENT DRIVE BYTE
	CALL	DDBIN		;GET THE DDB
	LXI	H,DDBB		;POINT TO DDB
	LXI	D,DDB2		;POINT TO SAVE BLOCK
	LXI	B,128		;BYTES TO MOVE
	LDIR			;MOVE IT


;       NOW CHECK TO SEE THAT BOTH DDBs ARE THE SAME

	LXI	H,DDB1		;POINT TO DIVE A: DDB
	LXI	D,DDB2		;POINT TO DRIVE B: DDB
	MVI	C,128		;TEST THIS MUCH
TESTDB:	LDAX	D		;GET DDB2
	CMP	M		;TEST WITH DDB1
	JNZ	BADDDB		;TELL THEM ITS BAD
	INX	H		;SET POINTERS TO NEXT BYTE
	INX	D
	DCR	C		;COUNT DOWN
	JRNZ	TESTDB		;DO NEXT
	

NOWSKW:	CALL	MAKSKW		;ELSE GO MAKE SECTOR TABLE
	CALL	CRLF2

	JMP	KOPY		;ALL O.K. SO GO COPY DISKS

CRLF2:

	LXI	D,CRLF1
	MVI	C,PRINT
	CALL	BDOS
	RET

CRLF1:	.BYTE	LF,CR,LF,CR,24H

KOPY:
	LDA	FROM
	LXI	B,0		;SELECT DRIVE 0	
	MOV	C,A
	MVI	E,0
	CALL	SELDSK
	LXI	B,RDMADD	;INITIALIZE READ DMA XFER
	SBCD	RTADD		;REMEMBER READ XFER ADDRESS
	CALL	SETDMA		;SET THE DMA LOCATION
	LDA	FROM
	STA	CURDRV
	CALL	PHOME		;HOME DRIVE 0

	LDA	TO		;SET DRIVE 1
	STA	CURDRV
	CALL	PHOME		;HOME DRIVE 1

	LDA	FROM		;RE-SELECT SOURCE DRIVE
	STA	CURDRV
	LXI	B,0
	MOV	C,A
	MVI	E,0FFH
	CALL	SELDSK


;          DISK COPY READ / WRITES  FIRST DO SYSTEM TRACKS

SCOP:
	LDA	SYSSEC		;GET # SYSTEM SECTORS
	CPI	36		;SEE IF NEW
	JRZ	SCOPI
	LXI	H,SYSSKW+32	;SET FOR 32 LOGICAL SECTORS
	XRA	A
	CMA
	MOV	M,A		;& SET IT

SCOPI:
	LXI	B,0		;FOR TRACK 0
	LXI	D,SYSSKW	;USE SYSTEM SKEW TABLE	
	SDED	SKWPTR		;PUT IN POINTER
	SBCD	CURTRK		;SET CURRENT TRACK
	CALL	SETTRK		;SET IT
	CALL	RLOOP		;READ/WRITE  IT
	LBCD	CURTRK		;GET CURRENT
	INX	B		;POINT NEXT
	SBCD	CURTRK		;SAVE IT	
	CALL	HEX
	CALL	SETTRK		;SET IT
	CALL	RLOOP		;READ/WRITE IT
	LXI	D,SKEWTB	;POINT TO USER SKEW TABLE
	SDED	SKWPTR		;PUT IN POINTER



;                NOW DO DATA TRACKS


CLOOP:	LBCD	CURTRK		;GET CURRENT TRACK
	INX	B		;UPDATE IT
	SBCD	CURTRK		;SAVE IT
	LDA	TRKS		;GET TOTAL TRACKS
	CMP	C		;SEE IF DONE
	JC	ENDIT		;IF SO END
	CALL	SETTRK		;ELSE SET TRACK
	CALL	RLOOP		;READ/WRITE IT
	JMP	CLOOP		;DO NEXT
 
RLOOP:
	
	MVI	A,5
	STA	RETRY5
;	CALL	CRLF2	
	LBCD	CURTRK
	CALL	HEX

RLOOP3:

	LDA	FROM
	LXI	B,0		;SET TO DISK 0
	MOV	C,A
	MVI	E,0FFH
	CALL	SELDSK		;LET BDOS DO IT
	MVI	A,0		;SET FIRST SECTOR
	STA	SCOUNT		;ZERO SECTOR COUNT
	LXI	B,RDMADD	;POINT TO START OF TRACK DMA
	SBCD	TADD		;PUT IN DMA POINTER
	CALL	SETDMA		;SET STARTING DMA
	LDED	SKWPTR		;POINT TO SKEW TABLE	
	SDED	NXTSEC

RLOOP1:
	LXI	B,0
	LDED	NXTSEC
	LDAX	D		;GET SECTOR
	CPI	0FFH		;SEE IF END OF TABLE	
	JZ	WRITER
	MOV	C,A		;O.K. PUT IN C
;	CALL	PHEX
	INX	D
	SDED	NXTSEC
	LDA	CURTRK
	CPI	2
	JRC	..NSKW
	CALL	GETSKW
 ..NSKW:CALL	SETSEC		;AND SET IT
	CALL	READ		;NOW GO READ CURRENT SECTOR
	LHLD	TADD		;GET LAST DMA ADD.
	LXI	D,128		;PUT RECORD LENGTH IN DE
	DAD	D		;UPDATE OLD DMA ADDRESS
	SHLD	TADD		;AND SAVE IT
	PUSH	H		;PUT ON STACK
	POP	B		;FOR BC TO GET
	CALL	SETDMA		;AND GO SET NEW DMA ADD.
	JMP	RLOOP1		;DO NEXT SECTOR


;          THE TRACK WRITER POINTS BACK TO DATA READ IN
;          AND STORES IT ON THE DESTINATION DRIVE TRACKS

WRITER:

;	CALL	CRLF2
	LDA	TO
	LXI	B,0
	MOV	C,A
	MVI	E,0FFH
	CALL	SELDSK		;SELECT DRIVE B:	
	LXI	B,RDMADD	;INITIALIZE DMA XFER
	SBCD	TADD		;REMEMBER XFER ADDRESS
	CALL	SETDMA		;SET DMA ADDRESS
	LDED	SKWPTR		;POINT TO START
	SDED	NXTSEC


;               WE NEXT WRITE THE TRACK

WLOOP:

	LXI	B,0
	LDED	NXTSEC
	LDAX	D
	CPI	0FFH
	JZ	VLOOP		;DO TRACK DATA CHECK
	MOV	C,A
;	CALL	PHEX
	INX	D
	SDED	NXTSEC
	LDA	CURTRK
	CPI	2
	JRC	..NSKW
	CALL	GETSKW
 ..NSKW:CALL	SETSEC
	CALL	WRITE
	LHLD	TADD		;GET LAST DMA ADD.
	LXI	D,128
	DAD	D		;UPDATE IT
	SHLD	TADD
	PUSH	H
	POP	B		;MAKE BC NEW ADDRESS
	CALL	SETDMA
	JMP	WLOOP


VLOOP:
;	CALL	CRLF2
	MVI	A,0		;SET FIRST SECTOR
	STA	SCOUNT		;ZERO SECTOR COUNT
	LXI	B,VDMADD	;POINT TO START OF TRACK DMA
	SBCD	TADD		;PUT IN DMA POINTER
	CALL	SETDMA		;SET STARTING DMA
	LDED	SKWPTR		;POINT TO SKEW TABLE	
	SDED	NXTSEC

VLOOP1:
	LXI	B,0
	LDED	NXTSEC
	LDAX	D		;GET SECTOR
	CPI	0FFH		;SEE IF END OF TABLE	
	JZ	TESTIT		;GO CHECK FOR GOOD DATA
	MOV	C,A		;O.K. PUT IN C
;	CALL	PHEX
	INX	D
	SDED	NXTSEC
	LDA	CURTRK
	CPI	2
	RC			;DON'T TEST SYSTEM TRACKS
	CALL	GETSKW
 ..NSKW:CALL	SETSEC		;AND SET IT
	CALL	READ		;NOW GO READ CURRENT SECTOR
	LHLD	TADD		;GET LAST DMA ADD.
	LXI	D,128		;PUT RECORD LENGTH IN DE
	DAD	D		;UPDATE OLD DMA ADDRESS
	SHLD	TADD		;AND SAVE IT
	PUSH	H		;PUT ON STACK
	POP	B		;FOR BC TO GET
	CALL	SETDMA		;AND GO SET NEW DMA ADD.
	JMP	VLOOP1		;DO NEXT SECTOR




;       FOLLWING GETS DATA FROM DRIVE 0 AND TESTS 
;       WITH DATA FROM DRIVE 1, AN ERROR IS REPORTED TO USER

TESTIT:


	LXI	H,RDMADD	;POINT TO SOURCE DATA
	LXI	D,VDMADD	;POINT TO WRITTEN DATA
	LBCD	TLENS		;GET TRACK LENGTH IN BC
DODAT:	LDAX	D		;GET WRITTEN DATA
	CMP	M		;TEST WITH SOURCE
	JNZ	RETRY1
	INX	H		;ELSE POINT NEXT
	INX	D		;AND NEXT
	DCX	B		;COUNT DOWN
	MOV	A,B		;GET HIGH COUNT
	ORA	C		;OR WITH LOW
	RZ			;DONE IF COUNTED DOWN
	JMP	DODAT		;ELSE TEST NEXT



RETRY1:
	LDA	RETRY5
	DCR	A
	STA	RETRY5
	JNZ	WRITER



;               SHOW USER COPY JUST FAILED

TOOBAD:

	LXI	D,DEFAIL	;DESTINATION JUNKED	
	MVI	C,PRINT
	CALL	BDOS
	JMP	ENDIT			;GO CP/M

DEFAIL:

	.BYTE	LF,CR
	.ASCII	\                   Failure to write correct data on destination\
	.BYTE	LF,CR
	.ASCII	\               Inspect condition of disks and try copy from start $\ 

PHEX:
	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	CALL	HEX1
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET

;                   GET BACK TO MASTER PROGRAM NOW

ENDIT:
EXITCP:

EXTCP:
DODONE:
GOSOFT:
;	CALL	BCOMM
	LXI	D,DONMES
	MVI	C,PRINT
	CALL	BDOS
GOBAK:
	
;NOW RESET THE DISK CONTROLLER BACK TO ITS' POINT OF ORIGIN

	LDA	TO
	STA	CURDRV
	CALL	PHOME

	LDA	FROM
	STA	CURDRV


HNIT:
	CALL	PHOME
	LXI	B,1
	CALL	SETSEC
	LXI	B,0
	LDA	CURDRV
	MOV	C,A
	MVI	E,0FFH
	CALL	SELDSK
	LXI	B,RDMADD
	CALL	SETDMA
	CALL	HOME
	CALL	READ

PIEND:
	LDA	TO
	STA	CURDRV
;	CALL	PHOME

	LXI	D,MOREMS
	MVI	C,9
	CALL	BDOS
	MVI	C,GCON
	CALL	BDOS
	CPI	'Y'
	JZ	SIGON
	CPI	'y'
	JZ	SIGON


	LXI	D,SYSMES
	MVI	C,9
	CALL	BDOS
	MVI	C,GCON
	CALL	BDOS
	JMP	0


MOREMS:

.BYTE	CR,LF,LF

.ASCII	\Copy another set of disks (Y/N) $\


SYSMES:

.BYTE	CR,LF,LF

.ASCII	\Make sure a SYSTEM DISKETTE is in drive A then type <CR> $\


EEXIT:
	CALL	HOME
	LXI	D,BADMES
	MVI	C,PRINT
	CALL	BDOS
	JMP	GOBAK
DSKNIT:

;	CALL	BCOMM
	LDA	FROM	
	STA	CURDRV
	CALL	PHOME
	RET


;SET DRIVE TO HOME TRACK

PHOME:
	LDA	CURDRV		;GET CURRENT DRIVE
	LXI	B,0
	MOV	C,A
	MVI	E,0
	CALL	SELDSK		;SET DISK
	LXI	B,0
	CALL	SETTRK		;SET TRAK 0
	LXI	B,1
	CALL	SETSEC		;SET SECTOR
	LXI	B,TADDO
	CALL	SETDMA		;SET DMA
	CALL	READ
	RET

	
;ROUTINE TO GET DDB FROM A DRIVE


DDBIN:
	CALL	PHOME		;HOME THE DIRVE
	LXI	B,0		;SET BC TO ZERO
	CALL	SETTRK		;CALL SET TRACK
	LXI	B,DDBB		;SET BC TO DDB BUFFER AREA
	CALL	SETDMA		;CALL SET DMA
	LXI	B,0		;SET BC TO ZERO
	LXI	H,CURDRV	;POINT HL TO CURRENT DRIVE
	MOV	C,M		;PUT IN C
	MVI	E,0
	CALL	SELDSK		;CALL SELECT DISK
	LXI	B,32		;POINT TO SECTOR 32
	CALL	SETSEC		;CALL SET SECTOR
	CALL	READ		;DO A DISK READ
	LXI	H,DDBB+10	;POINT TO SIDES BYTE
	MOV	A,M
	ANI	2		;SEE IF TWO SIDES
	JRNZ	TWOSID
	MVI	A,76
	STA	TRKS
	JMP	MORET
TWOSID:	MVI	A,151
	STA	TRKS
MORET:	LXI	H,DDBB+16	;POINT TO # OF USER SECTORS IN DDB	
	MOV	A,M		;PUT INTO ACC.
	STA	NDSR		;SAVE IT HERE
	LXI	H,DDBB+14	;POINT TO SYSTEM SECTORS
	MOV	A,M
	STA	SYSSEC

;NOW GET LENGTH OF USER TRACK IN HL

	LDA	NDSR		;GET CP/M SECTORS
;	DCR	A
	LXI	H,0		;CLEAR HL
	LXI	D,128		;ONE CP/M SECTOR
GETLEN:	DAD	D		;PUT INTO HL
	DCR	A		;COUNT DOWN
	JRNZ	GETLEN		;DO NEXT
	SHLD	TLENS		;ELSE SAVE HERE
	RET


GETSKW:

	LDED	TTAB		;POINT TO TRANS TABLE
	CALL	SECTRA
BACK:	PUSH	H
	POP	B
	RET

;CONVERT THE BYTE IN C REG. TO TWO HEX NIBBLES AND PRINT


HEX:
	PUSH	B
	LXI	D,TRKMES
	MVI	C,PRINT
	CALL	BDOS
	POP	B
	CALL	HEX1
	MVI	A,CR
	CALL	COUT
	RET


HEX1:	MOV	A,C
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC
	ORI	30H
	CALL	COUT
	MOV	A,C
	ANI	0FH
	CPI	10
	JRNC	ALPH
	ORI	30H
	CALL	COUT
	MVI	A,20H
	CALL	COUT
	RET
ALPH:	SUI	9
	ORI	40H
	CALL	COUT
	MVI	A,20H
	CALL	COUT
	RET

COUT:
	PUSH	B
	MOV	E,A
	MVI	C,WCON
	CALL	BDOS
	POP	B
	RET



;****************************************************
; GET A CHARACTER FROM THE CONSOLE. IF THE CHARACTER
; IS UNACCEPTABLE, BEEP AND WAIT FOR ANOTHER. RETURN
; TO CP/M IF ^C IS ENTERED. (BDOS DOES RETURN ON ^C)
;****************************************************
; THE CCIR Z80 INSTRUCTION CHECKS ALL ACCEPTABLE
; CHARACTERS FROM THE TABLE POINTED TO BY HL
; A BAD INPUT CAUSES A BELL, PLUS A BACKSPACE
; BLANK-OVER AND BACKSPACE TO ERASE THE WRONG
; INPUT ON CONSOLE, THEN THE ROUTINE IS RE-ENTERED
;====================================================

GETOK:	
..RTRY:	PUSH	H	;SAVE OK TABLE ADDR
	MOV	C,M	;GET COUNT
	INX	H
	MVI	B,0
	CALL	CI	;GET A CHAR
	CPI	'Q'	;IS IT QUIT 
	JZ	0	;YES, GO BACK TO CP/M
	CCIR		;IS IT OKAY
	POP	H
	RZ		;YES, RETURN IT

	MVI	C,BELL	;NO, RING BELL
	CALL	CO
	MVI	C,8	;BACK SPACE
	CALL	CO
	MVI	C,' '
	CALL	CO
	MVI	C,8
	CALL	CO
	JMP	..RTRY	;KEEP TRYING

;***************************************************
;       GET A CHARACTER FROM THE CONSOLE.
;***************************************************

CI:	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,GCON	;CONSOLE INPUT
	CALL	BDOS	;GET THE CHARACTER
	POP	H
	POP	D
	POP	B
	RET

;**************************************************
;      WRITE A CHARACTER TO THE CONSOLE.
;**************************************************

CO:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	A,C
	ANI	7FH
	MOV	E,A	;MOVE CHARACTER TO E
	MVI	C,2	;CONSOLE OUTPUT
	CALL	BDOS	;OUTPUT THE CHARACTER
	POP	H
	POP	D
	POP	B
	MOV	A,C	;FIX UP ACC
	RET


OKDISK:	.BYTE	6,'A','B','C','D','Q',3

OKMES1:	.BYTE	4,'D',CR,'Q',3

OKYES:	.BYTE	4,'Y','N',CR,3

OKR:	.BYTE	4,CR,'R','Q',3

BADDDB:	LXI	D,DBJNK
	MVI	C,PRINT
	CALL	BDOS
	JMP	EEXIT

DBJNK:	.BYTE	LF,CR
	.ASCII	\Disks are not of same format, please check $\




BADMES:

	.BYTE	LF,CR,LF,CR
	.ASCII	\                  Disk backup terminated$\


DONMES:

	.BYTE	LF,CR
	.ASCII	\                  Disk backup completed $\


TRKMES:	.ASCII	\                     copying track $\

MESS1:

   	.BYTE 	1AH,LF,CR
	.ASCII	\                VFCOPY  Disk Backup V 1.1\

	.BYTE	LF,CR,LF,CR

	.ASCII	\                            OPTIONS\
	.BYTE	CR,LF,LF


	.ASCII	\                1- Press the RETURN key to...\
	.BYTE	CR,LF,LF

	.ASCII	\Copy ALL information from drive A to the diskette in drive B.\
	.BYTE	CR,LF,LF

	.ASCII	\                2- Press the "D" key to...\
	.BYTE	CR,LF,LF

	.ASCII	\Select some other drive to copy from/to\
	.BYTE	CR,LF,LF

	.ASCII	\                3- Type the "Q" key to...\
	.BYTE	CR,LF,LF

	.ASCII	\QUIT this program now.\
	.BYTE	CR,LF,LF,'$'
	

ATOBOK:
	.BYTE	1AH
	.ASCII	\Insert your LATEST disk in drive A and your OLDEST backup disk in drive B.\
	.BYTE	CR,LF,LF
	
	.ASCII	\ OK to continue (Y/N) ?  $\
	
SYSSKW:	.BYTE	1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
	.BYTE	18,19,20,21,22,23,24,25,26,27,28,29,30
	.BYTE	31,32,33,34,35,36,0FFH


MAKSKW:
	LDA	NDSR1		;GET # SECTORS
	MOV	C,A		;SAVE FOR COMPARE
	MVI	A,0
	LXI	H,SKEWTB	;POINT TO TABLE	
..NXT1:	MOV	M,A
	INX	H
	INR	A
	CMP	C
	JRNZ	..NXT1
	XRA	A
	CMA
	MOV	M,A
	RET


;BIOS ACCESS POINTS NEXT

HOME:
	CALL	0
	RET
SELDSK:
	CALL	0
	RET
SETTRK:
	CALL	0
	RET
SETSEC:
	CALL	0
	RET
SETDMA:
	CALL	0
	RET
READ:
	CALL	0
	RET
WRITE:
	CALL	0
	RET


SECTRA:
	CALL	0
	RET


SKEWTB:	.BLKB	88
	.BYTE	0FFH		;MARK TABLE END


;PROGRAM STORAGE


RETRY5:	.BLKB	1
SPSAV:	.BLKW	1		;SAVE ALL REGS. IN THESE
HLSAV:	.BLKW	1		;TEN BYTES
DESAV:	.BLKW	1
BCSAV:	.BLKW	1
AFSAV:	.BLKW	1
	
RTNTRK:	.BLKW	1
CTLBYT:	.BLKW	1
VERFLG:	.BYTE	1

BOTVEC:	.BLKW	1		;BOOT O.K. LABEL
ALTB1:	.BYTE	0,'B'		;"B" FOR A:
ALTB2:	.BYTE	0,'B'		;"B" FOR B:
ALBONE:	.BLKW	1		;FIRST LABEL ON A
ANS1:	.BYTE	0		;SPECIAL "B" FORMAT ALLOWED
ACOP:	.BLKW	1		;VALUE OF "A" DISK #
CPFLG:	.BYTE	0		;DISK "A" COPIED FLAG
CURTRK:	.BLKW	1		;CURRENT TRACK
TTAB:	.WORD	DDBB+32		;POINTER TO XLATE TABLE
SKWPTR:	.BLKW	1		;POINTER TO SKEW TABLE
NXTSEC:	.BLKW	1		;NEXT SECTOR TO R/W
SOURCE:	.BLKB	1		;SOURCE DRIVE
DESTIN:	.BLKB	1		;DESTINATION DRIVE
SCOUNT:	.BYTE	1		;SECT. COUNT 
STRK:	.BYTE	0		;INITIAL TRACK
TADD:	.BLKW	1		;CURRENT DMA ADDRESS
BLOC:	.BLKW	1		;POINTER TO BIOS
TLENS:	.BLKW	1		;TRACK LENGTH IN BYTES
DPSAV:	.BLKW	1		;DPH POINTER
NDSR:	.BLKB	1		;NUMBER OF USER SECTORS
CURDRV:	.BLKB	1		;CURRENT DRIVE
NDSR1:	.BLKB	1		;NUMBER OF SECTORS ON A:
TLENS1:	.BLKW	1		;TRACK LENGTH ON A:
LABA:	.BLKW	1		;SAVED DRIVE A: LABEL
LABB:	.BLKW	1		;SAVED DRIVE B: LABEL
TRKS:	.BLKB	1		;NUMBER OF DISK TRACKS
TNDSR:	.BLKB	1		;TEMP. # OF USER SECTORS
LABNAM:	.BLKW	1		;NAME OF LABEL TO WRITE
RTADD:	.BLKW	1		;POINTER TO READ DMA ADDRESS
SYSSEC:	.BLKB	1		;# OF SYSTEM SECTORS



DDBB:
	.BLKB	128	;DDB READ BUFFER


DDB1:
	.BLKB	128	;DRIVE B DDB BUFFER



DDBPRM:	.BLKB	128		;PASS 1 DDB SAVE FOR DRIVE A:		


DDB2:	.BLKB	128		;DRIVE B: DDB


TADDO:	.BLKB	128		;OPTIONAL DMA R/W ADDRESS


TADD1:	.BLKB	128		;DMA XFER ADDRESS FOR WRITE FILE
	
TADD2:	.BLKB	128		;DMA XFER ADDRESS FOR READ	


NDMADD:				;DMA SAVE ADDRESS FOR FILE SAVE
				;NOT IMPLEMENTED

RDMADD:				;READ DMA TRACK BUFFER



VDMADD	==	RDMADD+11000	;POINTER TO VERIFY DATA BUFFER



	.END
