;********************************************************
;*                         V2BOOTX
;*                MINIMAL COLD BOOT LOADER	        *
;*                          FOR
;*                VERSAFLOPPY II BOOT STRAP
;*                FOR MINI-FLOPPY DRIVES
;*                BOOTS FIRST FLOPPY DRIVE
;********************************************************

;THIS BOOTSTRAP READS THE FIRST SECTOR FROM TRACK 1
;THE CODE CAN BE LOCATED ANYWHERE IN RAM, AS IT USES
;Z80 RELATIVE ADDRESSING
;!!!! HOWEVER !!!!!!
;IT IS SHOWN HERE ORG'ED AT 200H!
;THE REASON IS THAT, IT MUST NOT BE OVER-WRITTEN BY THE
;BOOT SECTOR, WHICH USES 0000H TO 01FFH
;SO, IN OTHER WORDS, IT SHOULD BE LOACTED ANYWHERE
;AT OR ABOVE 200H
;
	.XLINK
	.Z80		;Z80 OPCODES USED
	.PHEX
	.PABS


	.PAGE

BDOS	==	5
CR	==	13
LF	==	10
BELL	==	7

; PORT ADDRESSES.

DCMD	==	063H	;DMA DISC CONTROL PORT
WDC	==	064H	;WDC 179X BASE ADDRESS
WCMD	==	WDC+0	;COMMAND REGISTER
WSTAT	==	WDC+0	;STATUS REGISTER
WTRACK	==	WDC+1	;TRACK REGISTER
WSECT	==	WDC+2	;SECTOR REGISTER
WDATA	==	WDC+3	;DATA REGISTER

GETCON	==	1	;GET CONSOLE
PRINTS	==	9	;BDOS PRINT STRING
GCSTAT	==	11	;GET CONSOLE STATUS


BOOT	==	0	;TRACK LOADER GOES HERE

	.LOC	200H

; FUNCTION TO TURN OFF ANY ONBOARD RAM/ROM
; REMOVE ; IF YOU HAVE THE CORRECT CPU CARD
; ELSE INSERT CODE FOR YOUR SYSTEM

;	MVI	A,2	;SBC-200 RAM/ROM BIT
;	OUT	7FH	;TURN ONBOARD RAM/ROM OFF

;	OUT	0AH	;FOR ZEUS ROM DISABLE

	MVI	A,1EH	;SELECT DRIVE 0, LOWER HEAD, 5", DOUBLE DENSITY
	OUT	DCMD		

RETRY:
	LXI	H,BOOT
..HOME:
	MVI	A,0BH	;RESTORE DRIVE
	OUT	WCMD	;SEND TO CONTROLLER
	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT

..NB:	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY (y/n)
	JRNZ	..NB	;YES,KEEP WAITING

	MVI	A,1	;START WITH SECTOR 1
	OUT	WSECT	;SET SECTOR REG
SECTOR:
	MVI	A,88H	;ISSUE READ SECTOR COMMAND 
	OUT	WCMD
	LXI	B,0067H	;SET UP BC FOR PIO READ NEXT
	INIR		;DO PIO SECTOR READ
	INIR

	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT

..NB:	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY (y/n)
	JRNZ	..NB	;YES,KEEP WAITING
	ANI	9DH	;WAS READ SUCCESSFUL(y/n)
	JZ	BOOT	;GET SYSTEM
	JMPR	RETRY

	.END
