;*****************************************************
;*                   V2XIOS60.ASM                    *
;*                   F.D.D. XIOS                     *
;*                   Z80 DMA (OPTION)                *
;*           	     FDD INTERRUPTS (OPTION)	     *
;*                   BRUCE JONES                     *
;*                   12/15/2003                      *
;*****************************************************
 

	.Z80
	.PABS
	.PHEX
	.XLINK
	.XSYM
	
;****************************************************
;              CAPTURE ASSEMBLY DATA
;****************************************************

;THE MPM1 VAR IS HERE SET FOR BANKED MP/M 2.X OPERATION
;NOTE: SAFE TO KEEP, EVEN IF MP/M 2.X IS RUN UNBANKED
;IF RUNNING MP/M 1.X, WITH UNBANKED BDOS, SET TO 0

MPM1	==	1

	.IFE	MPM1,[
BNKIOS	==	1
		][
BNKIOS	==	0
	]



; ASSEMBLE TWICE FOR LOC VAR. SET TO 0 FIRST FOR LOC 0
; AFTER FIRST ASSEMBLEY, RENAME:
; EG: REN XIOS30A.HEX=XIOS30.HEX
; NEXT ASSEMBLE WITH LOC VAR SET TO 1, FOR 100H
; NOW COMBINE AS FOLLOWS:
; PIP XIOS30W.HEX=XIOS30A.HEX,XIOS30.HEX
; NOW MAKE THE SYSTEM-PAGE-RELOCATABLE IMAGE:
; GENMOD XIOS30W.HEX BNKXIOS.SPR

;VFII	=\	\ENTER 0 FOR VERSAFLOPPY II, 1 IF NOT       \

LOC	=\	\ENTER 0 FOR .LOC 0 OR 1 FOR .LOC 100H      \

VDBCON	=\	\ENTER 0 FOR VDB-8024 OR 1 IF SBC-200 USART  \

PIO	=\	\ENTER 0 FOR PIO OR 1 FOR Z80-DMA           \


.IFN	PIO,[
	
FLPINT	=\	\ENTER 0 TO USE FDC INTERRUPTS, 1 IF NOT    \
		][
FLPINT	==	1
		]

FIXFLP	=\	\ENTER 0 IF USING MPMPLUS (FLOPPIES NOT REMOVEABLE), ELSE 1 \


OPTION	=\	\ENTER 0 FOR MORE OPTIONS, 1 IF NOT         \


	.IFE	OPTION,[


NODSK	==	2
CONNR	==	8
BNKUNT	==	8
TYPLP	==	0

CONLST	=\	\ENTER 0 CONSOLE #2 NORMAL, 1 IF PRINTER    \
LDOPT	=\	\ENTER 0 STANDARD HEAD LOAD OR 1 IF DUAL    \

HSTRW	==	1

STEPS0  =\	\ENTER STEP RATE ,0=3MS, 1=6MS, 3=15MS

FOR DRIVE A \

STEPS1	=\	\FOR DRIVE B \
STEPS2	=\	\FOR DRIVE C \
STEPS3	=\	\FOR DRIVE D \

	][

NODSK	==	2

CONNR	==	8
BNKUNT	==	8	;8 MEMORY SEGMENTS
CONLST	==	0	;CONSOLE #2 NORMAL
LDOPT	==	0	;STANDARD HEAD LOAD
TYPLP	==	0	;SET AS CENTRONICS
HSTRW	==	1	;1024 BYTE SECTORS
STEPS0	==	0
STEPS1	==	0
STEPS2	==	0
STEPS3	==	0
	]


	.IFE LOC,[	

	.LOC	0
	][
	.LOC	100H

	]


PLDSK	== 	16	; POLL DISK.
PLDMA	== 	17	; POLL DMA IN PROGRESS.
PRELST	==	17	; DEV # EQUAL TO LAST DISK DEV.

DSKFLG	==	5	;XDOS FLAG FOR DISK END

TRUE	==	0FFFFH	;TRUE AND FALSE VALUES
FALSE	==	#TRUE

Z3S	==	TRUE	;THIS VERSION FOR THE Z3S BOARD

NDISKH	==	0	;NO HARD DISK
NDISKF	==	NODSK	;MAXIMUM NUMBER OF FLOPPYS
NDISKT	==	NDISKH+NDISKF ;TOTAL NUMBER OF DISKS


CR	==	0DH
LF	==	0AH
BELL	==	07H
CLEAR	==	1AH



;****************************************************
;             FLOPPY DISK EQUATES.
;****************************************************
;****************************************************
;            PIO CONTROLLER PORTS
;****************************************************

DCMD	==	63H	;Z3S COMMAND/CONTROL PORT
W	==	64H	;WDC 179X ADDRESS
WCMD	==	W+0	;COMMAND PORT
WSTAT	==	W+0	;STATUS PORT
WTRACK	==	W+1	;TRACK REG
WSECT	==	W+2	;SECTOR REG
WDATA	==	W+3	;DATA I/O REG


;************* NOTE ON TARBELL DD DMA FDC *************
;
; THE TARBELL DD DMA CONTROLLER USED TO BE 'LIGHTLY'
; RE-WIRED TO SET THE WD 179X PORTS THE SAME AS THE
; Z4S AND VF II ADDRESSES. ALSO SOME SELECTION BITS
; FOR DRIVE SELECTION/MODE WERE RE-WIRED.
; AT STARTUP, THE XIOS CHECKED FOR AN INTEL 8257
; DMA CHIP. IF IT WAS FOUND, THE SAME CODE WAS USED
; FOR ALL DISK I/O, EXCEPT ACTUAL SECTOR DATA TRANSFERS
; IN WHICH CASE THE DMA CHIP HANDLED THAT.
; THUS A PIO OR DMA CONTROLLER COULD BE INSERTED IN
; THE SYSTEM WITH NO NEED TO CHANGE A BIOS OR XIOS.
;
; FOR NOW THE 'PARALLEL' 8257 DMA CODE IS REMOVED AND
; NO TEST FOR A TARBELL FDC IS PERFORMED. THIS COULD
; CHANGE FOR A LATER VER. XIOS. 
;
; SUPPORTED IS AN ADD-ON Z80 DMA CHIP THAT PERFORMS
; DMA SECTOR TRANSFERS, AND IT CAN BE ADAPTED TO MANY
; FLOPPY CONTROLLERS, SUCH AS S-100 OR 'DROP-ON'. 
;
; IN ANY CASE, A DMA DISK TRANSFER ALLOWS MP/M TO
; FUNCTION MOST EFFICIENTLY, ESPECIALLY WHEN COMBINED
; WITH AN END-OF-OPERATION INTERRUPT FLAG FOR ALL 
; DISK TRANSFERS.
;
;******************************************************

;****************************************************
;          TARBELL 8257 DMA CONTROLLER PORTS
;****************************************************

CMND	==	078H	;DMA COMMAND PORT
WCTO	==	071H	;DMA WORD COUNT PORT
ADRO	==	070H	;DMA ADDRESS PORT
DMACHK	==	062H	;DMA STATUS PORT


;****************************************************
;          TARBELL 8257 DMA CONTROLLER COMMANDS
;****************************************************

RD	==	04H	;DMA WRITE INTO MEMORY
WR	==	08H	;DMA READ FROM MEMORY



;****************************************************
;           Z80 DMA PORT ADDRESS
;****************************************************

Z80DMA	==	0F8H	;A SINGLE PORT ADDRESS


;****************************************************
;        COMMON 179X CONTROLLER COMMANDS
;****************************************************

WHOME	==	00001000B ;HOME COMMAND
WREAD	==	10001000B ;READ SECTOR COMMAND
WWRITE	==	10101000B ;WRITE SECTOR COMMAND
WSEEK	==	00011000B ;SEEK TO GIVEN TRACK COMMAND
WUNLD	==	00010000B ;SEEK AND UNLOAD HEAD COMMAND
WLOAD	==	00011000B ;SEEK AND LOAD HEAD COMMAND


;****************************************************
;          COMMON 179X CONTROLLER STATUS
;****************************************************

WBBUSY	==	0	;179X BUSY STATUS BIT
WBSID1	==	1	;SIDE SELECT FLAG COMMAND BIT
WBDEL	==	2	;HEAD SETTLE DELAY COMMAND BIT
WBWRIT	==	5	;READ/WRITE DISTINGUISHING BIT
WBRNF	==	4	;RECORD NOT FOUND STATUS BIT
WSREAD	==	10011100B ;READ SECTOR STATUS MASK
WSWRIT	==	11111100B ;WRITE SECTOR STATUS MASK
WSSEEK	==	10011000B ;SEEK STATUS MASK
WFCINT	==	11010000B ;FORCE INTERRUPT COMMAND


;*****************************************************
;*          BIOS  DISK I/O ERROR TYPES
;*****************************************************

ERR1	==	1	;   WARM BOOT
ERR2	==	2	;   READING DDB
ERR3	==	3	;   BUFFERED READ
ERR4	==	4	;   UNBUFFERED READ
ERR5	==	5	;   UNBUFFERED WRITE
ERR6	==	6	;   PREREAD FOR BUFFERED WRITE
ERR7	==	7	;   BUFFERED WRITE
ERR8	==	8	;   PHYSICAL I/O (SOFT ERROR)


;********************************************************
;*      ALLOCATION & CHECKSUM VECTOR SIZES
;********************************************************

	ALVLN	==	108	;FOR 1.56 MEG TO 1.7 MEG
	CKSLN	==	64	;FOR 256 DIR. ENTRIES



	.PAGE
;***********************************************
;*       MP/M XIOS ENTRY VECTOR ADDRESSES 
;***********************************************

START:			; REFERANCE FOR MP/M 1.1	

	JMP	CLDST	; COLD START.
	JMP	WRMST	; WARM START.
	JMP	CONST	; CONSOLE STATUS.
	JMP	CONIN	; CONSOLE READ.
BIOOUT:	JMP	CONOUT	; CONSOLE WRITE.
	JMP	LIST	; PRINTER.
	JMP	RNTEM	; PUNCH  (NOT IMPLEMENTED).
	JMP	RNTEM	; READER (NOT IMPLEMENTED).
	JMP	HOME	; MOVE HEAD OF SELECTED 
			; DRIVE TO TRACK ZERO.
	JMP	SELDSK	; SELECT DRIVE.
	JMP	SETTRK	; SEEK TRACK NUMBER.
	JMP	SETSEC	; SET SECTOR NUMBER.
	JMP	SETDMA	; SET DIRECT MEMORY ADDRESS.
	JMP	READ	; READ SELECTED SECTOR.
	JMP	WRITE	; WRITE SELECTED SECTOR.
	JMP	POLLPT	; PRINTER STATUS.
	JMP	SECTRA	; SECTOR TRANSLATE.

	JMP	SELMEM	; SELECT MEMORY.
	JMP	POLDEV	; POLL DEVICE.
	JMP	STRCLK	; START CLOCK.
	JMP	STPCLK	; STOP CLOCK.
	JMP	EXIREG	; EXIT REGION.
	JMP	MAXCON	; MAXIMUM CONSOLE.
	JMP	SYSNIT	; SYSTEM INITIALIZATION.
	JMP	IDLE	; SYSTEM IDLE CALL VECTOR.
	


;****************************************************
; RESET DISK SYSTEM. INVALIDATE CERTAIN FLOPPY DISK
; TABLES AND BYTES TO ALLOW CHANGING DISKS. CALLED BY
; COLD BOOT, WARM BOOT, AND SOME EXTERNAL ROUTINES.
;****************************************************

DSKRST:
	XRA	A
	LXI	H,UNACNT ;INVALIDATE UNALLOCATED COUNT
	MVI	B,UNALEN
..LOP:	MOV	M,A
	INX	H
	DJNZ	..LOP
	LXI	H,ACTDSK ;POINT TO # DISKS	
	MOV	B,M	 ;GET NUMBER INTO B
	LXI	D,APBDIS ;GET DISTANCE BETWEEN FD APBS
	LXI	H,APB0+(FLAG-ATABLE) ;POINT TO FLAG
..LOOP:	MOV	M,A	;INVALIDATE ALL FLOPPY DISK
	DAD	D	;   APBS BY CLEARING FLAGS
	DJNZ	..LOOP

	DCR	A
	STA	OLDFLO	;FORCE HEAD UNLOAD/LOAD
	STA	ADISK	;INVALIDATE ATABLE
	RET


;****************************************************
; LOAD HEAD ON CURRENT DISK. NOT YET IMPLEMENTED.
;****************************************************

HEADLD:	RET


;******************************************************
; LOGICALLY SELECT THE DISK DRIVE FOR FUTURE READS AND
; WRITES TO THAT PASSED IN REGISTER C.
;******************************************************

SELDSK:
	MOV	A,C
	LXI	H,ACTDSK;POINT TO ACTUAL DISK #
	CMP	M	;IN RANGE(y/n)
	JNC	..BAD	;NO
	STA	SEKDSK	;D.R. HOST DISK
	STA	PDISK
	PUSH	D	;SAVE MP/M FIRST SELECT FLAG
	MOV	L,C	;GET APB, DPH ADDRESSES
	CALL	GETDPH
	SDED	APBADR	;SAVE APB ADDRESS
	SHLD	DPHADR	;SAVE DPH ADDRESS
	CALL	GETAPB	;GET ATABLE FOR THIS DISK
	POP	D	;RECOVER MP/M FIRST SELECT FLAG
	BIT	0,E	;PREVIOUSLY SELECTED ?
	JRZ	..FRST	;NO,FORCE DDB READ

	LDA	FLAG
	ORA	A	;DDB PROCESSED (y/n)
	JNZ	..OK	;YES

..FRST:
	CALL	CLOSE	;ELSE CLEAR ANY PENDING WRITE
	XRA	A	;WE WILL READ FROM TRACK 0
	STA	PTRACK
	MVI	A,8	;AND SECTOR 8
	STA	PSECT
	LXI	H,RDBUFF ;INTO THE READ BUFFER
	SHLD	PDMA

	LDA	ADISK	;GET DISK NUMBER
	LXI	H,SPDTAB ;POINT TO STEP SPEED TABLE
	MOV	E,A
	MVI	D,0
	DAD	D
	MOV	A,M	;GET SPEED BYTE FOR THIS DISK
	MOV	B,A
	ANI	3	;ISOLATE SPEED BITS
	MOV	H,A
	MVI	L,0FFH	;CURRENT TRACK - UNKNOWN
	SHLD	TRACK	;UPDATE ATABLE TRACK AND SPEED


;****************************************************
;          ASSUME 8" S.S.S.D. DISK NEXT
;****************************************************

	MVI	A,00000001B ;INITIAL FLAG FOR 8" DRIVE
	LXI	H,STDDDB ;STANDARD 8" DDB ADDRESS

..EIG:	STA	FLAG
	SHLD	SAVADR

	LXI	H,1	;AT LEAST 1 SYSTEM TRACK
	SHLD	OFF
	LXI	H,2+32<8 ;512 BYTE PHYSICAL SECTOR LEN,
	SHLD	SSLEN	;   AT LEAST 32 LOGICAL SECTORS

	CALL	GETD3S	;GET Z3S CTRL BYTES INTO ATABLE
	CALL	PREAD	;GET THE DDB
	JRNC	..YUP	;WE GOT SOMETHING


;****************************************************
; IF ERROR IS R.N.F. THEN SHOW DISK READ FAILED
; ELSE TEST IT FOR GOOD DISK TYPE
;****************************************************

	BIT	WBRNF,A	;RNF ERROR(y/n)
	JRZ	..ERR	;NOPE, GIVE UP


;****************************************************
;    SET UP FOR STANDARD 8" S.S.S.D.  DISK HERE
;****************************************************

..NOV:

	LHLD	SAVADR	;POINT TO STANDARD DDB
	LXI	B,128-10
	LXI	D,RDBUFF+384+10
	LDIR		;FIX RD BUFFER TO BE A STD DDB
	JMPR	..COMP

..YUP:	LHLD	RDBUFF+384 ;GET VALIDITY BYTES FROM DDB
	LXI	D,0DDH+0FDH<8 ;EXPECTED VALUE OF BYTES
	ORA	A
	DSBC	D	;DDB VALID(y/n)
	JRNZ	..NOV	;NOPE
	LHLD	RDBUFF+384+2 ;MORE VALIDITY BYTES
	DSBC	D	;DDB VALID(y/n)
	JRNZ	..NOV	;NOPE

	LDA	RDBUFF+384+4 ;TEST FOR COMPATIBILITY
	ANI	11111110B
	JRNZ	..BAD	;GIVE UP ON THIS DISK

..COMP:	CALL	PUTAPB	;UPDATE TRACK, SPEED IN APB


;IF THE FLOPPY DISKETTES ARE TO BE TREATED AS FIXED, THEN
;THEY ARE MARKED AS SUCH. USED IF MPMPLUS DIRECTORY CACHING
;IS USED BY SYSTEM.

	.IFE	FIXFLP,[

	LXI	H,RDBUFF+384+28	;SET CKS AS 8000H FOR MP/M
	LXI	D,8000H
	MOV	M,E
	INX	H
	MOV	M,D
			]


	LHLD	APBADR	;GET APB ADDR FOR THIS DISK
	LXI	D,FLAG-ATABLE ;POINT TO WHERE FLAG GOES
	DAD	D
	XCHG		;MAKE THIS THE DESTINATION ADDR
	LXI	H,RDBUFF+384+10 ;FROM FLAG IN RD BUFFER
	LXI	B,ALEN-(FLAG-ATABLE)+DPBLEN+TRALEN
	LDIR		;MOVE DDB, DPB, TRANS INTO APB


;***************************************************
;*           NOW SET UP ALLOCATION SIZE
;*           FOR THE DISK JUST SELECTED
;* GET THE ALLOCATION SIZE FROM THE DSM VALUE IN
;* THE DPB
;***************************************************

	LDA	RDBUFF+384+19	;GET BSH
	MOV	C,A	;SAVE VALUE
	LDA	SEKDSK
	MOV	E,A
	MVI	D,0
	LXI	H,ALOCSZ
	DAD	D
	MOV	M,C	;SAVE FOR THIS DISK

	MVI	A,0FFH	;UPDATE ATABLE FROM APB
	STA	ADISK
	CALL	GETAPB
	CALL	GETD3S	;PUT VALID Z3S BYTES IN ATABLE
	CALL	PUTAPB	;UPDATE APB FROM
			;   FULLY VALID ATABLE

..OK:	LHLD	DPHADR	;RETURN DPH ADDRESS
	RET

..ERR:

..BAD:	XRA	A	;DESELECT INVALID DRIVE
	MOV	H,A	;ERROR RETURN CODE
	MOV	L,A
	RET


;*******************************************************
; SET TRACK FOR FUTURE READS OR WRITES TO TRACK 0. ALSO
; PARTIALLY RESET THE DISK SYSTEM TO ALLOW FOR CHANGED
; DISKS.
;*******************************************************

HOME:
	CALL	CLOSE
	LDA	HSTWRT	;TEST FOR PENDING WRITE
	ORA	A
	JRNZ	HOMED
	STA	HSTACT	;CLEAR HOST ACTIVE FLAG
HOMED:
	LXI	B,0	;DROP THRU TO SET TRACK TO 0


;****************************************************
; SET TRACK FOR FUTURE READS OR WRITES TO THAT PASSED
; IN REGISTER PAIR BC.
;****************************************************

SETTRK:	SBCD	SEKTRK
	RET


;*****************************************************
; SET SECTOR FOR FUTURE READS OR WRITES TO THAT PASSED
; IN REGISTER PAIR BC.
;*****************************************************

SETSEC:	SBCD	SEKSEC
	RET


;****************************************************
; SET DMA ADDRESS FOR FUTURE READS OR WRITES TO THAT
; PASSED IN REGISTER PAIR BC.
;****************************************************


SETDMA:
	.IFE	MPM1,[
	SBCD	DMAADD	;SET DMA ADDRESS
	RET
	][

; FOR MP/M 2.X, A DMA VALUE OF FFFFH SIGNALS THE
; NEED TO FLUSH THE LOCAL DISK BUFFER

	SBCD	DMAADD
	INX	B	;COUNT UP TO SET
	MOV	A,C
	ORA	B	;TEST FOR (WAS) 0FFFFH
	RNZ
	CALL	CLOSE	;IF SO CLOSE WRITE BUFFER
	RET
	]


;****************************************************
; SECTOR TRANSLATION ROUTINE. THE ROUTINE ONLY
; TRANSLATES SECTORS ON THE USER TRACKS, SINCE MP/M
; ACCESSES THE SYSTEM TRACKS WITHOUT CALLING FOR
; TRANSLATION.
;****************************************************

SECTRA:

..YUP:	XCHG		;HL GETS TRANS TABLE ADDRESS
			;MP/M PASSED IT IN DE

	MOV	A,C	;GET SECTOR #
	SBCD	NEWSEC	;SAVE FOR UNALLOC TEST
	

	DAD	B	;INDEX INTO TABLE, LOGICAL SECTOR
			;IS PASSED IN BC
			
	MOV	L,M	;GET THE TRANSLATED BYTE
	MVI	H,0
	RET


ACTDSK:	.BYTE	NODSK
HLDOPT:	.BYTE	LDOPT

;******************************************************
;         MP/M ENTRY POINT FOR SECTOR READS
;******************************************************

READ:
	XRA	A
	STA	UNACNT	;UNACNT=0, WE WON'T WRITE WITHOUT
			;PRE-READS FOR NOW
	INR	A	
	STA	READOP	;SHOW WE ARE DOING A READ OPERATION
	STA	RSFLAG	;MUST READ DATA
	MVI	A,2
	STA	WRTYPE	;TREAT AS UNALLOCATED

	JMP	RWOPER	;DO THE READ


;******************************************************
;       MP/M ENTRY POINT FOR SECTOR WRITES
;******************************************************

WRITE:
	XRA	A
	STA	READOP	;SET TO WRITE
	MOV	A,C
	STA	WRTYPE	;SAVE TYPE OF WRITE
	ANI	2	;WRITE UNALLOCATED(y/n)
	JRZ	..CKUN	


	LDA	ALOCA	;GET MAXIMUM UNALLOCATED RECORD COUNT
	STA	UNACNT	;AND PUT HERE FOR WRITING
	LDA	SEKDSK	;GET CURRENT DISK
	STA	UNADSK
	LHLD	SEKTRK	;GET CURRENT TRACK
	SHLD	UNATRK
	LDA	NEWSEC	;GET CURRENT MP/M SECTOR
	STA	UNASEC

..CKUN:			;SEE IF UNALLOCATED RECORDS REMAIN

	LDA	UNACNT	;GET UNALLOCATED RECORDS LEFT
	ORA	A
	JZ	..ALOC	;NO UNALLOCATED LEFT


;WE STILL HAVE UNALLOCATED RECORDS LEFT

	DCR	A	;UPDATE UNALLOCATED RECORD COUNT
	STA	UNACNT


;NOW CHECK FOR CORRECT DISK, TRACK & SECTOR

	LDA	SEKDSK	;COMPARE DISKS FIRST
	LXI	H,UNADSK
	CMP	M
	JNZ	..ALOC


;DISKS ARE SAME, NOW CHECK FOR TRACK

	LXI	H,UNATRK
	LDA	SEKTRK
	CMP	M
	JRNZ	..ALOC


;TRACKS ARE SAME, NOW TEST FOR SECTOR

	LDA	NEWSEC	;COMPARE SECTORS NOW
	LXI	H,UNASEC
	CMP	M
	JRNZ	..ALOC


;SECTORS ARE SAME, NOW UPDATE PARAMETERS

	INR	M	;MAKE NEXT EXPECTED SECTOR
	MOV	A,M	;GET NEXT EXPECTED SECTOR
	LXI	H,ULRPS	;POINT TO SECTORS/USER TRACK
	CMP	M	;TEST FOR END OF TRACK
	JRC	..NOVR	;NO OVERFLOW


;HERE WE ALLOW FOR NEXT UNALLOCATED RECORD ON A NEW TRACK

	XRA	A	;SET SECTOR AS FIRST
	STA	UNASEC
	LXI	H,UNATRK;POINT TO UNALLOCATED TRACK #
	INR	M	;MAKE IT NEXT ONE


;WRITE PARAMETERS MATCH, DON'T PRE-READ

..NOVR:
	XRA	A
	STA	RSFLAG	;SHOW WE DON'T READ A SECTOR
	JMPR	RWOPER


;NOT AN UNALLOCATED RECORD, DO A PRE-READ

..ALOC:
	XRA	A
	STA	UNACNT	;SET UNALLOCATED = 0
	INR	A
	STA	RSFLAG	;RSFLAG = 1, WE MUST READ THE SECTOR


;DO READ OR WRITE OPERATION NEXT

RWOPER:

	CALL	GETTRK	;COMPUTE PHYSICAL TRACK & SECTOR

	LXI	H,HSTACT;GET HOST ACTIVE FLAG
	MOV	A,M	
	MVI	M,1	;SET IT ACTIVE FOR SURE
	ORA	A	;SEE IF IT WAS ACTIVE
	JZ	FILHST	;IF NOT FILL IT
	

;***********************************************************
;* CHECK TO SEE IF SECTOR IN HOST BUFFER TO R/W IS CORRECT
;* IF NOT WRITE TO HOST BUFFER IF NEEDED & PREPARE FOR 
;* CORRECT HOST BUFFER
;***********************************************************

;SEE IF DISKS ARE SAME

	LDA	SEKDSK	;COMPARE DISKS FIRST
	LXI	H,HSTDSK
	CMP	M
	JRNZ	NOMAT


;SEE IF TRACKS ARE SAME

	LXI	H,HSTTRK
	LDA	CTRACK
	CMP	M
	JRNZ	NOMAT


;SEE IF SECTORS ARE SAME

	LDA	SEKHST	;COMPARE SECTORS NOW
	LXI	H,HSTSEC
	CMP	M
	JRZ	MATCH


;HOST PARAMETERS DO NOT MATCH CURRENT R/W PARAMETERS
;SEE IF WE HAVE TO FLUSH THE HOST BUFFER

NOMAT:
	LDA	HSTWRT	;SEE IF HOST BUFFER WAS WRITTEN
	ORA	A
	CNZ	FLUSH	;WRITE OUT THE BUFFER IF NOT


;MAY HAVE TO FILL HOST BUFFER SET UP NEW PARAMETERS

FILHST:

	LDA	SEKDSK
	STA	HSTDSK
	LHLD	CTRACK
	SHLD	HSTTRK
	LDA	SEKHST	;THE PHYSICAL SECTOR
	STA	HSTSEC

	LDA	RSFLAG	;SEE IF WE NEED TO READ
	ORA	A
	CNZ	RDHST	;IF SO READ IT
	XRA	A
	STA	HSTWRT	;SHOW NO PENDING WRITE


;WE HAVE CORRECT SECTOR SO COPY DATA TO/FROM DMA BUFFER

MATCH:

	LDA	CREC	;GET RECORD #
	MOV	B,A	;COMPUTE RECORD IN HOST BUFFER
	MVI	C,0
	SRLR	B
	RARR	C
	LXI	H,HSTBUF
	DAD	B	;HL IS NOW HOST BUFFER
	LDED	DMAADD	;DE HAS DMA ADDRESS
	LXI	B,128	;BYTES TO MOVE
	LDA	READOP
	ORA	A	;SEE IF WE ARE READING OR WRITING
	JRNZ	RWMOVE	;SKIP ON READ
	MVI	A,1	;IF A WRITE THEN MARK & COPY TO BUFFER
	STA	HSTWRT	;HSTWRT = 1
	XCHG		;DE IS NOW DESTINATION,= HOST ON WRITE
	LHLD	DMAADD	;HL IS SOURCE, = USER AREA TO GET	

RWMOVE:
	
	DI		;KEEP SYSTEM BANK SWITCHED IN
	JMP	RWMOV	;GO DO DATA MOVE


;WRITE OUT HOST BUFFER IF IT HAS VALID RECORD(S)

CLOSE:
	LDA	HSTWRT	;SEE IF WE HAVE A PENDING WRITE
	ORA	A
	RZ		;IF NOT RETURN NOW


;WRITE FROM THE HOST BUFFER

FLUSH:
WRTHST:
	LDA	HSTDSK	;GET ACTUAL WRITE DISK
	STA	PDISK	;MAKE IT THE PHYSICAL DISK
	CALL	GETAPB	;GET APB FOR THE DISK
	LDA	HSTSEC
	STA	PSECT
	LDA	HSTTRK
	STA	PTRACK
	LXI	H,WRBUFF ;POINT TO WRITE BUFFER
	SHLD	PDMA	;MAKE IT THE PHYSICAL DMA ADDRESS
	
	CALL	PWRITE	;WRITE BACK THE COMBINED SECTOR
	RC		;PRINT FATAL ERROR
	RET		;ALL DONE


RDHST:
	LDA	HSTDSK
	STA	PDISK
	LXI	H,RDBUFF ;POINT TO READ BUFFER
	SHLD	PDMA	;MAKE IT PHYSICAL DMA ADDRESS
	LDA	CTRACK
	STA	PTRACK
	LDA	CSECT
	STA	PSECT

	CALL	PREAD	;READ SECTOR INTO READ BUFFER
	RNC		;RETURN IF READ WAS SUCCESSFUL

	MVI	A,1
	RET


;GET ACTUAL TRACK TO SEEK

GETTRK:
	LDA	SEKTRK	;GET MP/M TRACK NUMBER
	LXI	H,OFF	;GET NUMBER OF SYSTEM TRACKS
	MOV	E,M
	MVI	C,0	;ASSUME SINGLE SIDED DISK
	LXI	H,SSLEN	;POINT TO SYSTEM SECTOR LENGTH
	CMP	E
	JRC	..SYST	;IT WAS A SYSTEM TRACK
	LXI	H,FLAG	;POINT TO FLAG BYTE
	BIT	1,M	;TEST SIDES BIT
	JRZ	..SING	;SINGLE SIDED DISK
	ADD	E	;ADD IN OFFSET
	SRLR	A	;COMPUTE PHYSICAL TRACK NUMBER
	RARR	C	;GET SIDE NUMBER BIT
..SING:	LXI	H,USLEN
..SYST:
	STA	CTRACK	;SAVE ACTUAL TRACK NUMBER
		

;GET ACTUAL SECTOR TO READ/WRITE

PYSEC:
	MOV	A,M	;GET LENGTH BYTE
	MOV	B,A
	CPI	3	;SEE IF 1024 BYTE SECTOR
	JRNZ	..LRG	;IF NOT TEST NEXT
	MVI	H,7	;ELSE GET MASK FOR THIS SIZE
	JMPR	..GSEC	;AND BRANCH AHEAD
..LRG:	CPI	2	;512 BYTE SECTOR(y/n)
	JRNZ	..NO	;NOPE, ACC HAS RECORD MASK
	INR	A	;MAKE MASK FOR 512 BYTE SECTOR
..NO:	MOV	H,A	;SAVE RECORD MASK

..GSEC:	LDA	SEKSEC	;GET MP/M SECTOR NUMBER
	DCR	A	;ADJUST DOWN TO START AT ZERO
	MOV	L,A	;SAVE FOR LATER
	INR	B	;ADJUST FOR EASY LOOP
	JMPR	..JOIN
..LOOP:	SRLR	A	;PLACE SECTOR NUMBER IN LSB'S
..JOIN:	DJNZ	..LOOP	;REPEAT UNTIL ALIGNED IN LSB'S
	INR	A	;ADJUST TO MAKE PHYSICAL SECTOR
	ORA	C	;GET SIDE BIT	
	STA	SEKHST	;HOST SECTOR
	STA	CSECT	;SAVE COMBINED SECTOR
	MOV	A,L	;GET MP/M SECTOR NUMBER
	ANA	H	;MASK ALL BUT RECORD NUMBER
	STA	CREC	;SAVE RECORD NUMBER
	RET


;******************************************************	
; STANDARD APBS, DPBS AND TRANSLATE TABLES. THESE
; TABLES ARE USED BY SELDSK WHEN IT CANNOT FIND A VALID
; DDB ON THE DISK. THE TABLES ARE FOR STANDARD 8" OR 5"
; SINGLE DENSITY FLOPPY DISKS. THIS ALLOWS PROGRAM
; INTERCHANGE WITH OTHER CP/M BASED SYSTEMS WITHOUT
; REQUIRING A DDB TO BE WRITTEN ON EACH DISK.
;******************************************************



;****************************************************
;             8" FLOPPY DISK TABLES.
;****************************************************

STDDDB:	.BYTE	00000001B ;FLAG
	.WORD	2	;OFF
	.BYTE	0	;SSLEN
	.BYTE	26	;SLRPS
	.BYTE	0	;USLEN
	.BYTE	26	;ULRPS

	.WORD	26	;STANDARD DPB
	.BYTE	3,7,0
	.WORD	242
	.WORD	63
	.BYTE	192,0
	.WORD	16
	.WORD	2

	.BYTE	1,7,13,19,25,5,11,17,23 ;STANDARD
	.BYTE	3,9,15,21,2,8,14,20,26  ;TRANSLATE
	.BYTE	6,12,18,24,4,10,16,22   ;TABLE


;*******************************************************
; SET Z3S CONTROL BYTE. GET 2 Z3S CONTROL BYTES, ONE
; WITH THE HARDWARE WAIT BIT ACTIVE AND ONE WITHOUT,
; FROM THE 8 POSSIBLE CONTROL BYTES. OUTPUT THE NO WAIT
; BYTE. SAVE BOTH FOR LATER USE.
;*******************************************************

SETD3S:	LDA	PTRACK	;GET DESIRED TRACK
	LXI	H,OFF
	CMP	M	;USER TRACK(y/n)
	LXI	H,US0N	;POINT TO USER TRACK BYTES
	JRNC	..USER
	LXI	H,SS0N	;POINT TO SYSTEM TRACK BYTES

..USER:	LDA	PSECT	;TEST IF ON SIDE 1
	BIT	7,A
	JRZ	..SID0	;ON SIDE 0
	INX	H	;POINT TO SIDE 1 BYTES
	INX	H

..SID0:	MOV	E,M	;GET THE NO WAIT BYTE
	INX	H
	MOV	D,M	;GET THE WAIT BYTE
	SDED	D3SNO	;SAVE BOTH
	MOV	A,E
	OUT     DCMD	;OUTPUT THE NO WAIT BYTE
	STA	OD3S
	RET


;*****************************************************
; GET Z3S CONTROL BYTES. CREATE THE EIGHT Z3S CONTROL
; BYTES IN ATABLE. THESE BYTES SET THE DENSITY BIT FOR
; SYSTEM TRACKS AND USER TRACKS, SELECT SIDE 0 OR SIDE
; 1, AND ENABLE OR DISABLE THE HARDWARE DATA WAIT.
; CREATE THE BYTES BY MERGING THE APPROPRIATE HARDWARE
; CONTROL BITS IN OPRTAB WITH THE CORRECT ADDRESS
; CONTROL BITS IN ADRTAB.
;*****************************************************

GETD3S:	LDA	ADISK	;GET CURRENT DISK NUMBER
	LXI	H,ADRTAB;POINT TO ADDRESS
	MOV	E,A	;   CONTROL BITS TABLE
	MVI	D,0
	DAD	D
	MOV	C,M	;SAVE ADDR BITS FOR Z3S BYTES

	LDA	FLAG	;GET THE FLAG
	ANI	00010100B ;ISOLATE SYSTEM DENSITY, SIZE
	MOV	B,A
	RRC		;ALIGN THE DENSITY BIT
	ORA	B	;COMBINE SIZE AND DENSITY
	ANI	00001100B ;DROP UNALIGNED BITS
	LXI	D,SS0N	;POINT TO BEGINNING OF DEST
	CALL	..GET	;GET SYSTEM TRACK Z3S BYTES

	LDA	FLAG	;GET THE FLAG
	ANI	00001100B ;ISOLATE USER DENSITY, SIZE
			;AND GET USER TRACK Z3S BYTES

..GET:	LXI	H,OPRTAB ;POINT TO CONTROL BITS TABLE
	PUSH	D
	MOV	E,A	;GET CONTROL BITS START ADDRESS
	MVI	D,0
	DAD	D	;START ADDRESS NOW IN HL
	POP	D	;DESTINATION RESTORED TO DE
	MVI	B,4
..LOOP:	MOV	A,M	;GET A BYTE OF CONTROL BITS
	INX	H
	ORA	C	;COMBINE WITH ADDRESS BITS
	STAX	D	;STORE COMBINED BYTE
	INX	D
	DJNZ	..LOOP	;DO ALL BYTES
	RET



;****************************************************
;          WAIT FOR TRIM ERASE TO END
;****************************************************

TRIMWT:	LDA	ORWCMD	;GET LAST READ OR WRITE COMMAND
	BIT	WBWRIT,A ;TEST WRITE BIT
	RZ		;IT WAS A READ, DON'T WAIT
	MVI	B,150	;WAIT
	DJNZ	. 
	RET


;*****************************************************
; MULTI-PURPOSE 179X SEEK SUBROUTINE. THE ENTRY
; POINTS ARE:

;	FHOME - RESTORE HEAD TO TRACK 0 POSITION
;	FSEEK - SEEK WITH HEAD LOAD TO DEST. IN ACC

;	FUNLD - SEEK SAME TRACK TO UNLOAD HEAD
;	FLOAD - SEEK SAME TRACK TO LOAD HEAD

; FOR THESE LAST TWO FUNCTIONS THE COMMAND IS STILL IN
; PROGRESS WHEN RETURN IS MADE. THE CALLING PROGRAM
; MUST WAIT FOR THE COMMAND TO COMPLETE.
;*****************************************************

FHOME:	MVI	B,WHOME ;SET UP HOME COMMAND
	JMPR	FH..

FSEEK:	OUT	WDATA	;OUTPUT SEEK DESTINATION
	MVI	B,WSEEK	;SET UP SEEK, DIFFERENT TRACK

FH..:	LDA	SPEED	;GET SEEK SPEED
	ORA	B	;MERGE WITH SEEK COMMAND
	OUT	WCMD	;OUTPUT TO 179X
	STA	OCMD
	CALL	FDONE
	ANI	WSSEEK	;ELIMINATE UNWANTED STATUS BITS
	RZ		;RETURN - SUCCESSFUL 
	MVI	A,1
	STC
	RET		;RETURN WITH CARRY SET - ERROR



FUNLD:	MVI	B,WUNLD	;SET UP UNLOAD COMMAND
	JMPR	FU..

FLOAD:	MVI	B,WLOAD	;SET UP LOAD COMMAND

FU..:	IN	WTRACK	;GET CURRENT TRACK
	OUT	WDATA	;OUTPUT SEEK DESTINATION

	MOV	A,B	;OUTPUT SEEK COMMAND
	OUT	WCMD
	RET


;****************************************************
;   FLOPPY DISK PHYSICAL READ AND WRITE ROUTINE
;****************************************************

PWRITE:	MVI	A,WWRITE ;SET WRITE COMMAND
	JMPR	PCOM..	;JOIN COMMON CODE

PREAD:	MVI	A,WREAD		;SET READ COMMAND

PCOM..:	STA	PCMD		;REMEMBER WHETHER READ OR WRITE
	CALL	GETAPB		;MAKE SURE ATABLE IS RIGHT ONE


;********************************************************	
;	IF LAST I/O WAS ON DIFFERENT DISK, TELL THE
;	179X TO UNLOAD ITS HEAD. THE HEAD LOAD ONE-SHOT
;	WILL THEN BE RETRIGERED ON THE NEXT COMMAND.
;********************************************************

	LXI	H,OLDFLO 	;POINT TO OLD FLOPPY NUMBER
	LDA	PDISK		;GET NEW NUMBER
	CMP	M		;SAME DISK(y/n)
	JRZ	..SADS		;YES

	MOV	M,A		;NO, UPDATE OLD NUMBER TO NEW
	CALL	TRIMWT		;WAIT FOR TRIM ERASE TO END
	CALL	SETD3S		;SET Z3S CONTROL BYTE

;	LDA	HLOPT		;SEE IF DUAL HEAD LOAD
;	ORA	A
;	JRNZ	SADS		;DON'T UNLOAD HEAD
;	CALL	FUNLD		;UNLOAD HEAD
;	CALL	FDONE		;INSURE FDC IS DONE


;********************************************************
;	INITIALIZE RETRY LIMITS. INSURE Z3S BYTE IS
;	SET. SEEK TO CORRECT TRACK.
;********************************************************

..SADS:
	LDA	FMACRO		;NUMBER OF HOME OPERATIONS
	STA	RMACRO
	MVI	A,3
	STA	MRML
..MAC:
	LDA	FMICRO		;RETRIES BETWEEN HOME OPERATIONS
	STA	RMICRO

	CALL	SETD3S		;SET Z3S CONTROL BYTE
	LXI	H,TRACK 	;GET OLD TRACK NUMBER
	MOV	A,M
	OUT	WTRACK		;UPDATE 179X TRACK REG
	LDA	PTRACK		;GET DESIRED TRACK NUMBER
	CMP	M		;SAME AS BEFORE(y/n)
	JRZ	..SATR		;YES

	MOV	M,A		;UPDATE TRACK NUMBER
	CALL	TRIMWT		;WAIT FOR TRIM ERASE TO END
	LDA	PTRACK		;GET DESIRED TRACK
	ORA	A		;TRACK 0 DESIRED(y/n)
	JRNZ	..NOZE		;NOPE

	CALL	FHOME		;SEEK TO TRACK 0 BY HOME CMD
	RC
	JMPR	..ENDS		;DONE SEEKING

..NOZE:	CALL	FSEEK		;NORMAL SEEK TO DESIRED TRACK
	RC

..ENDS:	CALL	PUTAPB		;UPDATE APB FROM ATABLE
	LDA	PCMD		;GET READ/WRITE COMMAND
	SET	WBDEL,A		;INSURE HEAD IS SETTLED
;NOMIL:
	STA	PCMD		;BY SETTING DELAY BIT IN CMD


;********************************************************
;	SET UP DMA ADDRESS, SECTOR REGISTER. ISSUE
;	THE READ OR WRITE COMMAND. SET HARDWARE WAIT.
;********************************************************

..SATR:
..MIC:
	.IFE	PIO,[
	DI
		]

	LDA	PSECT		;GET DESIRED SECTOR NUMBER
	MOV	B,A		;SAVE SIDE BIT
	ANI	7FH		;TEST SIDE BIT
	OUT	WSECT
	LDA	PCMD
	BIT	7,B
	JRZ	..SID0
	SET	WBSID1,A
..SID0:

	.IFE	PIO,[
	OUT	WCMD
			]

	STA	OCMD
	STA	ORWCMD
	MOV	D,A		;SAVE COMMAND
	LDA	D3SWT		;GET ACTIVE WAIT BYTE
	OUT	DCMD		;SET IT
	STA	OD3S		;SAVE IT


	LXI	B,128 < 8+WDATA ;SET PORT AND LENGTH
	LDA	PTRACK		;GET CURRENT TRACK
	LXI	H,OFF
	CMP	M		;IS IT A USER TRACK(y/n)
	LDA	USLEN		;GET USER SECTOR LENGTH
	JRNC	..ULEN
	LDA	SSLEN		;GET SYSTEM SECTOR LENGTH

..ULEN:	LHLD	PDMA		;GET DMA ADDRESS

	SHLD	DADLO		;Z80-DMA READ ADDRESS
	SHLD	DWLOW		;Z80-DMA WRITE ADDRESS
	BIT	WBWRIT,D 	;ARE WE WRITING(y/n)
	JRNZ	..WRIT		;YES, GO WRITE


;********************************************************
;	              READ THE SECTOR.
;********************************************************


	.IFN	PIO,[

;	DO Z80 DMA FDC OPERATION
..PIRD:
	LXI	H,127
	ORA	A
	JRZ	..PR12
	MVI	B,0H
	DCR	A
	JRZ	..PR25
	DCR	A
	JRZ	..PR51

;1024 BYTE READ

	LXI	H,1023
	JMP	..PR12

;512 BYTE READ

..PR51:
	LXI	H,511
	JMP	..PR12

;256 BYTE READ

..PR25:
	LXI	H,255

;128 BYTE READ FROM PIRD

..PR12:

	MOV	A,L
	STA	BLENLO
	MOV	A,H
	STA	BLENHI


	LXI	H,DMARED	;SEND COMMAND BLOCK TO DMA
	MVI	C,Z80DMA
	MVI	B,DMALEN
	OUTIR

	LDA	OCMD
	OUT	WCMD	;START FDC OPERATION


..RDFN:

	MVI	C,WSREAD 	;STATUS BITS TO TEST
	JMPR	..CHEX
		][

;	DO PIO OPERATION


..PIRD:
	ORA	A
	JRZ	..PR12
	MVI	B,0H
	DCR	A
	JRZ	..PR25
	DCR	A
	JRZ	..PR51
	INIR
	INIR
..PR51:	INIR
..PR25:
..PR12:	INIR
	
..RDFN:

	MVI	C,WSREAD ;STATUS BITS TO TEST
	JMPR	..CHEX
	]




;********************************************************
;	            WRITE THE SECTOR.
;********************************************************

	.IFN	PIO,[

..WRIT:

	LXI	H,127
	ORA	A
	JRZ	..PW12
	MVI	B,0H
	DCR	A
	JRZ	..PW25
	DCR	A
	JRZ	..PW51

	LXI	H,1023
	JMP	..SWRL
..PW51:
	LXI	H,511
	JMP	..SWRL

..PW25:
	LXI	H,255
..PW12:
..SWRL:
	SHLD	BWNLO
	LXI	H,DMAWRT
	MVI	C,Z80DMA
	MVI	B,DMWLEN
	OUTIR
	LDA	OCMD
	OUT	WCMD
			
;WRFN:
			
..WRFN:
	MVI	C,WSWRIT ;STATUS BITS TO TEST

		][

..WRIT:
..PIWR:
	ORA	A
	JRZ	..PW12
	MVI	B,0H
	DCR	A
	JRZ	..PW25
	DCR	A
	JRZ	..PW51
	OUTIR
	OUTIR

..PW51:	OUTIR
..PW25:
..PW12:	OUTIR

			
..WRFN:
	MVI	C,WSWRIT ;STATUS BITS TO TEST
		]

;****************************************************
;	WAIT FOR COMPLETION OF DISK OPERATION.
;	TEST FOR ERRORS.
;****************************************************

..CHEX:	
	CALL	EXIREG
	LDA	D3SNO		;GET NO WAIT Z3S BYTE
	OUT     DCMD
	STA	OD3S
	CALL	FQDONE		;WAIT FOR 179X DONE
	ANA	C		;ANY ERROR BITS(y/n)
	RZ			;NO, RETURN - SUCCESSFUL


;********************************************************
;	    RETRY THE I/O IF AN ERROR OCCURED.
;********************************************************

	LXI	H,RMACRO 	;POINT TO MACRO RETRY COUNT
	DCR	M		;DECREMENT IT
	JNZ	..MIC		;RE-DO READ/WRITE

;	IF WE CAME HERE IT IS TIME TO RE-CALIBRATE THE DRIVE

	LDA	ISTAT		;GET BACK LAST STATUS
	ANA	C
	CALL	EPRINT

..NORE:

;********************************************************
;THE FOLLOWING ROUTINE RINGS BELL AND WAITS FOR USER
;TO RETRY OPERATION ON DRIVE WITH ERROR
;********************************************************

	CALL	FHOME
	RC	
	XRA	A
	STA	TRACK

	LXI	H,MRML		;UPDATE HOME COUNT
	DCR	M
	STC			;PREPARE FOR WORST
	RZ			;IF SO SHOW TOTAL FAILURE

	CALL	RING
..CRIN:
	MVI	D,0
	CALL	CONST		;SEE IF KEY PRESSED
	JRZ	..CRIN		;IF NOT KEEP RINGING
	MVI	D,0
	CALL	CONIN		;GET CHAR
	CPI	4		;A ^D (y/n)
	JRZ	FXER		;IGNORE ERROR
	CPI	0DH		;SEE IF 'CR'
	JRNZ	..CRIN		;IF NOT TRY AGAIN
	CALL	BS		;BACK UP CURSOR
	CALL	PSP		;NOW 'ERASE' PRINTED ERROR MESSAGE
	CALL	BS		;AND BACK UP CURSOR AGAIN
	JMP	..MAC		;DO ANOTHER RE-TRY
	

;IGNORE DISK I/O ERROR AND CONTINUE WITH STATUS SET O.K.

FXER:
	STC			;FIX UP CARRY
	CMC
	XRA	A		;CLEAR ERROR FLAG
	RET


RING:
	CALL	MSG		;RING THE BELL AND DELAY 1 SECOND	
	.BYTE	87H
	RET


;BACK UP CURSOR 17 PLACES TO GET TO START OF ERROR MESSAGE

BS:
	
	MVI	C,8		;BACKSPACE CHARACTER IN C
BS0:	MVI	B,17
BS1:
	PUSH	B
	CALL	CHROUT
	POP	B
	DCR	B
	JRNZ	BS1
	RET

;PRINT 17 SPACES ON CONSOLE TO 'ERASE' LAST ERROR MESSAGE
;ENTER BACK SPACE ROUTINE AT BS0: TO EXECUTE 8 SPACES

PSP:
	MVI	C,20H		;SPACE CHARACTER IN C
	JMPR	BS0


;****************************************************
; MOVE ATABLE INTO THE CORRECT APB. MOVE THE CORRECT
; APB INTO ATABLE.
;****************************************************

PUTAPB:	LDA	ADISK	;GET CURRENT ATABLE NUMBER
	CALL	ASET..	;SET UP FOR MOVE
	LDIR		;COPY ATABLE INTO APB
	RET


GETAPB:	LXI	H,ADISK	;POINT TO ATABLE DRIVE NUMBER
	LDA	PDISK	;GET NEW NUMBER
	CMP	M	;THE SAME(y/n)
	RZ		;YES, ATABLE ALREADY VALID
	MOV	M,A	;UPDATE ATABLE NUMBER
	CALL	ASET..	;SET UP FOR MOVE
	XCHG		;APB ADDRESS NOW SOURCE
	LDIR		;COPY APB INTO ATABLE


;NOW GET ALLOCATION SIZE FOR SELECTED DISK

	LDA	PDISK	;GET DISK #
	MOV	E,A	;MAKE INDEX
	MVI	D,0
	LXI	H,ALOCSZ;POINT TO SAVED BSH TABLE
	DAD	D
	MOV	A,M	;GET BSH VALUE
	LXI	H,ALOREC;POINT TO RECORDS/ALLOCATION SIZE
	SUI	3	;SET FOR INDEX
	MOV	E,A	;MAKE INDEX
	DAD	D
	MOV	A,M	;GET RECORDS/ALLOCATION
	STA	ALOCA	;SAVE # FOR SELECTED DRIVE
	RET


;TABLE FOR # OF RECORDS FOR ALLOCATION SIZES FROM 1K TO 16K

ALOREC:
	.BYTE	8,16,32,64,128


ASET..:	MOV	L,A	;GET DISK NUMBER INTO L
	CALL	GETDPH
	LXI	H,ATABLE
	LXI	B,ALEN
	RET


;****************************************************
; GET DPH ADDRESS AND APB ADDRESS. RETURN THE DPH
; ADDRESS IN HL, THE CORRESPONDING APB ADDRESS IN DE.
; DISK NUMBER MUST BE IN L AT CALL.
;****************************************************

GETDPH:	MVI	H,0
	DAD	H	;GET NUMBER * 2
	MOV	E,L
	MOV	D,H
	DAD	H
	DAD	H
	DAD	H	;GET NUMBER * 16
	DAD	D	;GET NUMBER * 18
	LXI	D,APBBEG
	DAD	D	;NOW WE HAVE ADDR OF APB ADDR
	MOV	E,M	;GET APB ADDRESS INTO DE
	INX	H
	MOV	D,M
	INX	H	;HL NOW HAS DPH ADDRESS
	RET

;******************************************************
;*  PRINT THE DISK I/O ERROR ON A SCREEN
;******************************************************

EPRINT:
	PUSH	PSW		;SAVE ERROR BITS
	IN	WTRACK		;GET BAD TRACK
	STA	ITRACK
	IN	WSECT		;GET BAD SECTOR
	STA	ISECT	

EMSROT:
	CALL	MSG
	.ASCII	'Err'
	.BYTE	' '+80H
	LDA	SEKDSK
	ADI	'A'
	MOV	C,A
	CALL	CHROUT
	CALL	MSG
	.BYTE	':',' '+80H

	POP	PSW

	CALL	LBYTE

	MVI	C,' '
	CALL	CHROUT
	LDA	ITRACK
	CALL	LBYTE
	MVI	C,' '
	CALL	CHROUT
	LDA	ISECT
	CALL	LBYTE
	MVI	C,' '
	CALL	CHROUT
	MVI	C,' '
	JMP	CHROUT

;********************************************************
;            PRINT HEX BYTE ON CONSOLE.
;********************************************************

LBYTE:	PUSH	PSW
	RRC
	RRC
	RRC
	RRC
	CALL	P2
	POP	PSW
P2:	ANI	0FH
	ADI	90H
	DAA
	ACI	40H
	DAA
	MOV	C,A
	JMP	CHROUT


;********************************************************
; MESSAGE OUTPUT SUBROUTINE. THERE ARE TWO ENTRY
; POINTS. FOR MSG A MESSAGE FOLLOWS INLINE AFTER THE
; CALL. FOR MSGHL THE MESSAGE ADDRESS IS IN HL. FOR
; BOTH ENTRY POINTS THE MESSAGE IS PRINTED OUT UP TO
; AND INCLUDING A CHARACTER WITH ITS HI ORDER BIT SET.
;********************************************************

MSG:	XTHL			;GET MESSAGE ADDRESS
	CALL	MSGHL		;PRINT THE MESSAGE
	XTHL			;RESTORE NEW RETURN ADDRESS
	RET

MSGHL:
	MOV	A,M
	ANI	7FH
	MOV	C,A		;GET NEXT CHAR OF MESSAGE
	PUSH	H
	CALL	CHROUT		;OUTPUT THE CHAR
	POP	H
	MOV	A,M
	INX	H
	ORA	A		;TEST FOR HI BIT SET
	JP	MSGHL		;NOT SET, KEEP GOING
	RET

CHROUT:
	MVI	D,0
	JMP	BIOOUT


;********************************************************
;*         DISK SIZE & STEP SPEED TABLE
;********************************************************

;	1000 0011
;	^      ^
;	:      :- THE 179X STEP SPEED BITS
;	:
;	:-------- 0=8 INCH DISK AT THIS ADDRESS,
;		  1=5 INCH DISK AT THIS ADDRESS.

SPDTAB: .BYTE   STEPS0   ;DRIVE A
        .BYTE   STEPS1   ;DRIVE B
	.BYTE	STEPS2	;DRIVE C
	.BYTE	STEPS3	;DRIVE D

;*******************************************************
;* FMICRO & FMACRO SET TO GIVE 3 'MANUAL' TRIES
;*        AT CORRECTING PROBLEM ON DISK
;*******************************************************

FRETRY:
FMICRO:	.BYTE	4	;FLOPPY MICRO RETRY LIMIT
FMACRO:	.BYTE	5	;FLOPPY MACRO RETRY LIMIT


;********************************************************
;* Z3S OPERATING CONTROL TABLE. THIS TABLE CONTAINS
;* THOSE BITS IN THE Z3S CONTROL BYTE WHICH SELECT THE
;* OPERATING MODE. THESE BITS ARE COMBINED WITH ADDRESS
;* CONTROL BITS TO FORM A COMPLETE Z3S CONTROL BYTE. THE
;* BITS ARE DEFINED AS FOLLOWS:
;********************************************************
; VF-II VERSION OF TABLE
;
;	1111 0000
;	^^^^ ^
;	:::: +- THESE BITS IN ADDRESS CONTROL TABLE
;	::::
;	:::+--- 0=SIDE 1, 1=SIDE 0
;       ::+---- 1=8 INCH DISK, 0=5 INCH DISK
;	:+----- 1=SINGLE DENSITY (FM), 0=DOUBLE (MFM)
;	+------ 0=ENABLE HARDWARE WAIT, 1=DISABLE
;
; FOR VERSAFLOPPY II
; SIZE &	 
; DENSITY	 


OPRTAB:

		.IFN	PIO,[

; MODIFIED FOR DMA USE. THE WAIT BIT IS NEVER SET

C8S:	.BYTE	11110000B	;SIDE 0, NO WAIT
	.BYTE	11110000B	;SIDE 0, WAIT
	.BYTE	11100000B	;SIDE 1, NO WAIT
	.BYTE	11100000B	;SIDE 1, WAIT

C5S:	.BYTE	11010000B
	.BYTE	11010000B
	.BYTE	11000000B
	.BYTE	11000000B

C8D:	.BYTE	10110000B	;SIDE 0, NO WAIT
	.BYTE	10110000B	;SIDE 0, WAIT
	.BYTE	10100000B	;SIDE 1, NO WAIT
	.BYTE	10100000B	;SIDE 1, WAIT

C5D:	.BYTE	10010000B
	.BYTE	10010000B
	.BYTE	10000000B
	.BYTE	10000000B

				][

C8S:	.BYTE	11110000B	;SIDE 0, NO WAIT
	.BYTE	01110000B	;SIDE 0, WAIT
	.BYTE	11100000B	;SIDE 1, NO WAIT
	.BYTE	01100000B	;SIDE 1, WAIT

C5S:	.BYTE	11010000B
	.BYTE	01010000B
	.BYTE	11000000B
	.BYTE	01000000B

C8D:	.BYTE	10110000B	;SIDE 0, NO WAIT
	.BYTE	00110000B	;SIDE 0, WAIT
	.BYTE	10100000B	;SIDE 1, NO WAIT
	.BYTE	00100000B	;SIDE 1, WAIT

C5D:	.BYTE	10010000B
	.BYTE	00010000B
	.BYTE	10000000B
	.BYTE	00000000B


				]

;******************************************************
;*           Z3S ADDRESS CONTROL TABLE
;******************************************************

ADRTAB:	.BYTE	1110B	;DRIVE A
	.BYTE	1101B	;DRIVE B
	.BYTE	1011B	;DRIVE C
	.BYTE	0111B	;DRIVE D



;****************************************************
; MP/M CALL PARAMETER STORAGE. MP/M SETS THE LOGICAL
; PARAMETERS BY PRELIMINARY CALLS BEFORE CALLING THE
; READ OR WRITE ROUTINES. THE MP/M I/O ROUTINES SET
; AND USE THE REMAINING VARIABLES.
;****************************************************

SEKSEC:	.BLKW	1	;LOGICAL SECTOR TO R/W
DMAADD:	.BLKW	1	;LOGICAL & ACTUAL MP/M DMA ADDR
CREC:	.BLKB	1	;CURRENT RECORD WITHIN SECTOR


;******************************************************
; PHYSICAL DISK I/O PARAMETER STORAGE. THESE PARAMETERS
; MUST BE SET BEFORE CALLING THE FLOPPY DISK PHYSICAL
; READ OR WRITE ROUTINES.
;******************************************************

PDISK:	.BLKB	1	;PHYSICAL DISK FOR NEXT I/O
PTRACK:	.BLKW	1	;PHYSICAL TRACK FOR NEXT I/O
PSECT:	.BLKW	1	;PHYSICAL SECTOR FOR NEXT I/O
PDMA:	.BLKW	1	;PHYSICAL BUFFER ADDR, NEXT I/O

CTRACK:	.BLKW	1
CSECT:	.BLKW	1



;****************************************************
;    GENERAL PURPOSE VARIABLES ARE STORED HERE.
;****************************************************

RETRY:
RMICRO:	.BLKB	1	;MICRO FDC RETRY COUNT
RMACRO:	.BLKB	1	;MACRO FDC RETRY COUNT
ADISK:	.BLKB	1	;DISK NUMBER OF DISK AT ATABLE
OLDFLO:	.BLKB	1	;OLD FLOPPY DRIVE NUMBER
PCMD:	.BLKB	1	;ACTUAL FLOPPY READ/WRITE CMD
ORWCMD:	.BLKB	1	;LAST R/W OUTPUT TO CMD REG
DPHADR:	.BLKW	1	;DPH ADDRESS FOR CURRENT DISK
APBADR:	.BLKW	1	;APB ADDRESS FOR CURRENT DISK
WRTYPE:	.BLKB	1	;TYPE OF WRITE
D3SNO:	.BLKB	1	;CURRENT NO WAIT Z3S BYTE
D3SWT:	.BLKB	1	;CURRENT WAIT Z3S BYTE
SAVADR:	.BLKW	1	;STD OR ALT DDB ADDRESS
MRML:	.BLKB	1	;MACRO RETRY MAJOR LOOP


;*******************************************************
; ERROR INFORMATION STORAGE. VARIOUS ROUTINES USE THIS
; AREA TO STORE KEY VARIABLES RELATING TO THE Z3S
; CONTROLLER AND THE 179X CHIP. IF A PERMANENT DISK
; ERROR OCCURS, THE VARIABLES ARE PRINTED OUT AS AN AID
; IN ERROR DIAGNOSIS.
;*******************************************************

EINFO:
ITRACK:	.BLKB	1	;LAST INPUT FROM TRACK REG
ISECT:	.BLKB	1	;LAST INPUT FROM SECTOR REG
ISTAT:	.BLKB	1	;LAST INPUT FROM STATUS REG
ACTIVE:	.BLKB	1	;SHOWS WHICH ROUTINE HAD ERROR
OD3S:	.BLKB	1	;LAST OUTPUT TO Z3S CTRL BYTE
OCMD:	.BLKB	1	;LAST OUTPUT TO CMD REG
EILEN	==	.-EINFO



;*********************************************************
;*   ALLOCATION VALUES FOR SELECTED DISKS ARE NEXT
;*********************************************************

ALOCSZ:	.BLKB	4	;BSH VALUE FOR 4 DRIVES
ALOCA:	.BLKB	1	;RECORDS/BLOCK FOR SELECTED DRIVE

;UNALLOCATED PARAMETERS FOLLOW


UNACNT:	.BLKB	1	;UNALLOCATED RECORD COUNT

UNADSK:	.BLKB	1	;      "     DISK #	
UNATRK:	.BLKW	1	;      "     TRACK #
UNASEC:	.BLKW	1       ;      "     SECTOR #

NEWSEC:	.BLKW	1	;MP/M SET SECTOR

RSFLAG:	.BLKB	1	;READ SECTOR FLAG
READOP:	.BLKB	1	;READ = 0, WRITE = 1
HSTACT:	.BLKB	1	;0 = HOST NOT ACTIVE
HSTWRT:	.BLKB	1	;HOST WRITTEN FLAG


HSTDSK:	.BLKB	1
HSTTRK:	.BLKW	1
HSTSEC:	.BLKW	1

SEKDSK:	.BLKB	1
SEKTRK:	.BLKW	1
SEKHST:	.BLKW	1

	UNALEN	==	.-UNACNT


;*******************************************************
; APB COPY FOR CURRENT DISK. THE APB CONTAINS SEVERAL
; IMPORTANT BYTES NEEDED TO CONTROL THE ACTIVE DISK
; DRIVE. THE EXACT LENGTH AND ORDERING OF THESE ENTRIES
; IS CRITICAL, SO CHANGES MUST BE MADE WITH CARE. ONLY
; THE FLAG BYTE HAS ANY MEANING FOR A HARD DISK.
;*******************************************************

ATABLE:
SS0N:	.BLKB	1	;SYSTEM TRACK Z3S CONTROL BYTES
SS0W:	.BLKB	1
SS1N:	.BLKB	1
SS1W:	.BLKB	1
US0N:	.BLKB	1	;USER TRACK Z3S CONTROL BYTES
US0W:	.BLKB	1
US1N:	.BLKB	1
US1W:	.BLKB	1
TRACK:	.BLKB	1	;CURRENT TRACK
SPEED:	.BLKB	1	;DRIVE SEEK SPEED
FLAG:	.BLKB	1	;FLAG BYTE
OFF:	.BLKW	1	;NUMBER OF SYSTEM TRACKS
SSLEN:	.BLKB	1	;SECTOR LENGTH, SYSTEM
SLRPS:	.BLKB	1	;RECORDS PER SIDE, SYS TRACKS
USLEN:	.BLKB	1	;SECTOR LENGTH, USER TRACKS
ULRPS:	.BLKB	1	;RECORDS PER SIDE, USER TRACKS
ALEN	==	.-ATABLE ;ATABLE LENGTH


ALV0:	.BLKB	ALVLN
ALV1:	.BLKB	ALVLN
ALV2:	.BLKB	ALVLN
ALV3:	.BLKB	ALVLN

CSV0:	.BLKB	64
CSV1:	.BLKB	64
CSV2:	.BLKB	64
CSV3:	.BLKB	64


;**********************************************************
;**********************************************************
;*         MP/M II COMMONBASE PAGE BOUNDARY
;**********************************************************
;**********************************************************

CLDST:
	JMP	COLD

	.IFE	MPM1,[
	PDISP	==	(START-3)
	XDOS	==	(PDISP-3)
	][
	SWTUSR:	JMP	0	;SWITCH IN USER RAM
	SWTSYS:	JMP	0	;SWITCH IN SYSTEM RAM
	PDISP:	JMP	0	;GO DISPATCHER
	XDOS:	JMP	0	;GO XDOS
	]
	SYSDTA:	.BLKW	1	;SYSTEM DATA PAGE HERE


COLD:
WRMST:
	MVI	C,0		; FORCE TERMINATE PROCESS.
	JMP	XDOS

;*******************************************************
;*              179X NOT BUSY SUBROUTINE
;*******************************************************

FDONE:
	.IFN	PIO,[

	MVI	B,10	;DELAY
	DJNZ	.

FQDONE:

;PRE-CHECK BEFORE GOING ON POLL LIST

..DONE:
PIODON:
	CALL	WAITIO	;WAIT FOR DISC TO GET READY
..NWST:
	IN	WSTAT

	STA	ISTAT	;GET STATUS BACK

;
;	.IFN	MPM1,[
;
;	PUSH	PSW
;	PUSH	B
;	CALL	SWTSYS
;	POP	B
;	POP	PSW
;		]
;
	RET   


;************************************************************
;*        GO ON FLAG LIST FOR DRIVE READY.
;************************************************************

WAITIO:

	MVI	C,84H		;FLAG WAIT
	MVI	E,DSKFLG	;DISK FLAG
	CALL	XDOS
	RET

DSKINT:
	SHLD	HLSAV
	POP	H
	SHLD	RTSAV
	PUSH	PSW
	SSPD	SPSAV
	LXI	SP,INTSTK
	PUSH	D
	PUSH	B
	MVI	A,0FFH
	STA	PREEMP

	IN	WSTAT
	
	MVI	C,FLAGST
	MVI	E,DSKFLG
	CALL	XDOS

	XRA	A
	STA	PREEMP
	POP	B
	POP	D
	LSPD	SPSAV
	POP	PSW
	LHLD	RTSAV
	PUSH	H
	LHLD	HLSAV
	JMP	PDISP
		][


;************************************************************
;*        GO ON POLL LIST FOR DRIVE READY.
;************************************************************


;PRE-CHECK BEFORE GOING ON POLL LIST


FQDONE:
..DONE:
PIODON:
	IN	WSTAT
	RRC
	JRNC	..NWST	;IF DRIVE NOT BUSY	

	CALL	WAITIO	;WAIT FOR DISC TO GET READY
			;POLLS DISK READY AND READS STATUS
..NWST:
	IN	WSTAT
	STA	ISTAT	;GET STATUS BACK

;	.IFN	MPM1,[
;
;	PUSH	PSW
;	PUSH	B
;	CALL	SWTSYS
;	POP	B
;	POP	PSW
;		]

	RET   


;************************************************************
;*        GO ON POLL LIST FOR SELECTED DRIVE READY.
;************************************************************

WAITIO:

	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H

	MVI	C,POLL	; POLL REQUEST.
	MVI	E,PLDSK	; ROUTINE TO POLL.
	CALL	XDOS	; REQUEST PLACEMENT 
			; ON POLL LIST.
	POP	H
	POP	D
	POP	B
	POP	PSW

	RET

;IF A DISK FINISHED INTERRUPT GETS THROUGH, JUST STOP IT AND RETURN

DSKINT:
	PUSH	PSW
	IN	WSTAT
	POP	PSW
	RETI
			]

;*********************************************************
;*              POLL SELECTED DRIVE READY.
;*********************************************************

; THIS EXISTS IN FDC INTERRUPT-DONE XIOS, TO SATISFY POLL TABLE
; IT IS ONLY CALLED FOR PIO OPERATION
 
POLDSK:

	LDA	OD3S	; GET LAST CONTROL BYTE
	SET	6,A	; KILL WAIT
	OUT	DCMD	; IN CASE OF TROUBLE
	IN	WSTAT	; CONTROLLER STATUS.
	STA	ISTAT	; SAVE STATUS
	RRC		; BUSY (y/n)
	MVI	A,0	; NOT READY.
	RC
	CMA		; READY.
	RET


;**********************************************************
;*         ROUTINE TO TRANSFERE DATA
;*   TO/FROM USER BANK, TO/FROM HOST BUFFER FOR DISK I/O
;**********************************************************


RWMOV:

	.IFE	BNKIOS,[

	PUSH	H	;SAVE ORIGINAL SOURCE
	PUSH	D	;SAVE ORIGINAL DESTINATION
	PUSH	B	;SAVE BYTES TO MOVE

	CALL	SWTUSR

	POP	B
	POP	D
	POP	H

	LDIR		;MOVE DATA

	CALL	SWTSYS

	][

	LDIR		;MOVE DATA MP/M 1.1

	]



;NOW CHECK WRITE TYPE FOR DIRECTORY UPDATE

WRCHK:
	LDA	WRTYPE
	DCR	A	;TEST TYPE OF WRITE
	JRNZ	GOODOP
	LDA	HSTTRK	;GET TRACK FOR WRITE
	CPI	2
	MVI	A,0
	JRZ	WRITIT	;IF SO WRITE IT OUT

	JMPR	GOODOP	;IF NOT SHOW A SUCCESSFUL R/W OPERATION	


;CLEAR HOST BUFFER FOR DIRECTORY WRITE

WRITIT:

	STA	HSTWRT
	CALL	WRTHST
GOODOP:
	LDA	MRML
	ORA	A
	MVI	A,1
	RZ
	XRA	A
	RET		;SUCCESSFUL READ/WRITE


HOMER:	
	.BYTE	2
RETRYIT:
	.BYTE	3
KBIT:
	.BYTE	0
SIDEID:
	.BYTE	0



;*******************************************************
;              Z80 DMA READ COMMAND BLOCK


DMARED:

	.BYTE	83H	;DISABLE
	.BYTE	0C3H	;6 RESETS
	.BYTE	0C3H
	.BYTE	0C3H
	.BYTE	0C3H
	.BYTE	0C3H
	.BYTE	0C3H

;WR0

	.BYTE	01101101B ;A > B PORT ONLY	
	.BYTE	67H		;179X PORT

BLENLO:
	.BYTE	127
BLENHI:
	.BYTE	0

;WR1
	.BYTE	00111100B

;WR2
	.BYTE	00010000B	;B IS RAM, INC.

;WR4
	.BYTE	10001101B
DADLO:
	.WORD	HSTBUF

;WR5
	.BYTE	10000010B

;WR6
	.BYTE	0CFH
	.BYTE	87H

	DMALEN=.-DMARED


;*******************************************************
;              Z80 DMA WRITE COMMAND BLOCK


DMAWRT:

	.BYTE	83H	;DISABLE
	.BYTE	0C3H	;6 RESETS
	.BYTE	0C3H
	.BYTE	0C3H
	.BYTE	0C3H
	.BYTE	0C3H
	.BYTE	0C3H

;WR0

	.BYTE	01111001B	;B > A (TEMP) RAM	
DWLOW:
	.BYTE	0		;RAM ADD LOW
	.BYTE	80H		;RAM HI
BWNLO:
	.BYTE	127		;BLOCK LEN LO
BWNHI:
	.BYTE	0		;BLOCK LEN HI


;WR1
	.BYTE	14H		;PORT A = RAM, INCREMENTING

;WR2
	.BYTE	00111000B	;B IS I/O FIXED

;WR4
	.BYTE	10000101B	;BYTE MODE, PORT FOLLOWS
	.BYTE	67H		;179X PORT

;WR5
	.BYTE	10000010B
;WR6
	.BYTE	0CFH		;LOAD PORT B

;WR0
	.BYTE	00000101B	;A IS SOURCE
;WR6
	.BYTE	0CFH
	.BYTE	87H

	DMWLEN=.-DMAWRT



;****************************************************
; FLOPPY DISK DPH TABLE. FOR THE CONVENIENCE OF THE
;  XIOS THE APB ADDRESS FOR A DISK PRECEDES THE DPH
; FOR THE DISK.
;****************************************************

APBBEG:
	.WORD	APB0
	.WORD	TRANS0	;LOGICAL TO PHYSICAL XLATE TAB
	.WORD	0	;SCRATCH
	.WORD	0
	.WORD	0
	.WORD	DIRBUF	;DIRECTORY BUFFER
	.WORD	DPB0	;DISK PARAMETER BLOCK
	.WORD	CSV0	;CHECKSUM VECTOR
	.WORD	ALV0	;ALLOCATION VECTOR

	.WORD	APB1
	.WORD	TRANS1
	.WORD	0
	.WORD	0
	.WORD	0
	.WORD	DIRBUF
	.WORD	DPB1
	.WORD	CSV1
	.WORD	ALV1


	.WORD	APB2
	.WORD	TRANS2
	.WORD	0
	.WORD	0
	.WORD	0
	.WORD	DIRBUF
	.WORD	DPB2
	.WORD	CSV2
	.WORD	ALV2


	.WORD	APB3
	.WORD	TRANS3
	.WORD	0
	.WORD	0
	.WORD	0
	.WORD	DIRBUF
	.WORD	DPB3
	.WORD	CSV3
	.WORD	ALV3


;******************************************************
; FLOPPY DISK APBS, DPBS AND TRANSLATE TABLES. THE APB
; FOR EACH DRIVE IS HERE, FOLLOWED BY THE DPB, FOLLOWED
; BY THE TRANSLATE TABLE. EXTERNAL ROUTINES NEEDING TO
; ACCESS THE APB ASSUME THAT IT IMMEDIATELY PRECEDES
; THE DPB.
;******************************************************

APB0:	.BLKB	ALEN	;AUXILIARY PARAMETER BLOCK
DPB0:	.BLKB	15	;DISK PARAMETER BLOCK

DPBLEN	==	.-DPB0

TRNLN	==	88	;88 SECTORS MAX


TRANS0:	.BLKB	TRNLN	;TRANSLATE TABLE

TRALEN	==	.-TRANS0
APBDIS	==	.-APB0


APB1:	.BLKB	ALEN
DPB1:	.BLKB	15
TRANS1:	.BLKB	TRNLN


APB2:	.BLKB	ALEN
DPB2:	.BLKB	15
TRANS2:	.BLKB	TRNLN

APB3:	.BLKB	ALEN
DPB3:	.BLKB	15
TRANS3:	.BLKB	TRNLN



;HOST READ/WRITE BUFFER

HSTBUF:
RDBUFF:
WRBUFF:

SYSNIT:

;**************************************************
;*       STANDARD SYSTEM INITIALIZATION
;**************************************************


	DI		; JUST IN CASE

	SHLD	BIOSAD	; SAVE SYSTEM BIOS ADDR.
	XCHG
	SHLD	DEBUGA	; SAVE DDT/RDT RST ENTRY ADDR.
	MOV	A,C
	RAL
	RAL
	RAL
	MVI	H,0
	MOV	L,A
	SHLD	DEBUGR	; SAVE DDT/RDT RST LOC.


;     PLACE SYSTEM INFO INTO MEMORY BANKS

	LHLD	SYSDTA	; MP/M II GETS IT RIGTH AWAY
	LXI	D,15	; OFFSET TO MEMORY CONTROL SEGS.
	DAD	D	; HL => MAXIMUM SEG. COUNT.
	SHLD	SEGNBR	; SAVE FOR LATER ADJUSTMENT
	MOV	C,M	; TOTAL NUMBER OF CONTROL SEGS. IN TABLE.
	INX	H	; HL => FIRST CONTROL SEG.
	PUSH	H	; SAVE ADDRESS OF FIRST CONTROL SEG.

BINI:	PUSH	B	; SAVE COUNT OF BANKS TO INIT.
	MOV	B,H	; BC => SELECTED CONTROL SEG.
	MOV	C,L
	PUSH	H	; SAVE CURRENT TABLE POS.
	CALL	SELMEM	; SELECT BANK (CONTROL SEG. [BC]).
	CALL	SETUP	; INIT. SELECTED BANK.
	POP	H	; RECOVER TABLE POS.
	LXI	D,4	; OFFSET TO NEXT CONTROL SEG.
	DAD	D	; HL => NEXT CONTROL SEG.
	POP	B	; RECOVER REMAINING BANK COUNT.
	DCR	C
	JRNZ	BINI	; INIT ALL BANKS IN SEGMENT TABLE.
	POP	B	; BC => FIRST CONTROL SEG. (RESELECT).
	CALL	SELMEM	; REQUEST INITIAL BANK.
	LHLD	SEGNBR	; GET SYSTEM SEGMENT POINTER
	MOV	A,M	; GET MAX SEGMENTS
			; WHICH ARE <= CONFIG VALUE

;	SHOW ACCEPTED SEGMENTS

;	DCR	A	; EXCLUDE SYSTEM SEGMENT
;	DCR	A	; SET FOR SEGMENT # OFFSET
	ORI	030H	; MAKE IT ASCII
	STA	BNKNR	; PUT IN MESSAGE


;	CLEAR SCREENS AND TEST CONSOLES

CHIN0:
;	GET NUMBER OF CONSOLES

CSTEST:
	LHLD	SYSDTA	;GET SYSTEM DATA PAGE
	INX	H	;POINT TO GENSYSED CONSOLE #
	MOV	A,M	;GET THAT NUMBER
	STA	CONNRB
	ORI	030H	; MAKE ASCII
	STA	CMES	; PUT IN MESSAGE


;	GET NUMBER OF DRIVES

	LDA	ACTDSK
	ADI	'0'
	STA	MDMS


;	GET NUMBER OF SYSTEM PRINTERS

	LHLD	SYSDTA
	LXI	D,197
	DAD	D
	MOV	A,M		;GET # OF PRINTERS
	ORI	30H
LSTNBR:
	STA	MLST
	ANI	0FH
	STA	LSTNR


ISVFII:
	CALL	MSG
	.ASCIS	\VF-II \

CSIGON:
	CALL	MSG

	.ASCII	\ XIOS-60 \
	
	.IFE	PIO,[
	.ASCII	\PIO FDC \
		][
	.ASCII	\DMA FDC \
		]

	.IFE	FLPINT,[
	.ASCII	\w fdc int \
		]

	.IFN	VDBCON,[
	.ASCII	\USART \
		][
	.ASCII	\VDB8024 \
		]
	
	.ASCII	\mem segs =\

BNKNR:	.BLKB	1

	.ASCII	\  crt=\
CMES:	.BLKB	1

	.ASCII	\  sys ptr=\
MLST:	.BLKB	1

	.ASCII	\  dsk=\
MDMS:	.BYTE	0
	
	.ASCIS	\ \

; *** TURN ON VECTORED INTERRUPTS & REAL TIME CLOCK. ***

DOINT:
	MVI	A,0FFH
	OUT	2EH		;SET M.P.B. PORT 6 TO 19,200 BAUD

	IM0

	OUT	VIRTC		;TURN ON INTERRUPTS

	JMP	DSKRST


;********************************************************
;*  ROUTINE TO PLACE SYSTEM INFO IN CURRENT SELECTED BANK
;*  EACH BANK IS TESTED TO SEE IF IT CAN READ/WRITE O.K.
;********************************************************

SETUP:
	MVI	A,0C3H
	STA	0	; JMP INST AT WARMSTART.

	STA	8	; ORIGINAL ZEUS80 VECTOR
	STA	20H	; JMP INST AT RST#4.


	STA	30H	; JMP INST AT RST#6, FDISK INT

	LHLD	DEBUGR
	MOV	M,A	; JMP INST AT DEBUG RST.
	INX	H
	XCHG
	LHLD	DEBUGA
	XCHG
	MOV	M,E	; JMP ADDR AT DEBUG RST.
	INX	H
	MOV	M,D
	LHLD	BIOSAD
	SHLD	1	; JMP ADDR AT WARMSTART.
	LXI	H,INT1HD

	SHLD	21H	; JMP ADDR AT RST#4.
	SHLD	9	; ORIGINAL ZEUS80	
	LXI	H,DSKINT
	SHLD	31H	; JMP ADDR AT RST#6

	RET


	
SEGNBR:	.BLKB	1	;MAXIMUM SEGMENTS HERE	


	SYSLEN	==	(.-SYSNIT)


	.LOC	HSTBUF+1024


DIRBUF:	.BLKB	128


;********************************************************
;*                  UNITXIOS.ASM		        *
;*    MP/M VERSION 1.1 & II UNIT RECORD XIOS	        *	
;*        	    BRUCE JONES 		        *
;*                   11/02/83                           *
;********************************************************

;********************************************************
;*            SYSTEM SWITCHED HARDWARE
;********************************************************
   
; MEMORY BANK CONTROL.

MULTIB	== 	0FFH	; BASE ADDRESS PORT FOR START OF
			; MULITIPLE BANK MEMORY BOARDS.

; INTERRUPT CONTROL.

VIRTC	== 	0DH	; INTERRUPT START PORT.
INTC	== 	0CH	; INTERRUPT CLEAR & STOP PORT.


;********************************************************
;*       MP/M XDOS FUNCTION DEFINITIONS.
;********************************************************

POLL	== 	131	; XDOS POLL REQ FUNCTION.
FLAGST	== 	133	; XDOS FLAG SET FUNCTION.
DSPTCH	== 	142	; XDOS DISPATCH FUNCTION.
SYSDAT	== 	154	; XDOS SYS-ADDR FUNCTION.
GETCON	==	99H


;********************************************************
;*          MP/M ROUTINE DEVICE ASSIGNMENTS.
;********************************************************


APOL	==	0	;FIRST POLL DEVICE ASSIGNMENT

;	CONSOLE I/O PORTS ARE FIRST

PLCO0	== 	APOL +0		; POLL CONSOLE OUT #0.
PLCO1	== 	APOL +1		;        "         #1.
PLCO2	== 	APOL +2		;        "         #2.
PLCO3	==	APOL +3		;        "         #3.
PLCO4	==	APOL +4		;        "         #4.
PLCO5	==	APOL +5		;        "         #5.
PLCO6	==	APOL +6		;        "         #6
PLCO7	==	APOL +7		;        "         #7.


PLCI0	== 	APOL +8		; POLL CONSOLE IN  #0.
PLCI1	== 	APOL +9		;        "         #1.
PLCI2	== 	APOL +10	;        "         #2.
PLCI3	==	APOL +11	;        "         #3.
PLCI4	==	APOL +12	;        "         #4.
PLCI5	==	APOL +13	;        "         #5.
PLCI6	==	APOL +14	;        "         #6.
PLCI7	==	APOL +15	;        "         #7.


;	DISK DRIVE PORTS NEXT

PLDSK	== 	APOL+16		; POLL FLOPPY DISK.
PLDMA	==	APOL+17


;HARD DISK POLL VALUES FOR MP/M POLL DEVICE ROUTINE


PLBUS	==	APOL +18	;POLL FOR DISK BUSY
FINDSK	==	PLBUS		;LAST POLL VALUE FOR DISK

;	PRINTER POLL VALUES


PRN0	==	FINDSK+1	; POLL PRINTER	#0
PRN1	==	PRN0+1		; POLL PRINTER  #1
PRN2	==	PRN0+2		; POLL PRINTER  #2

;	PARALLEL TYPES

PRN3	==	PRN0+3  	; POLL PRINTER  #3
PRN4	==	PRN0+4  	; POLL PRINTER  #4


;********************************************************
;*               MP/M CONSOLE HANDLERS 
;********************************************************

;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;	            CONSOLE STATUS  
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CONST:
	CALL	INRNG		;SEE IF CONSOLE IN RANGE
CONST1:
	MVI	D,0		;CLEAR FOR INDEX
	ADD	A		;*2
	ADD	A		;*4
	MOV	E,A		;MAKE DE INDEX VALUE
	LXI	H,CITAB		;POINT HL TO CONSOLE INPUT TABLE
	DAD	D		;POINT TO CORRECT CONSOLE TABLE
	INX	H		;POINT TO STAT PORT VALUE
	MOV	C,M		;PUT PORT VALUE IN C
	INX	H		;POINT TO READY MASK
	INP	A		;GET DATA FROM PORT
	ANA	M		;TEST WITH READY MASK
	RZ			;RETURN HERE BUSY
	MVI	A,0FFH		;ELSE SET READY
	RET
 

;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;	            CONSOLE INPUT 
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CONIN:
	CALL	INRNG		;SEE IF DEVICE IN RANGE
	MVI	D,0		;SET UP ACTIVE OFFSET
	ADD	A		;*2 GET OFFSET FOR TABLE
	ADD	A		;*4
	MOV	E,A		;MAKE DE INDEX
	LXI	H,CITAB		;POINT HL TO INPUT TABLE
	DAD	D		;COMPUTE CORRECT TABLE
	MOV	E,M		;GET DEVICE # FOR POLL
	INX	H		;NOW POINT TO STATUS PORT
	INX	H		;POINT TO STATUS MASK
	INX	H		;POINT TO INPUT PORT
	MOV	C,M		;PUT PORT INTO C
	PUSH	B		;SAVE INPUT PORT IN C
	MVI	C,POLL		;SET UP XDOS POLL
	CALL	XDOS		;DO POLL
	POP	B		;RECOVER INPUT PORT VALUE
	INP	A		;FIRST GET CONSOLE BYTE
	ANI	7FH		;STRIP PARITY
	RET


;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;	           CONSOLE OUTPUT 
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::

CONOUT:
	CALL	INRNG		;SEE IF CONSOLE # O.K.
	CALL	ODEX		;CALL CONSOLE OUTPUT INDEX
	MOV	E,M		;SAVE DEVICE #
	MOV	B,C		;PUT OUTBYTE INTO B
	INX	H		;POINT TO STATUS PORT
	MOV	C,M		;PUT INTO C
	INX	H		;POINT TO STATUS MASK
	INP	A		;GET STATUS
	ANA	M		;TEST IF READY
	INX	H		;POINT TO OUTPUT PORT
	MOV	C,M		;PUT INTO C
	JRNZ	..RDY		;IF READY GO OUTPUT
	PUSH	B		;ELSE SAVE PORT & DATA
	MVI	C,POLL		;SET UP XDOS POLL
	CALL	XDOS		;DO POLL
	POP	B		;BACK FROM POLL
..RDY:
	MOV	A,B
	ANI	7FH
	OUTP	A		;XMIT BYTE
	RET			;DONE


;::::::::::::::::::::::::::::::::::::::::::::::::::::::::
;:         CONSOLE I/O TABLES START NEXT
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::

;	OUTPUT TABLE FIRST 

		.IFE	VDBCON,[

COTAB:

;TABLE VALUES 
	      ;DEV # / STAT PORT / MASK VALUE / OUT PORT 	


	.BYTE	0,0H,04H,01H
	.BYTE	1,7DH,01H,7CH

	.BYTE	2,02H,80H,03H		;IF CONSOLE #2 FOR THIS PORT

	.BYTE	3,12H,80H,13H
	.BYTE	4,14H,80H,15H
	.BYTE	5,16H,80H,17H
	.BYTE	6,1EH,80H,1FH
	.BYTE	7,10H,80H,11H


;	INPUT TABLE NEXT 

CITAB:

;TABLE VALUES
		;DEV #/ STAT PORT / MASK VALUE / IN PORT

	.BYTE	8,00H,02H,01H
	.BYTE	9,7DH,02H,7CH

	.BYTE	10,10H,01H,11H		;ELSE USE THIS PORT

	.BYTE	11,12H,01H,13H
	.BYTE	12,14H,01H,15H
	.BYTE	13,16H,01H,17H
	.BYTE	14,1EH,01H,1FH
	.BYTE	15,10H,01H,11H

			][
COTAB:

;TABLE VALUES 
	      ;DEV # / STAT PORT / MASK VALUE / OUT PORT 	


	.BYTE	0,7DH,01H,7CH

	.BYTE	1,00H,04H,01H		;IF CONSOLE #2 FOR THIS PORT

	.BYTE	2,12H,80H,13H
	.BYTE	3,14H,80H,15H
	.BYTE	4,16H,80H,17H
	.BYTE	5,1EH,80H,1FH
	.BYTE	6,10H,80H,11H
	.BYTE	7,254,254,254		;DUMMY CONSOLE

;	INPUT TABLE NEXT 

CITAB:

;TABLE VALUES
		;DEV #/ STAT PORT / MASK VALUE / IN PORT

	.BYTE	8,7DH,02H,7CH

	.BYTE	9,0H,02H,01H		;IF CONSOLE # 2 THIS PORT

	.BYTE	10,12H,01H,13H
	.BYTE	11,14H,01H,15H
	.BYTE	12,16H,01H,17H
	.BYTE	13,1EH,01H,1FH
	.BYTE	14,10H,01H,11H
	.BYTE	15,254,254,254		;DUMMY CONSOLE
			]

INRNG:
	MOV	A,D		;GET CONSOLE #
	CPI	CONNR		;SEE IF O.K.
	RC			;RETURN O.K.

TOOMNY:
	POP	PSW

RNTEM:
HDPOLL:
POLDMA:
	XRA	A
	RET


;********************************************************
;*              MP/M   PRINTER HANDLER 
;********************************************************

LIST:
;	MP/M II WILL CHECK FOR PRINTER PASSED IN REGISTER D


	PUSH	D		;SAVE LIST #
	PUSH	B		;SAVE LIST BYTE IN C REG.
	CALL	POLLPT		; BEFORE GOING ON POLL LIST,
	POP	B
	POP	D
	MOV	B,D		;SAVE LIST # IN B
	ORA	A		;  - SEE IF PORT OUTPUT READY,
	MOV	A,B		;PUT LIST # IN ACC.
	JRNZ	LISRDY		;  - TO REDUCE POLL OVERHEAD.

	MOV	E,A		; GET INTO REG. E
	MVI	D,0
	LXI	H,LSTAB1	; POINT TO LIST POLL-DEV # TABLE
	DAD	D		; GET CORRECT DEV # TO POLL
	MOV	E,M		; PUT IN E
	PUSH	D		; SAVE DEVICE # TO POLL
	PUSH	B		; SAVE CHARACTER & LIST #
	MVI	C,POLL
	CALL	XDOS		; POLL THE PRINTER
	POP	B
	POP	D
	

LISRDY: 	;FOR MP/M II WE SAVED PRINTER # IN B ON PRINTER PRE-POLL

	MOV	A,B		;GET LIST BACK IN CASE
	ADD	A		;*2
	ADD	A		;*4
	MOV	E,A		;SET INDEX
	MVI	D,0
	LXI	H,LSTOUT	;POINT OUTPUT ROUTINES
	DAD	D		;THE CORRECT ONE
	MOV	A,C		;THE CHARACTER TO PRINT
	PCHL			;GO PRINT IT

LSTOUT:

LOUT0:
	OUT	7
	RET
	NOP

LOUT1:
	OUT	6
	RET
	NOP


	.IFN	CONLST,[

LOUT2:
	OUT	3	;MP/M SERIAL PORT, IF CONSOLE #2 = LIST
	RET
	NOP

LOUT3:
	OUT	23H
	RET
	NOP
	][

LOUT2:
	OUT	23H
	RET
	NOP
	]

;TABLE CONTAINING LIST POLL NUMBER

LSTAB1:
	.BYTE	PRN0
	.BYTE	PRN1
	.BYTE	PRN2
	.BYTE	PRN3


;	GET READY STATUS OF SELECTED PRINTER 

POLLPT:
	MOV	B,D		;SAVE PRINTER # IN B
	MOV	A,D		;PUT PRINTER # INTO ACC.
	MVI	D,0		;PREPARE FOR INDEX
	ADD	A		;*2
	ADD	A		;*4
	ADD	A		;*8
	MOV	E,A		;MAKE INDEX VALUE IN DE
	LXI	H,LSTAB0	;POINT TO STATUS ROUTINES
	DAD	D		;MAKE ENTRY ADDRESS
	PCHL			;GET STATUS


;	ROUTINES USED TO TEST FOR PRINTER READY

LSTAB0:

LST0:
	IN	6
	CMA
	ANI	1
	JMPR	SETLST
	NOP

LST1:
	IN	6
	CMA
	ANI	80H
	JMPR	SETLST
	NOP

	.IFN	CONLST,[

LST2:
	IN	2
	NOP
	ANI	80H
	JMPR	SETLST
	NOP

;	M.P.B.	PORT #5

LST3:
	IN	22H
	NOP
	ANI	80H
	JMPR	SETLST
	NOP

	][

LST2:
	IN	22H
	NOP
	ANI	80H
	JMPR	SETLST
	NOP
	]

;		SHOW THE CORRECT STATUS RESULT

SETLST:
	RZ
	MVI	A,0FFH
	RET


;********************************************************
;*          MP/M DEVICE POLL HANDLER 
;********************************************************

POLDEV:			; REG C = DEVICE # TO BE POLLED.
			; RETURN FFH IF READY.
			;        00H IF NOT.

	MOV	A,C
	CPI	NMBDEV
	JRNC	RNTEM
DEVOK:
	CPI	16		;TEST IF NOT A CONSOLE
	JRNC	NOTCON		;GO HERE IF NOT A CONSOLE
	CPI	8		;SEE IF CONSOLE OUTPUT
	JRNC	OKIN		;IF NOT GO POLL INPUT RIGHT NOW
	MOV	E,A		;SAVE DEVICE # FOR LATER 
	CALL	ODEX		;GO INDEX ON OUTPUT TABLE
	INX	H		;POINT TO STATUS PORT
	MOV	C,M		;PUT IN C
	INX	H		;POINT TO XMIT READY MASK
	INP	A		;GET ACTUAL CONSOLE XMIT STATUS
	ANA	M		;TEST WITH READY
	RZ			;IF BUSY SHOW IT
	MVI	A,0FFH		;ELSE SHOW READY
	RET
	

;WE CALLED HERE TO COMMON CODE FOR CONSOLE OUTPUT

ODEX:
	LXI	H,COTAB		;POINT TO START OF CON. TABLE
	ADD	A		;*2 GET OFFSET
	ADD	A		;*4
	MVI	D,0
	MOV	E,A		;SET OFFSET IN E
	DAD	D		;COMPUTE CORRECT TABLE
	RET

;CONSOLE INPUT POLL FROM HERE

OKIN:
	SUI	8		;MAKE IT A REAL CONSOLE #
	JMP	CONST1		;GET CONSOLE INPUT STATUS


;********************************************************
;*      IF NOT A CONSOLE I/O COME HERE FOR POLL
;********************************************************

NOTCON:
	SUI	16		;ADJUST FOR FOLLOWING DEVICE TABLE
	LXI	H,DEVTBL	;POINT TO DEVICE TABLE
TBLJMP:				; COMPUTE AND JUMP TO HANDLER.
				; A = TABLE INDEX.
	ADD	A		; DOUBLE TABLE INDEX FOR ADDR OFFSET.
	MOV	E,A
	MVI	D,0
	DAD	D		; ADD TABLE INDEX * 2 TO TABLE BASE.
	MOV	E,M		; GET HANDLER ADDR.
	INX	H
	MOV	D,M
	XCHG
	PCHL			; JUMP TO COMPUTED CNS HANDLER.

DEVTBL:
 	.WORD	POLDSK		; POLL FLOPPY DISK READY
	.WORD	POLDMA		; POLL DMA DEVICE
	.WORD	HDPOLL		; POLL WINCHESTER BUSY 


LPNUM:
	.WORD	LST0
	.WORD	LST1


	.IFN	CONLST,[

	.WORD	LST2			; CONSOLE #2 AS PRINTER
	.WORD	LST3

		][
	.WORD	LST2
		]

DEVLEN	==	.-DEVTBL 	;GET LENGTH OF DEVICE TABLE


;NUMBER OF DEVICES HANDLED IN XIOS


NMBDEV	== 	(16+(DEVLEN/2))	



;********************************************************
;*             MP/M MEMORY HANDLER 
;********************************************************

; REG BC = ADDR OF MEM DESCRIPTOR.
; BC ->	BASE	1 BYTE.
; 	SIZE	1 BYTE.
; 	ATTRIB	1 BYTE.
; 	BANK	1 BYTE.

SELMEM:
	LXI	H,3		; TABLE SEGMENT => BANK.
	DAD	B		; POINT TO BANK BYTE
	MOV	A,M		; BANK NUMBER INTO B.
	OUT	MULTIB		; SWITCH BANK IN
	RET			; RETURN FROM BANK SELECT.

;********************************************************
;*          SYSTEM CLOCK ENABLE ROUTINE 
;********************************************************

; WILL CAUSE FLAG #1 TO BE SET AT EACH SYSTEM TIME UNIT TICK.

STRCLK:
	MVI	A,0FFH
	STA	TICKN
	RET


;********************************************************
;*        SYSTEM CLOCK DISABLE ROUTINE 
;********************************************************

; WILL STOP FLAG #1 SETTING AT SYSTEM TIME UNIT TICK.

STPCLK:
	XRA	A
	STA	TICKN
	RET


;*****************************************************
;*         SYSTEM REGIONAL EXIT ENABLE ROUTINE 
;*****************************************************

EXIREG:
	LDA	PREEMP		;EI IF NOT PRE-EMPTED
	ORA	A
	RNZ
	EI
	RET


;********************************************************
;*        IDENTIFY MAXIMUM CONSOLE ABILITY 
;********************************************************

MAXCON:
	LDA	CONNRB		;GET MAX NUMBER
	RET


;********************************************************
;*         MP/M INTERRUPT ONE HANDLER 
;********************************************************

INT1HD:
	DI			;HOLD OFF FOR SPIKES
	OUT	INTC		;RESET INT. FLOP
	OUT	VIRTC		;& RE-ENABLE IT 
	SHLD	HLSAV		;SAVE USER HL
	POP	H		;SAVE USER RETURN
	SHLD	RTSAV
	PUSH	PSW		;SAVE USER PSW
	SSPD	SPSAV		;SAVE USER SP

	LXI	SP,INTSTK	;MAKE LOCAL SP
	PUSH	D		;SAVE DE
	PUSH	B		;SAVE BC
	MVI	A,0FFH		;PREEMPT SET
	STA	PREEMP
	LDA	TICKN		;GET SYSTEM TICK
	ORA	A
	JRZ	NOTICK		;IF NOT TICK DON'T SET IT
	MVI	C,FLAGST
	MVI	E,1
	CALL	XDOS		;GO SET TICK FLAG

NOTICK:
	LXI	H,CNT60		;GET 1/60 SECOND
	DCR	M		;UP DATE IT	
	JRNZ	NOTSEC		;SEE IF TIMED OUT

	MVI	M,60		;IF YES- RESET

	MVI	C,FLAGST	;AND DO XDOS CALL
	MVI	E,2		;TO SET SECOND FLAG
	CALL	XDOS

NOTSEC:
	XRA	A		;CLEAR PSW
	STA	PREEMP		;CLEAR PREEMPT
	POP	B		;GET ALL REGS BACK
	POP	D		;	:
	LSPD	SPSAV		;	:
	POP	PSW		;	:
	LHLD	RTSAV		;	:
	PUSH	H		;	:
	LXI	H,PDISP		;FORCE DISPATCHER ADDRESS ONTO STACK
	PUSH	H		;
	LHLD	HLSAV		;

; FORCE ROUND ROBIN SCHEDULING NEXT BY GOING TO DISPATCHER

	RETI			;Z80 RETURN TO DIRPATCHER


;********************************************************
;*        MP/M IDLE PROCESS HANDLER ROUTINE
;********************************************************

IDLE:
	MVI	C,DSPTCH	; DISPATCH CALL
	JMP	XDOS


;********************************************************
;*      XIOS INFORMATION STORAGE AREA.
;********************************************************

CFGRAM:	.BYTE	BNKUNT		;MAXIMUM RAM SEGMENTS SUPPORTED
BIOSAD:	.WORD	0		;BIOS ADDRESS
DEBUGA:	.WORD	0		;
DEBUGR:	.WORD	0		;DE-BUG ADDRESS
CNT60:	.BYTE	60		;SYSTEM CLOCK LOCATION
HLSAV:	.WORD	0		;HL SAVE
SPSAV:	.WORD	0		;STACK SAVE
RTSAV:	.WORD	0		;RETURN ADDRESS SAVE
TICKN:	.BYTE	0		;SYSTEM TICK FLAG
PREEMP:	.BYTE	0		;PRE-EMPT FLAG
CONNRB:	.BYTE	CONNR		;MAX CONSOLES SUPPORTED
LSTNR:	.BYTE	0		;MAX PRINTERS SUPPORTED
LBANK:	.BYTE	0		;LAST BANK SELECTED

;DISKS & PRINTERS SUPPORTED NEXT

STKFIL:	.BLKB	32		;SYSTEM STACK AREA
INTSTK:				;START OF INTERRUPT STACK


ENDIOS:
	.BYTE	0


;XSIZEXSIZE                   SHOW SIZE OF XIOS HERE


.PRNTX	\         \


	.IF1,[


;SHOW TOTAL RAM USED


	.DEFINE	SIZMEM[XX]=[
	.PRNTX	/XIOS CONSUMES XX BYTES/]
	SIZMEM \.-(START)


;SHOW COMMON AREA USED

	.DEFINE	COMMEM[XX]=[
	.PRNTX	/COMMON AREA IS XX BYTES LONG/]
	COMMEM	\.-(CLDST)



;SHOW USER TPA

	.DEFINE	COMLOC[X]=[
	.PRNTX	/USER BANK SIZE IS  X  BYTES/]
	
	COMLOC	\(206-((.-CLDST)/256))*256



	.RADIX	16 

	.DEFINE	CMLOC[XX]=[
	.PRNTX	/COMMON BASE STARTS AT XX/]

	CMLOC	\((0CC00H)-(.-CLDST))


	.DEFINE	SWTPT[X]=[
	.PRNTX	/MEMORY HARDWARE COULD BE SWITCHED AT PAGE  X/]


	SWTPT	\(((0CC00H)-(.-CLDST))/100H)
	
	.IFE	LOC,[
	.PRNTX /BE SURE TO RENAME THIS HEX FILE FOR 0000H USE/
			][
	.PRNTX /USE PIP TO CONCATENATE THIS HEX FILE WITH 0000H HEX FILE/
			]
 


	]
	
	.END
	
