;********************************************************
;*                     V2SASG
;*             VF II STAND ALONE SYSGEN
;*                    12/15/03
;********************************************************

	.XLINK
	.Z80		;Z80 OPCODES USED
	.PHEX
	.PABS
	.LOC	100H

; THE FIRST TWO TRACKS OF ANY SYSTEM DISK MUST HAVE AT
; LEAST 9 SECTORS OF 512 BYTES EACH. THE INFORMATION
; ON THESE SECTORS MUST BE:

;   TRACK 0, SECTOR 1, BYTES 0 THRU 127 - LOADER
;   TRACK 0, SECTOR 1, BYTES 128 THRU 511 - CP/M
;   TRACK 0, SECTOR 2 THRU SECTOR 7 - CP/M
;   TRACK 0, SECTOR 8, BYTES 0 THRU 383 - CP/M
;   TRACK 0, SECTOR 8, BYTES 384 THRU 511 - DDB
;   TRACK 0, SECTOR 9, BYTES 0 THRU 511 - CP/M
;   TRACK 1, SECTOR 1 THRU SECTOR 9 - CP/M, FOLLOWED
;	BY THE CBIOS

BELL	==	7
CR	==	13
LF	==	10
CLEAR	==	26
PRINTS	==	9

BDOS	==	5


; FDC PORT ADDRESSES.

DCNTL	==	063H	;DMA DISC CONTROL PORT
WDC	==	064H	;WDC 179X BASE ADDRESS
WCMD	==	WDC+0	;COMMAND REGISTER
WSTAT	==	WDC+0	;STATUS REGISTER
WTRACK	==	WDC+1	;TRACK REGISTER
WSECT	==	WDC+2	;SECTOR REGISTER
WDATA	==	WDC+3	;DATA REGISTER

;    WD179X COMMANDS

WHOME	==	00001000B 	;HOME COMMAND
WREAD	==	10001000B 	;READ SECTOR COMMAND
WWRITE	==	10101000B 	;WRITE SECTOR COMMAND
WSEEK	==	00011000B 	;SEEK TO GIVEN TRACK COMMAND
WUNLD	==	00010000B 	;SEEK AND UNLOAD HEAD COMMAND
WLOAD	==	00011000B 	;SEEK AND LOAD HEAD COMMAND

;********************************************************
;             COMMON 179X CONTROLLER STATUS
;********************************************************

WBBUSY	==	0		;179X BUSY STATUS BIT
WBSID1	==	1		;SIDE SELECT FLAG COMMAND BIT
WBDEL	==	2		;HEAD SETTLE DELAY COMMAND BIT
WBWRIT	==	5		;READ/WRITE DISTINGUISHING BIT
WBRNF	==	4		;RECORD NOT FOUND STATUS BIT
WSREAD	==	10011100B 	;READ SECTOR STATUS MASK
WSWRIT	==	11111100B 	;WRITE SECTOR STATUS MASK
WSSEEK	==	10011000B 	;SEEK STATUS MASK
WFCINT	==	11010000B 	;FORCE INTERRUPT COMMAND

;         NOTE ABOUT THE 'SEC08' BUFFER
;SECTOR 8 IS READ INTO HERE, FOR MERGING OF THE DDB
;THIS IS ABOUT 1024 BYTES ABOVE THE 'GEN CP/M'
;IMAGE. FOR A BIOS SIZE OF 3K, THE IMAGE ENDS
;AT 29FFH. THIS WILL ALLOW FOR A BIOS AS LARGE
;AS 4K, WHICH WOULD END AT 2DFFH.
;IF YOU INCREASE YOUR BIOS BEYOND 4K, YOU WILL HAVE TO
;MOVE 'XFERAD' PAST THE BIOS IMAGE POINT

XFERAD	==	2E00H		;SAVED ADRESS
SEC08	==	XFERAD+2	;SECTOR 8 HERE

	LXI	SP,100H
	LXI	D,MESS1
	MVI	C,PRINTS
	CALL	BDOS

ISVFII:
	LXI	H,OKDRIV
	CALL	GETOK
	STA	DRIVE
	CPI	'A'
	JZ	VFA
	CPI	'B'
	JZ	VFB
	CPI	'C'
	JZ	VFC
	MVI	A,00010111B	;DRIVE D: FOR NOW
	JMP	GETDRV
VFA:	MVI	A,00011110B
	JMP	GETDRV
VFB:
	MVI	A,00011101B
	JMP	GETDRV
VFC:
	MVI	A,00011011B
GETDRV:
	OUT	DCNTL		;SET IT

; FIRST GET SECTOR 8 FOR DDB MERGE

RETRY:
	CALL	HOMEIT
	MVI	A,8
	OUT	WSECT
	MVI	A,0
	OUT	WTRACK

	LXI	H,SEC08	;PUT IT HERE FOR MERGE
	CALL	READER


;NOW WRITE OUT THE SYSTEM TRACKS

	LXI	H,900H	;CP/M IMAGE		
	MVI	E,1		;START AT SECTOR 1
	MVI	A,1
	OUT	WSECT
	CALL	WRITER

TRACK:
SECTOR:
	IN	WSECT	;UPDATE SECTOR REG IN 179X
	INR	A
	OUT	WSECT
	CPI	8		;SEE IF DDB SECTOR
	JNZ	TSTSEC
	IN	WTRACK
	CPI	0		;LAST TRACK?
	JNZ	TSTSEC
	PUSH	H		;SAVE MERGE ADDRESS
	
	LXI	D,SEC08	;PLACE IMAGE HERE
	LXI	B,(128*3)	;3 CP/M RECORDS
	LDIR			;SET IN PLACE
	
	LXI	H,SEC08
	CALL	WRITER
	POP	H
	LXI	D,(128*3)
	DAD	D		;MAKE NEXT LOC
	JMP	SECTOR
	
TRACK1:
TSTSEC:
GOON:
	IN	WSECT		;CHECK SECTOR # AGAIN
	CPI	9+1		;ENTIRE TRACK READ?
	JNZ	NXTSEC	;NO
	IN	WTRACK	;ALREADY READ TRACK 1?
	ORA	A
	JNZ	BOOT	;YES

	MVI	A,1	;START TRACK 1 WITH SECTOR 1
	OUT	WSECT
	MVI	A,5BH	;STEP IN TO TRACK 1
	OUT	WCMD
	CALL	WAITNB
	ANI	9CH	;STEP IN SUCCESSFUL?
	JNZ	RETRY	;NO, RETRY ENTIRE BOOT
	JMP	TRACK1	;GO READ TRACK 1

NXTSEC:
	CALL	WRITER
	JMP	SECTOR

READER:
	MVI	A,10
	STA	RECNT
	SHLD	XFERAD
READ0:
	LHLD	XFERAD
	MVI	A,WREAD	;ISSUE READ SECTOR COMMAND
	OUT	WCMD
	LXI	B,0067H
	INIR
	INIR
	
	CALL	WAITNB
	ANI	WSREAD+1	;WAS READ SUCCESSFUL?
	RZ
	LDA	RECNT
	DCR	A
	STA	RECNT
	JNZ	READ0		;NO, RETRY
	JMP	REDBAD

WRITER:
	SHLD	XFERAD
	MVI	A,10
	STA	RECNT
WRITE0:
	LHLD	XFERAD
	MVI	A,WWRITE	;ISSUE WRITE SECTOR COMMAND
	OUT	WCMD
	LXI	B,0067H
	OUTIR
	OUTIR
	
	CALL	WAITNB
	ANI	WSWRIT+1	;WAS WRITE SUCCESSFUL?
	RZ
	LDA	RECNT
	DCR	A
	STA	RECNT
	JNZ	WRITE0	;NO, RETRY
	JMP	WRBAD

HOMEIT:
	MVI	A,0BH	;RESTORE THE DISC DRIVE
	OUT	WCMD
..1LOP:
	INR	A
	JNZ	..1LOP

	CALL	WAITNB

	RET

;SUBROUTINE TO WAIT UNTIL THE 179X INDICATES THAT IT
;IS NOT BUSY. AT THAT TIME STATUS IS RETURNED TO THE CALLING PROGRAM

WAITNB:	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT

QUIKNB:
	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY ?
	JRNZ	QUIKNB	;YES,KEEP WAITING
	RET

FINI:
BOOT:
	LXI	D,MESS2
	MVI	C,PRINTS
	CALL	BDOS
	JMP	TEXIT
REDBAD:
	LXI	D,MESS3
	MVI	C,PRINTS
	CALL	BDOS
	JMP	TEXIT
WRBAD:
	LXI	D,MESS4
	MVI	C,PRINTS
	CALL	BDOS
TEXIT:
	LDA	DRIVE
	CPI	'A'
	JNZ	0
	LXI	D,MESSA
	MVI	C,PRINTS
	CALL	BDOS
	HLT

;****************************************************
; GET A CHARACTER FROM THE CONSOLE. IF THE CHARACTER
; IS UNACCEPTABLE, BEEP AND WAIT FOR ANOTHER. RETURN
; TO CP/M IF ^C IS ENTERED. (BDOS DOES RETURN ON ^C)
;****************************************************
; THE CCIR Z80 INSTRUCTION CHECKS ALL ACCEPTABLE
; CHARACTERS FROM THE TABLE POINTED TO BY HL
; A BAD INPUT CAUSES A BELL, PLUS A BACKSPACE
; BLANK-OVER AND BACKSPACE TO ERASE THE WRONG
; INPUT ON CONSOLE, THEN THE ROUTINE IS RE-ENTERED
;====================================================

GETOK:	
..RTRY:	PUSH	H	;SAVE OK TABLE ADDR
	MOV	C,M	;GET COUNT
	INX	H
	MVI	B,0
	CALL	CI	;GET A CHAR
	CPI	'Q'	;IS IT QUIT 
	JZ	GOBAK	;YES, GO BACK TO CP/M
	CCIR		;IS IT OKAY
	POP	H
	RZ		;YES, RETURN IT

	MVI	C,BELL	;NO, RING BELL
	CALL	CO
	MVI	C,8	;BACK SPACE
	CALL	CO
	MVI	C,' '
	CALL	CO
	MVI	C,8
	CALL	CO
	JMP	..RTRY	;KEEP TRYING

;***************************************************
;       GET A CHARACTER FROM THE CONSOLE.
;***************************************************

CI:	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,1	;CONSOLE INPUT
	CALL	BDOS	;GET THE CHARACTER
	POP	H
	POP	D
	POP	B
	RET

;**************************************************
;      WRITE A CHARACTER TO THE CONSOLE.
;**************************************************

CO:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	A,C
	ANI	7FH
	MOV	E,A	;MOVE CHARACTER TO E
	MVI	C,2	;CONSOLE OUTPUT
	CALL	BDOS	;OUTPUT THE CHARACTER
	POP	H
	POP	D
	POP	B
	MOV	A,C	;FIX UP ACC
	RET

GOBAK:
	LXI	D,QUITER
	MVI	C,PRINTS
	CALL	BDOS
	JMP	0

QUITER:
	.BYTE	CR,LF,LF,LF
	.ASCII	\EXITING TO COMMAND PROMPT $\


MESSA:
	.BYTE	CR,LF,LF
	.ASCII	\DRIVE "A" WAS UPDATED - HALTING FOR A REBOOT :$\

MESS1:	.BYTE	CLEAR,CR,LF,LF
	.ASCII	\VF-II SYSGEN FOR 5", OR MIN-FLOPPY DRIVES\
	.BYTE	CR,LF,LF
	.ASCII	\BE SURE A DISK IS ALREADY IN PLACE\
	.BYTE	CR,LF,LF
	.ASCII	\AS THE SYSGEN STARTS ONCE THE DRIVE IS TYPED IN\
	.BYTE	CR,LF,LF
	.ASCII	\SYSGEN TO DRIVE A, B, C OR D ENTER CHOICE => $\

MESS2:	.BYTE	CR,LF,LF
	.ASCII	\SYSGEN COMPLETE $\

MESS3:	.BYTE	CR,LF,LF
	.ASCII	\FAILED ON SECTOR READ, QUITING $\

MESS4:	.BYTE	CR,LF,LF
	.ASCII	\FAILED ON SECTOR WRITE, QUITING $\

OKDRIV:	.BYTE	4,'A','B','C','D'

DRIVE:	.BLKB	1
RECNT:	.BYTE	10
	


	.END
