;********************************************************
;*                VLOADER1                              *
;*                CP/M COLD BOOT LOADER	                *
;*                FOR VFBIOS                            *
;*                12/05/03       		        *
;********************************************************
;*
;* THIS -SYSTEM LOCATION INDEPENDENT - LOADER WORKS 
;* AS FOLLOWS
;* 1:
;* A BOOTSTRAP LOADER HAS READ THE FIRST 512 BYTE SECTOR
;* TO LOCATION 0000H, THIS LOADER IS WITHIN THE FIRST
;* 128 BYTES. THE BOOTSTRAP NOW JUMPS TO 0000H.
;* 2:
;* THE LOADER NEXT PICKS UP A CCP PAGE VALUE FROM BYTE
;* 130 REFERANCED TO THE BASE OF THE LOADER ITSELF
;* IT THEN ADJUSTS THAT VALUE TO SET THE BASE OF THE
;* CCP, AND SETS IT 128 BYTES LOWER TO SKIP OVER THE
;* LOADER. IT ALSO MAKES THE BIOS COLD BOOT ENTRY
;* VALUE AND SAVES THAT FOR THE FINAL JUMP TO SYSTEM
;* 3:
;* NOW THE LOADER READS IN THIS SECTOR AGAIN, INTO
;* THE CORRECT STARTING POINT FOR THE CCP + OFFSET
;* 4:
;* WHEN SECTOR #8 HAS BEEN READ IN, A SECOND 128 BYTE
;* BIAS IS ADDED, TO SKIP OVER THE 128 BYTE DDB FOR
;* THE DISK FORMAT DESCRIPTOR.
;* 5:
;* SECTOR #9 IS THEN READ IN
;* 6:
;* THE LOADER NOW STEPS IN TO TRACK 1 AND THE LOAD
;* CONTINUES UNTIL ALL SECTORS ARE IN PLACE
;* 7:
;* THE BIOS COLD BOOT LOCATION IS LOADED INTO THE (HL)
;* REGISTER PAIR AND A PCHL BRINGS UP THE SYSTEM

	.XLINK
	.Z80		;Z80 OPCODES USED
	.PHEX
	.PABS
	.LOC	0	;LOADER BEGINS HERE

; THE COLD START LOADER IS LOADED FROM THE FIRST 128
; BYTES OF TRACK 0, SECTOR 1 BY THE UNIVERSAL BOOT.
; THE LOADER READS IN THE REST OF THE CP/M SYSTEM.

; THE FIRST TWO TRACKS OF ANY SYSTEM DISK MUST HAVE AT
; LEAST 8 SECTORS OF 512 BYTES EACH. THE INFORMATION
; ON THESE SECTORS MUST BE:

;   TRACK 0, SECTOR 1, BYTES 0 THRU 127 - LOADER
;   TRACK 0, SECTOR 1, BYTES 128 THRU 511 - CP/M
;   TRACK 0, SECTOR 2 THRU SECTOR 7 - CP/M
;   TRACK 0, SECTOR 8, BYTES 0 THRU 383 - CP/M
;   TRACK 0, SECTOR 8, BYTES 384 THRU 511 - DDB
;   TRACK 0, SECTOR 9, BYTES 0 THRU 511 - CP/M
;   TRACK 1, SECTOR 1 THRU SECTOR 9 - CP/M, FOLLOWED
;	BY THE CBIOS

; THE LOADER EXTRACTS THE CP/M SECTORS FROM TRACK 0,
; SKIPPING OVER THE NON CP/M BYTES.
; THE LAYOUT OF THE SYSTEM TRACKS
; IS IDENTICAL FOR BOTH 5" AND 8" DISKETTES. THE SYSTEM
; TRACKS ON 5" DISKETTES ARE RECORDED IN DOUBLE DENSITY
; IN ORDER TO FIT ALL THE REQUIRED SECTORS.

; SINCE THE SYSTEM TRACK LAYOUT IS IDENTICAL, THIS ONE
; LOADER CAN BOOT FROM BOTH SIZES OF DISKS ONCE THE D3S
; OR D4S CONTROL BYTE HAS BEEN PROPERLY SET.


; FDC PORT ADDRESSES.

DCNTL	==	063H	;CONTROL PORT

WDC	==	064H	;WDC 179X BASE ADDRESS
WCMD	==	WDC+0	;COMMAND REGISTER
WSTAT	==	WDC+0	;STATUS REGISTER
WTRACK	==	WDC+1	;TRACK REGISTER
WSECT	==	WDC+2	;SECTOR REGISTER
WDATA	==	WDC+3	;DATA REGISTER



	.PAGE
; EQUATES TO ALLOW LOADING CP/M
; AT THE CORRECT LOCATION IN MEMORY:

;BIAS	==	(MSIZE-20)*1024
;CCP	==	3400H+BIAS
;BIOS	==	CCP+1600H
;BOOT	==	BIOS
;BCOUNT	==	512	;NUMBER OF BYTES TO READ IN
;DENS	==	7FH	;INITIAL CONTROL BYTE 8" DISK


; LOADER BEGINS HERE.

BOOTUP:

; FUNCTION TO TURN OFF ANY ONBOARD RAM/ROM
; REMOVE ; IF YOU HAVE THE CORRECT CPU CARD
; ELSE INSERT CODE FOR YOUR SYSTEM

;	MVI	A,2	;SBC-200 RAM/ROM BIT
;	OUT	7FH	;TURN OFF ONBOARD RAM/ROM

;	OUT	0AH	;SAME FOR ZEUS80


	LDA	BOOTUP+130 ;GET CCP JMP PAGE
	SUI	4	;SET DOWN FOR LODER OFFSET PAGE
	MOV	H,A
	MVI	L,80H	;AND SHIFT TO CCP
	SHLD	CCPBAS
	MVI	L,0
	LXI	D,1700H
	DAD	D
	SHLD	BIOBAS
RETRY:
	LHLD	CCPBAS

..HOME:
	MVI	A,0BH	;RESTORE THE DISC DRIVE
	OUT	WCMD
	CALL	WAITNB

	MVI	A,1	;START WITH SECTOR 1
	OUT	WSECT

TRACK:
SECTOR:
	MVI	A,88H	;READ SECTOR, NO SIDE TESTING
	OUT	WCMD
	LXI	B,0067H ;256 BYTE COUNTER, VF II PORT 67H
	INIR
	INIR
	CALL	WAITNB
	ANI	9DH	;WAS READ SUCCESSFUL?
	JRNZ	RETRY	;NO, RETRY ENTIRE BOOT
	IN	WSECT	;UPDATE SECTOR REG IN 179X
	INR	A
	OUT	WSECT

TSTSEC:
	CPI	9	;SEE IF SECTOR 9 NEXT	
	JRNZ	GOON	;IF NOT SKIP NEXT TEST
	IN	WTRACK	;GET CURRENT TRACK
	ORA	A	;SEE IF STILL 0
	JRNZ	GOON	;IF NOT SKIP NEXT TO GET LAST SECTOR
	LXI	D,-128	;ELSE ADJUST LOAD ADDRESS FOR DDB
	DAD	D	;FIX IT

GOON:
	CPI	9+1	;ENTIRE TRACK READ?
	JRNZ	SECTOR	;NO
	IN	WTRACK	;ALREADY READ TRACK 1?
	ORA	A
	JNZ	PBOOT	;YES

	MVI	A,1	;START TRACK 1 WITH SECTOR 1
	OUT	WSECT
	MVI	A,5BH	;STEP IN TO TRACK 1
	OUT	WCMD
	CALL	WAITNB
	ANI	9CH	;STEP IN SUCCESSFUL?
	JRNZ	RETRY	;NO, RETRY ENTIRE BOOT
	JMPR	TRACK	;GO READ TRACK 1

;SUBROUTINE TO WAIT UNTIL THE 179X INDICATES THAT IT
;IS NOT BUSY. AT THAT TIME STATUS IS RETURNED TO THE CALLING PROGRAM

WAITNB:	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT


QUIKNB:	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY ?
	JRNZ	QUIKNB	;YES,KEEP WAITING
	RET

PBOOT:
	LHLD	BIOBAS
	PCHL

CCPBAS:	.WORD	0
BIOBAS:	.WORD	0

; MARK END OF LOADER FOR SIZE TEST

FINI:	

	.DEFINE	BADMEM[XX]=
	[.PRNTX \LOADER IS TOO BIG BY XX BYTES\
	]
	.DEFINE	OKMEM[XX]=
	[.PRNTX	\XX BYTES LEFT IN THE LOADER\
	]

	.IF2,[
	.IFG	FINI-80H,[
	BADMEM	\(FINI-80H)
	][
	OKMEM \(80H-FINI)
	]
	]


	.END
