;********************************************************
;*                    V2LD2002
;*                CP/M COLD BOOT LOADER	
;*                HARD CODED LOAD POINTS
;*                FOR VFBIOS
;*                AND SBC-200
;*                12/11/03
;********************************************************
;*
;* THIS "HARD-CODED" LOADER WORKS AS FOLLOWS
;* 1:
;* A BOOTSTRAP LOADER HAS READ THE FIRST 512 BYTE SECTOR
;* TO LOCATION 0000H, THIS LOADER IS WITHIN THE FIRST
;* 128 BYTES. THE BOOTSTRAP JUMPS TO LOCATION 0000H
;* 2:
;* THIS LOADER NEXT ADJUSTS THE LOAD POINT FOR THE
;* CCP, AND SETS IT 128 BYTES LOWER TO SKIP OVER THE
;* LOADER. 
;* 3:
;* NOW THE LOADER READS IN THIS SECTOR AGAIN, INTO
;* THE CORRECT STARTING POINT FOR THE CCP + OFFSET
;* 4:
;* WHEN SECTOR #8 HAS BEEN READ IN, A SECOND 128 BYTE
;* BIAS IS ADDED, TO SKIP OVER THE 128 BYTE DDB FOR
;* THE DISK FORMAT DESCRIPTOR.
;* 5:
;* SECTOR #9 IS THEN READ IN
;* 6:
;* THE LOADER NOW STEPS IN TO TRACK 1 AND THE LOAD
;* CONTINUES UNTIL ALL SECTORS ARE IN PLACE
;* 7:
;* THE BIOS COLD BOOT LOCATION IS BRANCHED TO AND THAT
;* BRINGS UP THE SYSTEM


	.XLINK
	.Z80		;Z80 OPCODES USED
	.PHEX
	.PABS
	.LOC	0	;LOADER BEGINS HERE

; THE COLD START LOADER IS LOADED FROM THE FIRST 128
; BYTES OF TRACK 0, SECTOR 1 BY THE BOOTSTRAP.
; THE LOADER READS IN THE REST OF THE CP/M SYSTEM.

; THE FIRST TWO TRACKS OF ANY SYSTEM DISK MUST HAVE AT
; LEAST 9 SECTORS OF 512 BYTES EACH. THE INFORMATION
; ON THESE SECTORS MUST BE:

;   TRACK 0, SECTOR 1, BYTES 0 THRU 127 - LOADER
;   TRACK 0, SECTOR 1, BYTES 128 THRU 511 - CP/M
;   TRACK 0, SECTOR 2 THRU SECTOR 7 - CP/M
;   TRACK 0, SECTOR 8, BYTES 0 THRU 383 - CP/M
;   TRACK 0, SECTOR 8, BYTES 384 THRU 511 - DDB
;   TRACK 0, SECTOR 9, BYTES 0 THRU 511 - CP/M
;   TRACK 1, SECTOR 1 THRU SECTOR 9 - CP/M, FOLLOWED
;	BY THE CBIOS

; THE LOADER EXTRACTS THE CP/M SECTORS FROM TRACK 0,
; SKIPPING OVER THE NON CP/M BYTES.
; THE LAYOUT OF THE SYSTEM TRACKS
; IS IDENTICAL FOR BOTH 5" AND 8" DISKETTES. THE SYSTEM
; TRACKS ON 5" DISKETTES ARE RECORDED IN DOUBLE DENSITY
; IN ORDER TO FIT ALL THE REQUIRED SECTORS.

; SINCE THE SYSTEM TRACK LAYOUT IS IDENTICAL, THIS ONE
; LOADER CAN BOOT FROM BOTH SIZES OF DISKS ONCE THE D3S
; OR D4S CONTROL BYTE HAS BEEN PROPERLY SET.


; FDC PORT ADDRESSES.

DCNTL	==	063H	;CONTROL PORT
WDC	==	064H	;WDC 179X BASE ADDRESS
WCMD	==	WDC+0	;COMMAND REGISTER
WSTAT	==	WDC+0	;STATUS REGISTER
WTRACK	==	WDC+1	;TRACK REGISTER
WSECT	==	WDC+2	;SECTOR REGISTER
WDATA	==	WDC+3	;DATA REGISTER



	.PAGE
; EQUATES TO ALLOW LOADING CP/M
; AT THE CORRECT LOCATION IN MEMORY:

;BIOS SIZE FUNCTION (* 1024 BYTES)  NEXT

BIOSIZ	=\	\ENTER THE KILOBYTE SIZE OF BIOS EG: 3 OR 4 \

;IF YOU ENLARGE THE BIOS, YOU WILL INCREASE
;BIOSIZ BY 1 FOR EACH ADDITIONAL KILOBYTE, OR
;PART THEREOF.

MSIZ	=\	\ENTER TOTAL MEMORY SIZE IN KILOBYTES EG: 48 OR 64 \

MSIZE	==	MSIZ-BIOSIZ	;SUBTRACT BIOS SIZE
BIAS	==	(MSIZE-20)*1024 ;THE DRI BIAS FACTOR
CCP	==	3400H+BIAS	;BASE OF CCP
BDOS	==	CCP+806H	;BASE OF BDOS
BIOS	==	CCP+1600H	;BASE OF BIOS
MOVECP	==	BDOS+1400H	;MOVECPM ADJUST
MOVEIT	==	MOVECP/1024
NSECTS	==	(BIOS-CCP)/128	;WARM START SECTOR CNT, 128 BYTES SECTORS
NSBIOS	==	70-NSECTS	;MAX SECTORS FOR CBIOS & CP/M
BOOT	==	BIOS

; LOADER BEGINS HERE.

;THE FOLLOWING FUNCTION IS OPTIONAL
;
; - CASE EXAMPLES -
;
; RAM/ROM DISABLE NOT REQUIRED IF:
;
;(1) - YOUR BOOTSTRAP HAS LOADED ITSELF INTO MEMORY BELOW ANY
;      ONBAORD RAM/ROM AND HAS TURNED ANY RAM/ROM OFF
;      BEFORE READING THE LOADER FROM DISK
;
;(2) - YOUR CP/M SYSTEM FITS BELOW ANY ONBOARD RAM/ROM
;
; RAM/ROM DISABLE REQUIRED IF:
;
;(1) YOUR CP/M SYSTEM WILL OVERLAY ONBOARD RAM/ROM
;
;

; PLACE ANY ONBOARD RAM/ROM DISABLE CODE HERE TO CONFORM WITH
; THE FUNCTIONALITY OF YOUR CPU BOARD
; - YOU CAN ADD LIVE CODE FOR MULTIPLE CPU TYPES, AS LONG
;   AS THE FUNCTIONALITY DOES NOT INTERFERE WITH THE
;   SELECTED CPU OPERATION AT BOOT TIME
; - ALSO DO NOT EXCEED LOADER LENGTH OF 128 BYTES


; FOR SD SYSTEMS SBC-200

	MVI	A,2	;SBC-200 RAM/ROM BIT
	OUT	7FH	;TURN OFF ONBOARD RAM/ROM

;DISK LOADER FUNCTION

RETRY:

..HOME:
	MVI	A,0BH	;RESTORE THE DISC DRIVE
	OUT	WCMD
	CALL	WAITNB

	MVI	A,1	;START WITH SECTOR 1
	OUT	WSECT
 	LXI	H,CCP-128;LOAD LOWER IN MEMORY TO
			 ;SKIP BEGINNING OF SECTOR 1
TRACK:
SECTOR:
	MVI	A,88H	;READ SECTOR
	OUT	WCMD
	LXI	B,0067H
	INIR
	INIR
	CALL	WAITNB
	ANI	9DH	;WAS READ SUCCESSFUL?
	JRNZ	RETRY	;NO, RETRY ENTIRE BOOT
	IN	WSECT	;UPDATE SECTOR REG IN 179X
	INR	A
	OUT	WSECT

TSTSEC:
	CPI	9	;SEE IF SECTOR 9 NEXT	
	JRNZ	GOON	;IF NOT SKIP NEXT TEST
	IN	WTRACK	;GET CURRENT TRACK
	ORA	A	;SEE IF STILL 0
	JRNZ	GOON	;IF NOT SKIP NEXT TO GET LAST SECTOR
	LXI	D,-128	;ELSE ADJUST LOAD ADDRESS FOR DDB
	DAD	D	;FIX IT

GOON:
	CPI	9+1	;ENTIRE TRACK READ?
	JRNZ	SECTOR	;NO
	IN	WTRACK	;ALREADY READ TRACK 1?
	ORA	A
	JNZ	BOOT	;YES

	MVI	A,1	;START TRACK 1 WITH SECTOR 1
	OUT	WSECT
	MVI	A,5BH	;STEP IN TO TRACK 1
	OUT	WCMD
	CALL	WAITNB
	ANI	9CH	;STEP IN SUCCESSFUL?
	JRNZ	RETRY	;NO, RETRY ENTIRE BOOT
	JMPR	TRACK	;GO READ TRACK 1

;SUBROUTINE TO WAIT UNTIL THE 179X INDICATES THAT IT
;IS NOT BUSY. AT THAT TIME STATUS IS RETURNED TO THE CALLING PROGRAM

WAITNB:	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT


QUIKNB:	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY ?
	JRNZ	QUIKNB	;YES,KEEP WAITING
	RET

FINI:

;//PRINT MEMORY STRUCTURES.

OFFST	==	1F80H -BIOS

	.IF1,[

	.DEFINE SBIOS[XX]=[
	.PRNTX	/XX IS START OF BIOS/			]

	.DEFINE	BDOSL[XX]=[
	.PRNTX	/XX IS START OF BDOS/			]

	.DEFINE	CCPL[XX]=[
	.PRNTX	/XX IS START OF CCP/			]

	.DEFINE	OFFSET[XX]=[
	.PRNTX	/XX IS BIOS OFFSET /			]


	.DEFINE MOVCPM[XX]=[
	.PRNTX	/XX IS MOVECPM VALUE /			]

	.IFG	(.-BIOS)-(6*256+BIOSIZ*1024),[


	.RADIX	16
	SBIOS	\BIOS
	BDOSL	\BDOS
	CCPL	\CCP
	OFFSET	\OFFST
	.RADIX	10
	MOVCPM	\MOVEIT

		][

	.RADIX	16
	SBIOS	\BIOS
	BDOSL	\BDOS
	CCPL	\CCP
	OFFSET	\OFFST
	.RADIX	10
	MOVCPM	\MOVEIT
		]
		]

;SHOW SYSTEM LOADER STATS

	.DEFINE	BADMEM[XX]=
	[.PRNTX \LOADER IS TOO BIG BY XX BYTES\
	]
	.DEFINE	OKMEM[XX]=
	[.PRNTX	\XX BYTES LEFT IN THE LOADER\
	]

	.IF2,[
	.IFG	FINI-80H,[
	BADMEM	\(FINI-80H)
	][
	OKMEM \(80H-FINI)
	]
	]


	.END
