;**********************************************
;*             V2FORMAT.ASM                   *
;*             FORMAT PROGRAM                 *
;*        WITH READ VERIFICATION              *
;*              12/15/03                      *
;**********************************************                   

VERS	==	80H	;VERSION NUMBER

	.Z80		;Z80 CODE USED
	.PHEX		;DDT COMPATIBLE
	.PABS
	.XLINK
	.XSYM		;NO SYMBOL TABLE
	.LOC	100H	;CP/M COMPATIBLE

; AS YOU MAKE CHANGES, UPDATE THE VERSION INFO

FVER	==	1	;INITIAL
FVER1	==	0	;RELEASE
FVER0	==	0	;TEST


; == NOTE THE "ALL-CAPS TEXT", WHICH WAS COMMON, DUE TO
; == LINE-PRINTERS, AND EVEN CRT'S THAT DID NOT
; == SUPPORT LOWER-CASE TEXT.
;
;
; DISK FORMAT PROGRAM FOR CP/M 2.1 OR GREATER.
;
; WRITTEN BY 
;
;==================================================
; MANY THANKS TO BOHDAN TASHCHUK FOR THIS CODE
; AND HIS QUALITY SUPPORT OF THOSE WHO USED IT
;==================================================
;
;     B. JONES 1981
; - 1024 BYTE SECTOR SUPPORT ADDED
; - ADDED 9, 512 BYTE SECTORS FOR EACH SYSTEM TRACK
;   THIS ALLOWS A LARGER BIOS TO BE CREATED, FOR
;   SUPPORTING MORE DRIVES, HARD DRIVES OR SPECIAL FUNCTIONS
; - FORMAT OPTION "SAVE" FEATURE ADDED
; - READ-VERIFY AFTER FULL FORMAT ADDED - BIOS DEPENDENT
; - INSERT ROUTINE TO UN-JAM HEADS AT START OF FORMATTING
; - ALLOW SAFE FORMAT OF 'A' DRIVE
; - ALLOW FORMATS UNDER MP/M-80 1.1 OR 1.2
; - ADDED PARALLEL SUPPORT FOR TARBELL DD DMA FDC
;   THIS PROGRAM WILL CHECK TO SEE WHICH CONTROLLER IS
;   IN SYSTEM AND WORK WITH IT.
;
;      B. JONES NOV. 2003
; - VERSAFLOPPY II SUPPORT ADDED
; - 10 & 11, 1024 BYTE SECTORS PER TRACK ADDED FOR 3.5" HD DISKS
; - STANDARD DISK FORMATS ALLOWED (NO SPECIAL SYSTEM TRACKS)
; - READ-VERIFY AFTER EACH TRACK FORMATED - NOT BIOS DEPENDENT
; - "QUIT" FUNCTION FOR ANY OPTION ALLOWED
; - USER ENABLE/DISABLE READ VERIFICATION
; - REMOVED MP/M-80 SUPPORT
; - REMOVED TARBELL DD DMA FDC SUPPORT
; - ADDED SUPPORT FOR BOTH VF II AND Z3S CONTROLLERS
; - ADDED BUFFER SIZE TESTING
;   



;******************************************************
; THIS PROGRAM "FORMATS" A SOFT SECTORED FLOPPY DISK.
; THE FORMATING FOLLOWS THE GUIDELINES FOR IBM
; COMPATIBILITY. THE FOLLOWING OPTIONS ARE AVAILABLE:
;
;	FORMAT ALL TRACKS OR SYSTEM TRACKS ONLY
;	5 INCH OR 8 INCH DISK
;	SINGLE OR DOUBLE DENSITY DISK
;	SINGLE OR DOUBLE SIDED DISK
;	128, 256, 512 OR 1024 BYTE SECTORS
;	NORMAL OR EXTENDED NUMBER OF TRACKS 
;                   == NOTE == 
; EXTENDED TRACKS OMITTED. WERE ONLY USED FOR OLD 5"
; MINI-FLOPPIES, GIVING 39 TRACKS INSTEAD OF 35.
; THE CODE IS LEFT IN, BUT COMMENTED-OUT.
; IF YOU NEED IT, REMOVE THE ";" CHARACTERS, AND
; YOU ARE ON YOUR OWN! (THERE MAY BE SOME GOOD
; REASON FOR IT BEING DISABLED!)


	.PAGE
; MACROS TO MAKE TRACK IMAGE FOR FDC TRACK WRITES

	.DEFINE	RB[VAR,%A]=[
	LDA	VAR'L	;GET LENGTH
	ORA	A
	JRZ	%A	;EXIT IF NULL
	MOV	C,A
	MVI	B,0
	MOV	D,H
	MOV	E,L
	INX	D
	LDA	VAR'V	;GET VALUE
	MOV	M,A
	LDIR		;GENERATE NEXT PATTERN
%A:]
	.DEFINE	RW[VAR,%A]=[
	LBCD	VAR'L	;GET LENGTH
	MOV	A,B
	ORA	C
	JRZ	%A	;EXIT IF NULL
	MOV	D,H
	MOV	E,L
	INX	D
	LDA	VAR'V	;GET VALUE
	MOV	M,A
	LDIR		;GENERATE NEXT PATTERN
%A:]
	.PAGE


FALSE	==	0H	;TRUE AND FALSE VALUES
TRUE	==	#FALSE
Z3S	==	TRUE	;THIS VERSION FOR THE Z3S BOARD
;MLIST	==	FALSE	;MACRO EXPANSION FLAG
MLIST	==	TRUE	;MACRO EXPANSION FLAG

;***************************************************
;                 GENERAL EQUATES.
;***************************************************

BDOS	==	5
CR	==	13
LF	==	10
CONTLC	==	3	;<CONTROL-C> CHAR
BELL	==	7
CLEAR	==	26	;ZEUS80 CLEAR SCREEN

;***************************************************
;         PIO FLOPPY DISK EQUATES.
;***************************************************

; CONTROL BYTE VALUES, USED TO SET THE CONTROL
; REG. FOR PROPER HARDWARE TO FORMAT VALUES

;FOR VERSAFLOPPY II

DBWAIT  ==      7       ;WAIT BIT
DBSIDE  ==      4       ;SIDE SELECT BIT
DCMD8S  ==      0F0H    ;8", SING DENS, SIDE 0, NO WAIT
DCMD8D  ==      0B0H    ;8", DOUB DENS, SIDE 0, NO WAIT
DCMD5S  ==      0D0H    ;5", SING DENS, SIDE 0, NO WAIT
DCMD5D  ==      90H     ;5", DOUB DENS, SIDE 0, NO WAIT

; FOR Z3S FDC BOARD

ZBWAIT  ==      6       ;WAIT BIT
ZBSIDE  ==      4       ;SIDE SELECT BIT
ZCMD8S  ==      50H     ;8", SING DENS, SIDE 0, NO WAIT
ZCMD8D  ==      0D0H    ;8", DOUB DENS, SIDE 0, NO WAIT
ZCMD5S  ==      70H     ;5", SING DENS, SIDE 0, NO WAIT
ZCMD5D  ==      0F0H    ;5", DOUB DENS, SIDE 0, NO WAIT

; FDC PORTS

DCMD	==	63H
W	==	064H	;WDC 179X PORTS
WCMD	==	W+0	;COMMAND REG
WSTAT	==	W+0	;STATUS REG
WTRACK	==	W+1	;TRACK REG
WSECT	==	W+2	;SECTOR REG
WDATA	==	W+3	;DATA I/O PORT

WFCINT	==	0D0H	;FORCED INTERRUPT COMMAND
SSEEK	==	1BH	;A REALLY SLOW SEEK COMMAND


;***************************************************
;          COMMON 179X COMMANDS/STATUS
;***************************************************

WSTIN	==	01011011B ;STEP IN
WHOMEF	==	00001011B ;HOME
WWRTRK	==	11110100B ;WRITE TRACK
WWRIT	==	10101100B ;WRITE SECTOR	

WSSTIN	==	10011100B ;STEP IN STATUS
WSHOME	==	10011100B ;HOME STATUS
WSWRTR	==	11100100B ;WRITE TRACK STATUS
WSWRIT	==	11111100B ;WRITE SECTOR STATUS

WBTRK0	==	2
WBBUSY	==	0


FORMAT:
	LXI	SP,100H	;VALIDATE THE STACK POINTER


;***************************************************
;        SIGN ON AND GET FORMAT DATA
;***************************************************

SIGONF:
	XRA	A
	STA	FINFLG		;ALLOW READS IF NEEDED
	LDA	QUFLAG
	CPI	0
	JNZ	NOSHOW

ENTRE0:
        CALL    MSGF
        .BYTE   CLEAR
        .ASCII  \                              VFORMAT Disk Format\
        .BYTE   CR,LF
        .ASCII  \                                     V \
	.BYTE	(FVER)@10+'0','.',(FVER1)@10+'0','.',(FVER0)@10+'0'
        .BYTE   CR,LF+80H

	CALL	MSGF
        .ASCIS  \                             for VF II disk controller\
COMESS:
	CALL	MSGF
        .BYTE   CR,LF,LF
        .ASCII  \                                       NOTE:\
        .BYTE   CR,LF,LF
        .ASCII  \            3.5" and 5.25" HD PC drives are supported as 8" drives.\
        .BYTE   CR,LF
        .ASCII  \          All selectable 5" formats are for older mini-floppy drives.\
        .BYTE   CR,LF,LF+80H

;***************************************************
; ASK THE USER FOR THE DESIRED OPTIONS. TELL HIM THE
; OPTIONS HE SELECTED.
;***************************************************

NOSHOW:
	LXI	H,QUFLAG
	MOV	A,M	
	ORA	A	;DID WE ASK QUESTIONS ALREADY
	JRNZ	..TELL	;YES
	INR	A	;REMEMBER NOT TO ASK AGAIN
	MOV	M,A

..ASK:	CALL	QUEST	;ASK HIM ABOUT THE OPTIONS

..TELL:	CALL	TELL	;TELL HIM THE OPTIONS

;***************************************************
; ASK THE USER WHICH DISK DRIVE HAS THE DISK TO BE
; FORMATTED. ALLOW HIM TO GO BACK TO CHANGE THE
; OPTIONS OR TO QUIT.
;***************************************************

..GET:	CALL	MSGF
	.BYTE	CR,LF,LF
	.ASCII	\                           Type disk letter to format\
	.BYTE	CR,LF
	.ASCII	\or X to change options, S to save format or Q to stop \
	.ASCIS	\(A, B, C, D, X, S, Q): \ 

	LXI	H,DROK
	CALL	GETOK
	CPI	'X'	;CHANGE OPTIONS
	JNZ	..ASKC	;YES
	CALL	MSGF
	.BYTE	CLEAR+80H
	JMP	..ASK

..ASKC:
	CPI	'S'
	JZ	SAVEIT	;MAKE NEW COPY OF FORMAT
	CPI	'Q'
	JZ	GOBAK	;QUIT

	SUI	'A'	;TURN LETTER INTO BINARY
	STA	DRIVE	;THIS IS THE DRIVE TO USE

	CPI	0
	JNZ	DOIT

; FOR THE SYSTEM DRIVE, WE WARN USER TO REMOVE THE CURRENT DISKETTE

	CALL	MSGF
	.BYTE	CLEAR,CR,LF,LF
	.ASCIS	\Remove system disk, insert new disk & enter F to format :\

	LXI	H,FOROK
	CALL	GETOK
	JMPR	DOIT1

DOIT:
	CALL	MSGF
	.BYTE	CLEAR,CR,LF,LF
	.ASCIS	\Ensure disk to format is placed in drive, enter F to format :\
	LXI	H,FOROK
	CALL	GETOK

;***********************************************************
; FORMAT THE SELECTED DISK.
; DO SYSTEM TRACKS FIRST IN SINGLE DENSITY 512 BYTE SECTORS
; IF THE 'S', STANDARD FORMAT OPTION WAS SELECTED, WE
; FIX THIS UP LATER TO MAKE ALL TRACKS THE SAME.
;***********************************************************

DOIT1:
	LDA	SISAV	;DISK SIZE
	STA	SIZE
	MVI	A,'5'	;SECTOR SIZE ON SYSTEM TRACKS
	STA	SSIZ
	LDA	SISAV	;EIGHT INCH DISK
	CPI	'8'
	JRZ	..EIG0	;YES
	MVI	A,'3'
	STA	SSIZ

..FIV0:	MVI	A,'D'	;DOUBLE DENS SYS TRACKS ON 5"
	STA	DEN
	MVI	A,2	;LAST SYSTEM TRACK
	JMPR	..J0

;****************************************************
;    SET POINTER TO SPECIAL SYSTEM TRACK FORMAT
;  THIS WRITES 9 512 BYTE SECTORS ON SYSTEM TRACKS
;****************************************************

..EIG0:	MVI	A,'T'	;SINGLE DENS SYS TRACKS ON 8"
			;POINTS TO SYSTEM TRACK TABLE
	STA	DEN

	MVI	A,'S'
	STA	SDFORM	;JUST SIDE 0

	MVI	A,1	;LAST SYSTEM TRACK

..J0:	STA	MAXTRK
	XRA	A	;START AT TRACK 0
	STA	TRAKK
	CALL	LTABLE	;LOCATE CORRECT TABLE

;***************************************************
;  NOW SET 'T' DENSITY TO CORRECT 'S' DENSITY
; THE FORMER 'T' SETTING WAS USED TO ALLOW
; THE TRACK BUILDING ROUTINE TO LOCATE THE
; SPECIAL SYSTEM TRACK PARAMETER TABLE.
; BUT NOW WE SET THE 'S' SINGLE DENSITY MARKER
; IN PLACE SO THAT THE CORRECT CONTROL BYTE
; WILL BE PICKED UP FOR THE ACTUAL PHTSICAL I/O.
;***************************************************

	MVI	A,'S'	;CORRECT DENSITY
	STA	DEN	;AND SET IN PLACE
	LDA	STDSAV	;GET SYSTEM TRACK FORMAT
	CPI	'V'	;SEE IF V2BIOS TYPE
	JZ	VFFORM 	;DO V2BIOS SYSTEM TRACKS

; GOSH! AFTER ALL THAT WE NOW SEE THE USER WANTS
; 'S' STANDARD TRACKS. OH WELL!
; DO 'STANDARD' SYSTEM TRACK FORMAT HERE

	LDA	LESAV	;USER SECTOR SIZE
	STA	SSIZ
	LDA	DESAV	;USER TRACK DENSITY
	STA	DEN
	LDA	SDSAV	;USER SIDES
	STA	SDFORM


	CALL	LTABLE
	CALL	CTRAKK	;CREATE PROTOTYPE TRACK IMAGE
	CALL	SELECT	;SELECT DRIVE, SET Z3S BYTE
	STA	Z3SSYS	;SAVE SYSTEM TRACK Z3S BYTE

	CALL	HOMEF	;RESTORE THE DRIVE

;  - B. JONES -
; ADDED THIS SMALL OPERATION IN 1981.
; IT SEEMS SOME DRIVES DID NOT HOME PROPERLY FROM THE 
; ABOVE 'HOMEF' OPERATION, SO WE PUSH THE HEADS OUT
; 20 TRACKS AND HOME AGAIN. IT COULD BE THAT, IF THE
; HEADS WERE ALREADY AT HOME, THEY JAMMED WHEN THE 
; ABOVE 'HOMEF' OPERATION WAS ISSUED. SO WE SEEK OUT
; AND HOME AGAIN JUST TO COVER THAT EVENTUALITY.

	MVI	A,20	;TRACK 20
	OUT	WDATA	;SET IT
	MVI	A,SSEEK	;DO A SLOW-RATE SEEK OUT
	OUT	WCMD
	CALL	FDONEF	;GET THE ALL-DONE
	CALL	HOMEF	;NOW HOME FROM A KNOWN POSITION

; OK. NOW WE CAN START TO FORMAT!

	CALL	MSGF
	.BYTE	CR,LF,LF+80H

	CALL	SUFORM	;FORMAT SYSTEM TRACKS
	JMP	DOUSER	;NOW DO THE 'USER' OR DATA TRACKS

; HERE WE START THE 'S' STANDARD FORMAT OPERATION
; SYSTEM TRACK FORMAT WILL = DATA TRACK FORMAT.

VFFORM:
	CALL	CTRAKK	;CREATE PROTOTYPE TRACK IMAGE
	CALL	SELECT	;SELECT DRIVE, SET Z3S BYTE
	STA	Z3SSYS	;SAVE SYSTEM TRACK Z3S BYTE

	CALL	HOMEF	;RESTORE THE DRIVE

; HERE WE UN-JAM THE HEADS AGAIN. IT SEEMS TO HAPPEN
; ON SOME DRIVE TYPES. THIS FIXES THAT PROBLEM

	MVI	A,20
	OUT	WDATA
	MVI	A,SSEEK
	OUT	WCMD
	CALL	FDONEF
	CALL	HOMEF

	CALL	MSGF
	.BYTE	CR,LF,LF+80H

	CALL	SUFORM	;FORMAT SYSTEM TRACKS

;*****************************************************
;             NOW FORMAT USER TRACKS
;*****************************************************

DOUSER:
	CALL	STEPIN	;MOVE TO FIRST USER TRACK
	LDA	SDSAV
	STA	SDFORM
	LDA	LESAV	;USER TRACK SECTOR SIZE
	STA	SSIZ
	LDA	DESAV	;USER TRACK DENSITY
	STA	DEN
	LDA	SISAV	;GET DISK SIZE
	CPI	'8'	;EIGHT INCH DISK
	JRZ	..EIG1	;YES

..FIV1:	LDA	NESAV	;STANDARD OR EXTENDED TRACK
	CPI	'S'
	MVI	A,34	;STANDARD MAX TRACK ON 5"
	JRZ	..J1	;WAS STANDARD
	MVI	A,39	;EXTENDED MAX TRACK ON 5"
	JMPR	..J1

..EIG1:	MVI	A,76	;MAX TRACK ON 8"

..J1:	STA	MAXTRK

	DI

	CALL	LTABLE	;LOCATE CORRECT TABLE
	CAL	CTRAKK	;CREAT PROTOTYPE IMAGE
	LDA	TRSAV	;GET TRACK FORMAT FLAG
	CPI	'S'	;FORMAT SYSTEM TRACKS ONLY
	JRZ	..FIN	;YES, GO FINISH UP
	CALL	SELECT	;SET USER TRACK Z3S CTRL BYTE

	CALL	SUFORM	;FORMAT USER TRACKS

..FIN:	CALL	HOMEF	;RESTORE DRIVE
	LDA	Z3SSYS	;MAKE SYSTEM TRACK Z3S BYTE
	STA	Z3SBYT	;   THE CURRENT Z3S BYTE
	LDA	STDSAV	; GET SYSTEM TRACK TYPE
	CPI	'V'
	JNZ	GOBAK	; IF NOT BIOS COMPATIBLE, EXIT

	CALL	WRDDB	;WRITE OUT DDB
	JMP	READD	;GO TEST THE DISK

;*****************************************************
; WAIT FOR REBOOT SIGNAL. COME HERE FROM A SUBROUTINE
; IF AN ERROR HAS OCCURED. ALLOW THE USER TO REBOOT
; CP/M OR TO RESTART THE FORMAT PROGRAM.
;*****************************************************

WTBOOT:	CALL	MSGF
	.BYTE	CR,LF
	.ASCIS	\                  type   Q  to  quit or R to restart the program \
	LXI	H,CCOK
	CALL	GETOK	;WAIT FOR INPUT
	JMP	FORMAT	;ELSE RESTART THE PROGRAM


; FORMAT A GROUP OF TRACKS. THESE MAY BE THE SYSTEM
; TRACKS OR THE USER TRACKS.

SUFORM:	LDA	TRAKK	;GET CURRENT TRACK NUMBER
	MOV	C,A
	MVI	B,0	;UPDATE IMAGE TO SIDE 0
	CALL	UTRACK	;UPDATE IMAGE TO CURRENT TRACK
	XRA	A
	STA	RVSIDE
	CALL	FTRACK	;FORMAT SIDE 0

;	LDA	SDSAV

	LDA	SDFORM

	CPI	'S'	;SINGLE SIDED DISK
	JZ	SSID	;YES

	LDA	TRAKK	;UPDATE IMAGE TO SIDE 1
	MOV	C,A
	MVI	B,1
	CALL	UTRACK

	LDA	Z3SBYT	;UPDATE Z3S BYTE TO SIDE 1
	XRI	1<DBSIDE
	JMP	SBYT01

SBYT01:
	STA	Z3SBYT
	MVI	A,1
	STA	RVSIDE

	CALL	FTRACK

	LDA	Z3SBYT	;RESTORE Z3S BYTE TO SIDE 0
	XRI	1<DBSIDE

SBYT02:
	STA	Z3SBYT

SSID:	LDA	TRAKK	;UPDATE CURRENT TRACK NUMBER
	INR	A
	STA	TRAKK
	DCR	A
	LXI	H,MAXTRK ;DID WE JUST DO THE MAX TRACK
	CMP	M
	RZ		;YES, ALL DONE
	CALL	STEPIN	;MOVE DRIVE TO MEXT TRACK
	JMPR	SUFORM	;CONTINUE


; WRITE OUT THE DDB IN THE LAST 128 BYTES OF
; SIDE 0, TRACK 0, SECTOR 8.

WRDDB:	LXI	D,TBEGIN+1 ;SET UP FOR FILL CHARACTER
	LXI	H,TBEGIN
	LXI	B,512-128
	MVI	M,0E5H
	LDIR		;MOVE FILL CHAR INTO SECTOR
	LXI	B,128-1
	MV	M,0
	LDIR		;CLEAR WHERE DDB WILL GO

	LXI	D,TBEGIN+512-128 ;PUT THE DDB HERE
	LXI	H,DTABLE
	LDA	DDBLOC	;GET DDB LOCATION INTO HL
	MOV	C,A
	MVI	B,0
	DAD	B
	LDA	DDBLEN	;GET THE DDB LENGTH INTO BC
	MOV	C,A
	LDIR		;MOVE IN THE DEFAULT DDB
	LDA	SDSAV	;SEE IF SINGLE SIDED DISK
	CPI	'S'
	JRZ	..SING	;YES, DEFAULT DDB IS OKAY

	LXI	D,TBEGIN+512-128 ;ALTERNATE DDB HERE
	LXI	H,ALTDDB ;ALT DDB LOCATION INTO HL
	LDA	ALTLEN	;LENGTH OF ALT DDB INTO BC
	MOV	C,A
	MVI	B,0
	LDIR		;MOVE IN THE ALTERNATE DDB

..SING:


	XRA	A	;SET FDC TO TRACK 0
	OUT	WTRACK
	MVI	A,8	;AND TO SECTOR 8
	OUT	WSECT
	LXI	H,TBEGIN ;SET START ADDRESS
	LXI	B,0<8+WDATA ;SET COUNT AND PORT


	LDA	Z3SBYT	;SET HARDWARE DATA WAIT
	XRI	1<DBWAIT
DCMD01:
	OUT	DCMD
	MVI	A,WWRIT
	OUT	WCMD
	OUTIR		;WRITE THE SECTOR
	OUTIR
	LDA	Z3SBYT	;RESET HARDWARE DATA WAIT
	OUT	DCMD
SWFIN:
	CALL	FDONEF	;CHECK FOR SUCCESSFUL WRITE
	ANI	WSWRIT
	JRNZ	..BAD	;UNSUCCESSFUL
	MVI	B,0
	DJNZ	.	;WAIT FOR TRIM ERASE TO END
	RET

..BAD:	CALL	MSGF
	.BYTE	LF,LF,CR,LF
	.ASCIS	\                               write sector error \
	JMP	ASKFOR

;******************************************************
; QUESTION THE USER TO DETERMINE THE DESIRED FORMATTING
; OPTIONS.
;******************************************************

QUEST:
GETSYS:
	CALL	MSGF

	.BYTE	CR,LF,LF
	.ASCIS	\Will disk be V2BIOS compatible or Standard format ('V','S') :\
	LXI	H,STDSYS
	CALL	GETOK
	STA	STDSAV

        CALL    MSGF    ;GET NUMBER OF TRACKS TO FORMAT
        .BYTE   CR,LF,CR,LF
        .ASCII  \format all tracks or format\
        .ASCIS  \ system tracks only (A,S): \
        LXI     H,TROK  ;POINT TO OK RESPONSES
        CALL    GETOK   ;GET AN OKAY CHARACTER
        STA     TRSAV
        CALL    MSGF    ;GET SIZE OF DISK
        .BYTE   CR,LF
        .ASCII  \5 inch disk or 8 inch disk \
        .ASCIS  \(5,8): \
        LXI     H,SIOK
        CALL    GETOK   ;GET SIZE
        STA     SISAV
        LXI     H,NESAV ;ASSUME STANDARD DRIVE
        MVI     M,'S'

;       CPI     '5'     ;MINI IF SO MAY BE WANGCO
;       JRNZ    ..EIG   ;NOPE
;       CALL    MSGF    ;GET NUMBER OF TRACKS
;       .BYTE   CR,LF
;       .ASCII  \standard drive or extended \
;       .ASCIS  \track drive (S,E): \
;       LXI     H,NEOK
;       CALL    GETOK
;       STA     NESAV

..EIG:  CALL    MSGF    ;GET NUMBER OF SIDES
        .BYTE   CR,LF
        .ASCII  \single sided disk or double \
        .ASCIS  \sided disk (S,D): \
        LXI     H,SDOK
        CALL    GETOK
        STA     SDSAV
        
        CALL    MSGF    ;GET RECORDING DENSITY
        .BYTE   CR,LF
        .ASCII  \single density disk or double \
        .ASCIS  \density disk (S,D): \
        LXI     H,DEOK
        CALL    GETOK   ;GET DENSITY
        STA     DESAV
..TEN:

	LDA	SISAV	;CHECK SIZE AGAIN
	CPI	'8'
	JZ	..IS8

	CALL    MSGF    ;GET SECTOR SIZE 
        .BYTE   CR,LF
        .ASCII  \sector size of 128 (1) , 256 (2), \
        .ASCIS  \or 512 (3) bytes (1,2,3): \
        LXI     H,LEOK5
        CALL    GETOK   ;GET SIZE
        STA     LESAV
	JMP	SKIPVF


..IS8:
        CALL    MSGF    ;GET SECTOR SIZE 
        .BYTE   CR,LF
        .ASCII  \sector size of 128 (1) , 256 (2), \
        .ASCIS  \512 (3) , or 1024 (4)  bytes (1,2,3,4): \
        LXI     H,LEOK
        CALL    GETOK   ;GET SIZE
        STA     LESAV
        CPI     '4'
	JNZ	SKIPVF
        LDA     DESAV
        CPI     'S'
        JZ	SKIPVF

        CALL    MSGF    ;GET SECTORS PER TRACK
        .BYTE   CR,LF
        .ASCII  \sectors per track 9 (1),10 (2),\
        .ASCIS  \or 11 (3) - 2 & 3 for 3.5" HD drives (1,2,3): \
        LXI     H,MEGSOK
        CALL    GETOK   ;GET SIZE
        STA     MEGSAV

SKIPVF:
        CALL    MSGF    ;GET READ VERIFY
        .BYTE   CR,LF
        .ASCIS  \Do a read-verify during format (Y,N) \
        LXI     H,VEROK
        CALL    GETOK   ;GET SIZE
        STA     VERFON

        RET

;OLD CODE TO KEEP SECTOR SIZE AT 512 BYTES MAX

..FTV:
        CALL    MSGF
        .BYTE   CR,LF
        .ASCII  \sector size of  128 (1) , 256 (2), \
        .ASCIS  \or 512 (3) bytes :\
        LXI     H,LEOK
        CALL    GETOK
        STA     LESAV
        CPI     '4'
        RC              ;O.K.
        MVI     A,'3'
        STA     LESAV
        RET

;***************************************************
; TELL THE USER THE OPTIONS HE SELECTED.
;***************************************************


TELL:	CALL	MSGF
	.BYTE	CLEAR,CR,LF,CR,LF
	.ASCII	\                               Selected Options: \
	.BYTE	CR,LF,LF
	.ASCIS	\                  \
	LDA	TRSAV	;PRINT NUMBER TRACKS TO FORMAT
	CPI	'A'
	JRNZ	..TRSO
	CALL	MSGF
	.ASCIS	\all\
	JMPR	..TR
..TRSO:	CALL	MSGF
	.ASCIS	\only system\
..TR:	CALL	MSGF
	.ASCIS	\ tracks will be formatted.\

	CALL	MSGF
	.BYTE	CR,LF
	.ASCIS	\                  \
	LDA	SISAV	;PRINT 5 INCH OR 8 INCH SIZE
	CPI	'5'
	JRNZ	..SI8
	CALL	MSGF
	.ASCIS	\5\
	JMPR	..SI
..SI8:	CALL	MSGF
	.ASCIS	\8\
..SI:	CALL	MSGF
	.ASCIS	\ inch disk. \

	LDA	SDSAV	;PRINT SINGLE, DOUBLE SIDED
	CPI	'S'
	JRNZ	..SDD
	CALL	MSGF
	.ASCIS	\single sided.\
	JMPR	..SD
..SDD:	CALL	MSGF
	.ASCIS	\double sided.\

..SD:	LDA	NESAV	;PRINT IF EXTENDED TRACKS
	CPI	'E'
	JRNZ	..NE			
	CALL	MSGF
	.ASCIS	\ extended number of tracks.\

..NE:	CALL	MSGF
	.BYTE	CR,LF
	.ASCIS	\                  \
	LDA	DESAV	;PRINT DENSITY
	CPI	'S'
	JRNZ	..DED
	CALL	MSGF
	.ASCIS	\single\
	JMPR	..DE
..DED:	CALL	MSGF
	.ASCIS	\double\
..DE:	CALL	MSGF
	.ASCIS	\ density. \

	LDA	LESAV	;PRINT SECTOR LENGTH
	CPI	'1'
	JRNZ	..LE2
	CALL	MSGF
	.ASCIS	\128\
	JMPR	..LE
..LE2:	CPI	'2'
	JRNZ	..LE3
	CALL	MSGF
	.ASCIS	\256\
	JMPR	..LE
..LE3:	CPI	'3'
	JRNZ	..LE4	
	CALL	MSGF
	.ASCIS	\512\
	JMPR	..LE
..LE4:
	CALL	MSGF
	.ASCIS	\1024\
..LE:   CALL    MSGF
        .ASCIS  \ byte sectors.\
	LDA	LESAV
	CPI	'4'
	JNZ	SEEVER
	LDA	DESAV
	CPI	'S'
	JZ	SEEVER

        CALL    MSGF
        .BYTE   CR,LF
        .ASCIS  \                  \
        LDA     MEGSAV
        CPI     '1'
        JZ      IS13M
        CPI     '2'
        JZ      IS15M
        CALL    MSGF
        .ASCIS  \1.66 mb = 11, 1K sectors, for 3.5" HD only.\
        JMP     SEEVER
IS13M:
        CALL    MSGF
        .ASCIS  \1.3 mb = 9, 1K sectors, for 3.5" & 5.25" HD or 8" drives.\
        JMP     SEEVER
IS15M:
        CALL    MSGF
        .ASCIS  \1.56 mb = 10, 1K sectors, for 3.5" HD only.\
SEEVER:
	LDA	VERFON
	CPI	'N'
	JZ	NOTVER

	CALL	MSGF
	.BYTE	CR,LF
	.ASCIS	\                  Read-after-write verification.\
        RET
NOTVER:
	CALL	MSGF
	.BYTE	CR,LF
	.ASCIS	\                  No read-after-write verification. \
	RET

;*******************************************************
; LOCATE THE DATA TABLE NEEDED FOR FORMATTING THE TRACK
; AND MOVE IT TO ALLOW EASIER TO ACCESS THE FIELDS IN
; THE TABLE.
;*******************************************************

LTABLE:
        LDA     LESAV
        CPI     '4'
        JNZ     NOT1K
        LDA     MEGSAV
        CPI     '1'
        JZ      SPT09
        CPI     '2'
        JZ      SPT10
        LXI     H,TB11S
        LXI     D,TB8D4
        LXI     B,LEN11S
        LDIR
        JMP     NOT1K
SPT09:
        LXI     H,TB09S
        LXI     D,TB8D4
        LXI     B,LEN09S
        LDIR
        JMP     NOT1K
SPT10:
        LXI     H,TB10S
        LXI     D,TB8D4
        LXI     B,LEN10S
        LDIR
NOT1K:

; LTABLE USED TO START HERE

	LXI	H,TB	;BEGINNING OF TABLES
	LXI	X,CREATE ;DESIRED ENTRY
	
..LOOP:	PUSH	H	;PLACE NEXT ENTRY IN INDEX REG
	POP	Y

	MOV	A,0(Y)	;GET FIRST CHARACTER
	ORA	A	;END OF TABLE
	JRNZ	..MORE	;NO

	CALL	MSGF
	.BYTE	CR,LF,BELL
	.ASCIS	\this format not yet available.\
	JMP	GOBAK	;QUIT

..MORE:	MOV	C,3(Y)	;GET ENTRY LENGTH
	MVI	B,0
	
	CMP	0(X)	;MATCH FIRST CHAR
	JRNZ	..NOPE
	MOV	A,1(Y)	;MATCH NEXT CHAR
	CMP	1(X)
	JRNZ	..NOPE
	MOV	A,2(Y)	;MATCH LAST CHAR
	CMP	2(X)
	JRZ	..YUP	;GOT IT

..NOPE:	DAD	B	;NO MATCH, TRY NEXT ENTRY
	JMPR	..LOOP

..YUP:	LXI	D,DTABLE ;GET DESTINATION ADDR
	LDIR		;MOVE DATA INTO FIXED TABLE

;WILL WE OVER-WRITE BDOS? BETTER CHECK
;GET NUMBER OF SECTORS, AND ADD 50% FOR
;INTER-RECORD OVERHEAD AND TRAILING BYTES

	LDA	RPTCNT	;GET NUMER OF SECTORS
	STC
	CMC
	RAR		;#/2, 50% OVERHEAD IS TYPICAL
	STC
	CMC
	RAR		;#/4, FOR 25% OVERHEAD

	LXI	H,RPTCNT
	ADD	M
	MOV	B,A	;SAVE FOR LATER CALCULATION
	LXI	D,1024	;COULD BE 1024 BYTE SECTOR
	LDA	LENV	;GET ACTUAL SECTOR LENGTH FLAG
	STA	SECSZ
	CPI	0
	JZ	LEN128
	CPI	1
	JZ	LEN256
	CPI	2
	JZ	LEN512
	JMP	DOBSIZ	;GO CALCULATE BUFFER SIZE
LEN128:
	LXI	D,128
	JMP	DOBSIZ
LEN256:
	LXI	D,256
	JMP	DOBSIZ
LEN512:
	LXI	D,512
DOBSIZ:
	LXI	H,TBEGIN	;WHERE TRACK IMAGE WILL GO
SIZUP:
	DAD	D
	DCR	B
	JNZ	SIZUP
	SHLD	SECCOM
	MOV	C,H		;SAVE THE PAGE VALUE
	LDA	BDOS+2		;GET BDOS PAGE
	STA	BDSIZ
	STC
	CMC
	CMP	C
	PUSH	PSW
	POP	H
	SHLD	PSWSAV
	JC	ISOUCH
	JZ	ISOUCH
	RET

ISOUCH:
	CALL	MSGF
	.BYTE	CR,LF,BELL,LF,BELL
	.ASCII	\                                ! ! WARNING ! !\
	.BYTE	CR,LF,LF
	.ASCII	\                    This format image will overwrite BDOS\
	.BYTE	CR,LF,LF
	.ASCIS	\     Press any key to return to Menu and try a smaller format, or Quit\

	CALL	CI	;GET ANY KEY

	JMP	GOBAK	;QUIT

;	RET

;******************************************************
; CREATE A PROTOTYPE TRACK IMAGE IN MEMORY. THIS IMAGE,
; SUITABLY UPDATED WITH THE CORRECT TRACK NUMBER AND
; SIDE NUMBER, IS THE EXACT SEQUENCE OF BYTES WHICH
; WILL BE SENT TO THE WDC 179X CHIP WHEN FORMATTING A
; TRACK. CREATE THE TABLE TRTAB TO ALLOW CHANGING THE
; HEAD NUMBER AND TRACK NUMBER BYTES WITHOUT REDOING
; THE ENTIRE MEMORY IMAGE.
;******************************************************

CTRAKK:	LXI	B,TRLEN-1 ;CLEAR TRACK ADDRESS TABLE
	LXI	D,TRTAB+1
	LXI	H,TRTAB
	MVI	M,0
	LDIR

	LXI	X,TRTAB	;POINT TO TRACK ADDRESS TABLE
	LXI	H,TBEGIN ;START GENERATING TRACK HERE
	.IFE	MLIST-TRUE,[.XALL
][	.SALL
]
	RB	[G4A]	;GAP 4 A
	RB	[INSYA]	;INDEX SYNC PATTERNS
	RB	[INSYB]
	RB	[INAM]	;INDEX AM
	RB	[G1]	;GAP 1

	LDA	RPTCNT	;GET REPEAT COUNT
	STA	REPEAT	;SAVE IT
	MVI	A,1	;INITIALIZE SECTOR COUNT
	STA	SECTOR	

..SECT:	RB	[IDSYA]	;ID SYNC PATTERNS
	RB	[IDSYB]
	MVI	M,0FEH	;ID AM
	INX	H

	MOV	0(X),L	;SAVE TRACK, SIDE ADDRESS
	INX	X
	MOV	0(X),H
	INX	X

	MVI	M,0H	;GENERATE TRACK NUMBER
	INX	H
	MVI	M,0H	;GENERATE SIDE NUMBER
	INX	H		
	LDA	SECTOR	;GENERATE PROPER SECTOR
	MOV	M,A
	INX	H
	INR	A	;UPDATE SECTOR COUNT
	STA	SECTOR

	RB	[LEN]	;SECTOR LENGTH BYTE
	MVI	M,0F7H	;ID CRC
	INX	H
	RB	[G2]	;GAP 2
	RB	[DASYA]	;DATA SYNC PATTERNS
	RB	[DASYB]
	MVI	M,0FBH	;DATA AM
	INX	H
	RW	[DACNT]
	MVI	M,0F7H	;DATA CRC
	INX	H
	RB	[G3]	;GAP 3

	LDA	REPEAT	;TEST IF ALL SECTORS DONE
	DCR	A
	STA	REPEAT
	JNZ	..SECT	;NO, DO NEXT SECTOR

	RW	[G4B]	;GAP 4 B
	.XALL
	INX	H
	SHLD	FINAL	;SAVE FIRST FREE ADDRESS
	LDA	BDOS+2	;GET BDOS PAGE
	STA	CHKFLG
	STC
	CMC
	CMP	H	;TEST WITH TABLE
	JNC	CHEKBF
	HLT		;OUCH. WE KILLED BDOS

CHEKBF:
	LDA	RPTCNT	;GET NUMBER OF SECTORS
	MOV	B,A
	LDA	LESAV	;GET SECTOR SIZE
	LXI	D,128
	CPI	'1'
	JZ	MUL00
	LXI	D,256
	CPI	'2'
	JZ	MUL00
	LXI	D,512
	CPI	'3'
	JZ	MUL00
	LXI	D,1024
	
MUL00:
	LXI	H,0
MUL01:
	DAD	D
	DCR	B
	JNZ	MUL01
	PUSH	H
	POP	D
	LHLD	FINAL
	DAD	D
	SHLD	VERADD
	STC
	CMC
	LDA	BDOS+2	;GET BDOS PAGE
	CMP	H	;COMPARE WITH LAST READ BUFFER LOC
	RNC		;WE HAVE ENOUGH RAM
	MVI	A,'N'
	STA	VERFON	;DO NOT DO READ VERIFICATION

	RET		;ALL DONE

;****************************************************
; UPDATE THE MEMORY IMAGE OF THE TRACK BY CHANGING
; THE HEAD NUMBER AND TRACK NUMBER BYTES. USE TRTAB,
; CREATED BY CTRAKK, TO GET THE LOCATION OF THESE
; BYTES.
;****************************************************

UTRACK:	LXI	H,TRTAB	;GET TRACK TABLE ADDRESS

..LOOP:	MOV	E,M	;GET ADDRESS OF NEXT CHANGE
	INX	H
	MOV	D,M
	INX	H
	MOV	A,E	;ALL DONE
	ORA	D
	RZ		;YES
	XCHG
	MOV	M,C	;CHANGE TRACK NUMBER
	INX	H
	MOV	M,B	;CHANGE SIDE
	XCHG
	JMPR	..LOOP

;****************************************************
;        STEP THE DISK DRIVE IN 1 TRACK.
;****************************************************

STEPIN:
        LXI     D,TRFMES
        MVI     C,PRINT
        CALL    BDOS
        LDA     TRAKK
        MOV     C,A
        CALL    DOHEX

	MVI	A,WSTIN	;ISSUE STEP IN COMMAND
	OUT	WCMD
SDN:	
	CALL	FDONEF	;WAIT FOR FDC DONE
	ANI	WSSTIN	;TEST STEP IN STATUS BITS
	RZ		;SUCCESSFUL
	CALL	MSGF	;UNSUCCESSFUL, PRINT MESSAGE
	.BYTE	LF,LF,CR,LF,BELL
	.ASCIS	\                                 step in error\
	JMP	ASKFOR

;***************************************************
;            HOME THE DISK DRIVE.
;***************************************************

HOMEF:	MVI	A,WHOMEF	;ISSUE HOME COMMAND
	OUT	WCMD
	CALL	FDONEF	;WAIT FOR 179X DONE
	XRI	1<WBTRK0 ;FLIP TRACK 0 BIT
	ANI	WSHOME	;TEST HOME STATUS BITS
	RZ		;SUCCESSFUL
	CALL	MSGF	;UNSUCCESSFUL, PRINT MESSAGE
	.BYTE	LF,LF,CR,LF,BELL
	.ASCIS	\                                  home error\
	JMP	ASKFOR

;***************************************************
; SELECT DESIRED DISK DRIVE. CREATE A VALID Z3S
; CONTROL BYTE.
;***************************************************

SELECT:

	LDA	DRIVE
	MOV	C,A	;DESIRED DISK NUMBER
	MVI	B,0
	LXI	H,SELTAB ;POINT TO SELECT XLATE TABLE
	DAD	B	;INDEX INTO IT
	MOV	A,M	;GET APPROPRIATE BYTE

	LXI	H,DPROTO ;POINT TO Z3S CTRL PROTOTYPE
	ORA	M	;OR IN CONTROL WITH SELECT
	STA	Z3SBYT	;SAVE MERGED Z3S CONTROL BYTE

	OUT	DCMD	;SELECT APPROPRIATE DISK DRIVE
	RET

;******************************************************
; WRITE OUT THE MEMORY IMAGE OF THE TRACK TO THE DISK.
; THIS MEMORY IMAGE IS THE EXACT SEQUENCE OF BYTES
; WHICH MUST BE SENT TO THE 179X CHIP TO CAUSE IT TO
; CORRECTLY FORMAT THE CURRENT TRACK.
;******************************************************

FTRACK:
	LXI	H,TBEGIN ;POINT TO BYTES TO WRITE
        LXI     B,0<8+WDATA ;SET UP COUNT AND PORT
;HERE WE TAKE MAX POSSIBLE BYTES
;AND DIVIDE BY 256
;       MVI     E,10417/256+3   ;OLD VALUE

        MVI     E,14400/256+3   ;SUPPORT UP TO 11 1024 BYTE SECTORS
	LDA	Z3SFLG
        LDA     Z3SBYT  ;ACTIVATE HARDWARE DATA WAIT
        XRI     1<DBWAIT
DCMD02:
        OUT     DCMD
        MVI     A,WWRTRK ;ISSUE WRITE TRACK COMMAND
        OUT     WCMD

..LOOP:
	OUTIR		;WRITE OUT EACH BYTE
	DCR	E
	JNZ	..LOOP

	LDA	Z3SBYT	;DEACTIVATE HARDWARE DATA WAIT
	OUT	DCMD

TKDN:
	CALL	FDONEF	;WAIT FOR FDC DONE
	ANI	WSWRTR	;SUCCESSFUL
	JNZ	WBAD	;NOPE
	MVI	B,0
	DJNZ	.	;WAIT FOR TRIM ERASE TO END
	LDA	VERFON
	CPI	'N'
	RZ

        LXI     D,TRVMES
        MVI     C,PRINT
        CALL    BDOS
        LDA     TRAKK
        MOV     C,A
        CALL    DOHEX

;***********************************************************
;NOW READ-VERIFY THE FORMATTED TRACK.
;WE ISSUE A MULTI-SECTOR OPERATION TO SPEED THE TESTING,
;BUT WE HAVE TO STOP THE OPERATION AFTER THE MAXIMUM NUMBER
;OF PHYSICAL SECTORS FOR THIS TRACK HAVE BEEN READ.
;THEN WE HAVE TO LOOK AT ANY ERRORS, AND DETERMINE IF
;ANY BAD STATUS IS JUST AN END-OF-TRACK ERROR, OR AN
;ACTUAL PHYSICAL PROBLEM.
;THIS ROUTINE COULD BE MORE THOROUGH, BUT IT WORKED O.K.
;IN ALL TESTS WITH DAMAGED MEDIA.
;THIS IS JUST HOW THE WD179X FDC CHIP WORKS FOR MULTI-R/W
;OPERATIONS.
;***********************************************************

;FIRST RESET THE ERROR INFORMATION BUFFER, TO BE SURE
;WE SEE NO FALSE VALUES FROM A PREVIOUS OPERATION

	LXI	H,0FFFFH
	SHLD	FAILED
	SHLD	FAILED+2
	SHLD	FAILED+4

;UP TO 11K BYTES MUST BE READ IN TO THE READ BUFFER LOCATION

	LHLD	FINAL	;GET FREE BUFFER LOCATION
	LDA	RPTCNT	;GET PHYSICAL SECTORS
	STA	FAILED+4	;SAVE FOR LATER FAILURE DUMPS
	MOV	E,A	;E REG. WILL COUNT US THROUGH READ LOOP
	MVI	C,WDATA	;FDC DATA I/O PORT

; WE HAVE TO ALLOW FOR 128, 256, 512 & 1024 BYTE SECTORS

	MVI	B,128
	LDA	LESAV
	CPI	'1'
	JZ	IS128

;IT IS NOT A 128 BYTE SECTOR, SO THE BYTE COUNTER IS SET TO 0 NOW

	MVI	B,0	;BASIC COUNTER
	CPI	'2'	;SEE IF 256 BYTE SECTOR
	JZ	IS256	;IF SO BRANCH
	CPI	'3'	;SEE IF 512 BYTE SECTOR
	JZ	IS512	;IF SO BRANCH

; 1024 BYTE SECTORS HERE

IS1024:
	CALL	SETRED	;SET THE FDC FOR A READ
IS102:
	INIR
	INIR
	INIR
	INIR
	DCR	E	;UPDATE PHYSICAL SECTOR COUNT
	JNZ	IS102
	JMP	ENDRED	;ALL DONE, GO CHECK IT

; 512 BYTE SECTORS HERE

IS512:		
	CALL	SETRED
IS51:
	INIR
	INIR
	DCR	E
	JNZ	IS51
	JMP	ENDRED

; 256 BYTE SECTORS HERE

IS256:
	CALL	SETRED
IS25:
	INIR
	DCR	E
	JNZ	IS25
	JMP	ENDRED

; 128 BYTE SECTORS HERE

IS128:
	CALL	SETRED
IS12:
	INIR
	MVI	B,128
	DCR	E
	JNZ	IS12

; NOW TEST FOR RESULTS

ENDRED:
	LDA	Z3SBYT	;DEACTIVATE HARDWARE DATA WAIT
	OUT	DCMD
	IN	WSTAT	;SAVE STATUS BEFORE FORCED-INTERRUPT
	STA	RSTAT
	MVI	A,0D0H	;FORCED-INTERRUPT = STOP OPERATION NOW
	OUT	WCMD
	LDA	RSTAT	;CHECK PREVIOUS STATUS
	ANI	10011100B	;MASK FOR POSSIBLE ERRORS

	CNZ	PRBAD	;MAY BE BAD, MAY BE ACTUALLY O.K., GO CHECK
	JC	RBAD	;IT WAS A REAL ERROR

;WAS IT MORE THAN A R.N.F. ?

	LDA	RSTAT
	ANI	10001100B	;IGNORE R.N.F.
	JNZ	RBAD		;IT LOOKS WORSE

; ELSE GET FINAL STATUS, WITH NO BUSY OPERATION, FOR SURE	

	CALL	FDONEF		;NOW GET FINISHING STATUS
	ANI	10011100B
	RZ			;NOTHING BAD HAPPENED
	STA	FAILED		;LOOKS BAD
	IN	WSECT		;GET SECTOR
	MOV	B,A		;PUT IN B REG
	LDA	RPTCNT		;GET MAXIMUM PHYSICAL SECTOR
	CMP	B		;CHECK IT
	JNC	RBAD		;THAT LOOKS BAD ON NO-CY
	XRA	A		;GOOD ENOUGH!
	RET

; THE READ FAILURE MAY BE O.K.
; IT WILL ALWAYS GIVE A R.N.F. IN MULTI-SECTOR READS
; SO WE COMPARE THE FAILED SECTOR WITH THE HIGHEST
; SECTOR VALUE FOR THIS TRACK
 
PRBAD:
	STA	FAILED		;SAVE FAILED STATUS
	IN	WTRACK		;GET TRACK #
	STA	FAILED+2	;SAVE IT
	LDA	RVSIDE		;GET SIDE VALUE 0 = LOWER, 1 = UPPER
	STA	FAILED+3	;SAVE IT
	IN	WSECT		;GET FAILED SECTOR
	STA	FAILED+1	;SAVE IT
	PUSH	H		;SAVE DMA PLACE, COULD USE IT SOME DAY :)
	LXI	H,RPTCNT	;POINT TO PHYSICAL SECTORS PER TRACK
	CMP	M		;COMPARE WITH FAILED SECTOR
	POP	H		;RECOVER DMA
	RET			;GO BACK WITH FLAGS SET

; PREPARE THE FDC FOR MULTI-SECTOR READS
; BE SURE TO SEND A PROPER READ COMMAND FOR READING
; LOWER AND UPPER TRACKS.
	
SETRED:
	MVI	A,1	;SECTOR 1
	OUT	WSECT
        LDA     Z3SBYT  ;ACTIVATE HARDWARE DATA WAIT
        XRI     1<DBWAIT
DCMD03:
        OUT     DCMD
	LDA	RVSIDE	;SEE IF SIDE 0 OR 1
	CPI	0
	JNZ	ISAONE
        MVI     A,98H ;ISSUE MULTI-SECTOR READ COMMAND, LOWER TRACK
        OUT     WCMD
	RET
ISAONE:
	MVI	A,9AH ;READ UPPER TRACK COMMAND, MULTI-SECTOR
	OUT	WCMD
	RET

WBAD:	CALL	MSGF
	.BYTE	CR,LF,LF,LF,BELL
	.ASCIS	\                               write track error\
	JMP	ASKFOR

RBAD:	CALL	MSGF
	.BYTE	CR,LF,LF,LF,BELL
	.ASCIS	\                               read verify error\
	JMP	ASKFOR

RVSIDE:	.BYTE	0

;***************************************************
; WAIT FOR 179X DONE. RETURN STATUS WHEN DONE.
;***************************************************

FDONEF:
	MVI	A,40	;WAIT FOR VALID STATUS
..WAIT:	DCR	A
	JRNZ	..WAIT

..DONE:

	IN	WSTAT	;GET STATUS
	BIT	WBBUSY,A ;BUSY
	JRNZ	..DONE	;YES, KEEP WAITING

	RET		;RETURN STATUS

;***************************************************
; OUTPUT AN INLINE MESSAGE TO THE CONSOLE.
;***************************************************

MSGF:	XTHL		;GET MESSAGE ADDRESS

..LOOP:	MOV	C,M	;GET NEXT CHAR OF MESSAGE
	INX	H
	CALL	CO	;OUTPUT THE CHAR
	ORA	A	;LAST CHARACTER
	JP	..LOOP	;NO

	XTHL		;RESTORE NEW RETURN ADDRESS
	RET

;****************************************************
; GET A CHARACTER FROM THE CONSOLE. IF THE CHARACTER
; IS UNACCEPTABLE, BEEP AND WAIT FOR ANOTHER. RETURN
; TO CP/M IF ^C IS ENTERED. (BDOS DOES RETURN ON ^C)
;****************************************************
; THE CCIR Z80 INSTRUCTION CHECKS ALL ACCEPTABLE
; CHARACTERS FROM THE TABLE POINTED TO BY HL
; A BAD INPUT CAUSES A BELL, PLUS A BACKSPACE
; BLANK-OVER AND BACKSPACE TO ERASE THE WRONG
; INPUT ON CONSOLE, THEN THE ROUTINE IS RE-ENTERED

GETOK:	
..RTRY:	PUSH	H	;SAVE OK TABLE ADDR
	MOV	C,M	;GET COUNT
	INX	H
	MVI	B,0
	CALL	CI	;GET A CHAR
	CPI	'Q'	;IS IT QUIT 
	JZ	GOBAK	;YES, GO BACK TO CP/M
	CCIR		;IS IT OKAY
	POP	H
	RZ		;YES, RETURN IT

	MVI	C,BELL	;NO, RING BELL
	CALL	CO
	MVI	C,8	;BACK SPACE
	CALL	CO
	MVI	C,' '
	CALL	CO
	MVI	C,8
	CALL	CO
	JMP	..RTRY	;KEEP TRYING

;***************************************************
;       GET A CHARACTER FROM THE CONSOLE.
;***************************************************

CI:	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,1	;CONSOLE INPUT
	CALL	BDOS	;GET THE CHARACTER
	POP	H
	POP	D
	POP	B
	RET

;**************************************************
;      WRITE A CHARACTER TO THE CONSOLE.
;**************************************************

CO:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	A,C
	ANI	7FH
	MOV	E,A	;MOVE CHARACTER TO E
	MVI	C,2	;CONSOLE OUTPUT
	CALL	BDOS	;OUTPUT THE CHARACTER
	POP	H
	POP	D
	POP	B
	MOV	A,C	;FIX UP ACC
	RET

;***************************************************
;*    SAVE A MEMORY IMAGE OF NEW FORMAT OPTIONS
;***************************************************

SAVEIT:
	GCON	==	1	;GET CONSOLE
	WCON	==	2	;OUTPUT CONSOLE
	PRINTS	==	9	;PRINT STRING
	GBUF	==	10	;GET CONSOLE BUFFER
	OPENF	==	15	;OPEN FILE
	CLOSEF	==	16	;CLOSE FILE
	MAKE	==	22	;MAKE FILE
	SEARCH	==	17	;SEARCH FOR MATCH
	READF	==	20	;READ FILE
	WRITEF	==	21	;WRITE FILE
	DELETE	==	19	;DELETE FILE
	DMAF	==	26	;SET DMA ADDRESS

;*********************************************************
;*  INITIALIZE POSSIBLE FCB NAME AND RECORD WRITE COUNT	
;*********************************************************

	LXI	SP,100H		;PUT HERE
	XRA	A		;CLEAR ACC
	STA	IDMALL		;SET DMA BUFFER LOW
	STA	RECS		;SET RECORDS TO XFER = 0
	INR	A		;ACC. = 1
	STA	IDMALL+1	;SET INITIAL DMA HIGH TO 01H

;**********************************************************
;          CLEAR FCB IN CASE OF FILE RE-NAME
;**********************************************************

CLEARF:
	LXI	H,FCBG+1	;POINT TO NAME
	MVI	B,8		;8 POSSIBLE CHARS
	MVI	A,' '		;A SPACE
PAD:	MOV	M,A		;FILL BYTE
	INX	H
	DCR	B
	JRNZ	PAD
	XRA	A		;PREPARE TO ZERO FCB FIELDS
	LXI	H,FCBG+13	;POINT TO CONTROL FIELDS
	MVI	B,36-13		;GET LENGTH TO CLEAR
PAD1:	MOV	M,A		;FILL BYTE
	INX	H
	DCR	B
	JRNZ	PAD1

SAVSYS:
GO0:	MVI	C,PRINTS	;TELL USER WE WANT FILE NAME INFO
	LXI	D,MESS5		
	CALL	BDOS
SINP:	LXI	D,INBUFF	;POINT TO NAME BUFFER
	MVI	C,GBUF		;LOAD READ BUFFER FUNCTION
	CALL	BDOS

	
UPCASE:
	LXI	H,INBUFF+2	;POINT TO NAME IN BUFFER
	MVI	B,8		;GET 8 CHARACTERS
NXTCHR:	MOV	A,M
	CPI	20H		;SEE IF SPACE
	JRZ	NOUP		;IF SO LEAVE AS IS
	CPI	30H		;TEST INVALID CHARACTER
	JRC	GO0		;WE DON'T WANT THIS NAME
	CPI	40H
	JRC	NOUP
	ANI	0DFH		;MAKE UPPER CASE
NOUP:	MOV	M,A
	INX	H
	DCR	B
	JRNZ	NXTCHR

;************************************************************
;*         PUT NAME IN FCB & SAVE THE IMAGE NEXT
;************************************************************

FILFCB:
	LXI	H,INBUFF+2	;POINT TO SAVE NAME
	LXI	D,FCBG+1	;POINT TO FCB NAME LOC
	LDA	INBUFF+1	;GET NUMBER OF CHARACTERS
	CPI	0		;TEST IF NO NAME
	JZ	SAVSYS		;RETRY
	CPI	9		;TEST MAX LENGTH
	JRC	FILOK
	MVI	A,8
FILOK:	LXI	B,0		;ZERO BC
	MOV	C,A		;PUT CHAR. COUNT IN C
	LDIR			;MOVE NAME INTO FCB

;**********************************************************
;*            TEST TO SEE IF FILE EXISTS	
;**********************************************************

DMATCH:

	MVI	C,DMAF		;SET UP DMA AREA
	LXI	D,TBEGIN	;POINT DMA BUFFER
	CALL	BDOS
	LXI	D,FCBG
	MVI	C,SEARCH	;SEARCH FIRST FUNCTION
	CALL	BDOS
	CPI	0FFH
	JRZ	MAKE1
	LXI	D,FMATCH	;POINT TO FILE MATCH MESS.
	MVI	C,PRINTS	;SEE IF USER WANTS TO KILL
	CALL	BDOS
	MVI	C,GCON		;NOW GET ANSWER
	CALL	BDOS
	CPI	'A'		;SEE IF USER WANTS TO RE-NAME
	JRNZ	KILF		;IF NOT GO KILL CURRENT FILE
	CALL	CLEARF		;ELSE CLEAR FCB & NAME BUFF
	JMP	GO0		;AND GET ANOTHER NAME

KILF:	MVI	C,DELETE	;DELETE FUNCTION
	LXI	D,FCBG
	CALL	BDOS

MAKE1:	MVI	C,MAKE		;NOW MAKE FILE IN FCB NAME FIELD
	LXI	D,FCBG
	CALL	BDOS		;DO IT
	CPI	0FFH		;SEE IF MAKE FAILED
	JZ	FAIL		;IF SO SHOW FAILURE

;*************************************************************
;*       NOW WRITE THE FILE TO DISK 	
;*************************************************************

	LDED	IDMALL		;POINT TO IMAGE
	MVI	C,DMAF		;SET DMA FUNCTION
	CALL	BDOS
WFIL:	MVI	C,WRITEF	;WRITE RECORD FUNCTION
	LXI	D,FCBG		;POINT FCB
	CALL	BDOS
	CPI	0
	JRNZ	FAIL1		;IF FAILURE SHOW IT
	LDA	RECS		;GET RECORDS
	CPI	MRECS		;TEST FOR END
	JZ	CLOSE1		;CLOSE OPERATION
	INR	A		;ELSE INC. RECORD COUNT
	STA	RECS		;AND SAVE IT
	LHLD	IDMALL		;GET LAST DMA ADD.
	LXI	D,128		;ADD A RECORD LENGTH
	DAD	D		;UPDATE POINTER
	SHLD	IDMALL		;SAVE UPDATED DMA
	XCHG			;PUT IN DE
	MVI	C,DMAF		;DMA FUNCTION
	CALL	BDOS
	JMPR	WFIL		;DO NEXT RECORD
CLOSE1:	MVI	C,CLOSEF	;CLOSE FUNCTION
	LXI	D,FCBG		;THIS FCB
	CALL	BDOS		;DO IT
	CPI	0FFH
	JRZ	FAIL2		;SHOW IF FAILED
CLOSE2:
	LXI	D,MESS3		;SHOW PROGRAM CREATED O.K.
	MVI	C,PRINTS
	CALL	BDOS
	JMP	0
	
FAIL:	LXI	D,MESSF
	MVI	C,PRINTS
	CALL	BDOS
	JMP	0
FAIL1:	LXI	D,MESSW
	MVI	C,PRINTS
	CALL	BDOS
	JMP	0
FAIL2:	LXI	D,MESSC
	MVI	C,PRINTS
	CALL	BDOS
	JMP	0


MESS5:	.BYTE	CLEAR,LF,CR
	.ASCII	\              Enter name for this format program, 8 charcter max\
	.BYTE	CR,LF,LF
	.ASCII	\                                    $\


FMATCH:	.BYTE	LF,CR,CR,LF
	.ASCII	\                   A program with that name already exists,\
 	.BYTE	LF,CR
	.ASCII	\                 Enter 'A' for another name or <CR> to use this name $\

MESS3:
	.BYTE	CR,LF,LF,LF,CR
	.ASCII	\                                Program created $\


;*****************************************************
;           FILE I/O ERROR MESSAGES
;*****************************************************

MESSF:	.BYTE	CR,LF,LF
	.ASCII	\                              program make failed$\

MESSW:	.BYTE	CR,LF,LF
	.ASCII	\                              program write failed$\

MESSC:	.BYTE	CR,LF,LF
	.ASCII	\                              program close failed$\

;***************************************************
;         PROGRAM STORAGE ARE FOLLOWS
;***************************************************

IDMALL:
	.BYTE	0
	.BYTE	1


;RECORDS INITIALIZED TO 0

RECS:
	.BYTE	0		;RECORDS TO WRITE ON SAVE


INBUFF:	.BYTE	16,20H,20H,20H,20H,20H,20H,20H
	.BYTE	20H,20H,20H,20H,20H,20H,20H,20H,20H,20H

;FCB LOCATION

FCBG:
	.BYTE	0
	.BYTE	' ',' ',' ',' ',' ',' ',' ',' '
	.ASCII	\COM\
	.BYTE	0,0,0,0,0,0,0,0,0,0,0,0
	.BYTE	0,0,0,0,0,0,0,0,0,0,0,0

;****************************************************
; TRANSLATION TABLE TO CONVERT A BINARY DRIVE NUMBER
; INTO APPROPRIATE DRIVE SELECT BITS.
;****************************************************

SELTAB:	.BYTE	0EH,0DH,0BH,07H

; ACCEPTABLE CHARACTER TABLE.

TROK:	.BYTE	3,'A','S','Q'	;ALL OR SYSTEM TRACKS
SIOK:	.BYTE	3,'5','8','Q'	;5" OR 8"
DEOK:	.BYTE	4,'S','D','T','Q'	;SINGLE/DOUBLE DENSITY OR 9 SECTOR SYSTEM
LEOK:	.BYTE	5,'1','2'	;SECTOR SIZE
	.BYTE	'3','4','Q'
LEOK5:	.BYTE	4,'1','2','3','Q'
NEOK:	.BYTE	3,'S','E','Q'	;STANDARD OR EXTENDED ON SPECIAL 5"
SDOK:	.BYTE	3,'S','D','Q'	;SINGLE/DOUBLE DENSITY FOR SPECIAL 5"
DROK:	.BYTE	7,'A','B','C','D'	;FINAL OPTIONS
	.BYTE	'X','Q','S'
CCOK:	.BYTE	2,'Q','R'	;'Q' OR 'R' (y/n)
SYSOK:	.BYTE	3,'C','M','Q'	;SEE IF FOR MP/M OR CP/M
FOROK:	.BYTE	2,'F','Q'
QUITOK:	.BYTE	2,'R','F'
STDSYS:	.BYTE	3,'S','V','Q'
MEGSOK: .BYTE   4,'1','2','3','Q'   ;1.3, 1.5 OR 1.6 MBYTES
VEROK:	.BYTE	3,'Y','N','Q'
ASKOK:	.BYTE	3,'R','N','Q'

	.PAGE

;***************************************************
; THE DISK PARAMETER TABLES FOR THE VARIOUS
; DISK SIZES, DENSITIES, AND SECTOR LENGTHS.
;***************************************************

;:::::::::::::::::::::::::::::::::::::::::::::::::::

;***************************************************
;   8" SYSTEM TRACKS OF 9 512 BYTE SECTORS FIRST
;***************************************************


TB:
TB8T5:	.BYTE	'8','T','5'
	.BYTE	LEN8T5
	
D8S001:	.BYTE	DCMD8S
	.BYTE	20,0FFH,6,0H,0,0H,1,0FCH,16,0FFH
	.BYTE	9
	.BYTE	6,0H,0,0H,1,2H,11,0FFH,6,0H,0,0H
	.WORD	512
	.BYTE	0E5H,22,0FFH
	.WORD	311+200
	.BYTE	0FFH


	LEN8T5	==	.-TB8T5


	.PAGE

;8" SINGLE DENSITY, 128 BYTES

TB8S1:	.BYTE	'8','S','1'
	.BYTE	LEN8S1

D8S002:	.BYTE	DCMD8S
	.BYTE	40,0FFH,6,0H,0,0H,1,0FCH,26,0FFH
	.BYTE	26
	.BYTE	6,0H,0,0H,1,0H,11,0FFH,6,0H,0,0H
	.WORD	128
	.BYTE	0E5H,27,0FFH
	.WORD	247+200
	.BYTE	0FFH

	.BYTE	ALE8S1
	.BYTE	DLE8S1
	.BYTE	DDB8S1-TB8S1

ALT8S1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00000011B
	.WORD	2
	.BYTE	2,36,0,26

	.WORD	26
	.BYTE	4,15,1
	.WORD	242
	.WORD	127
	.BYTE	11000000B,0
	.WORD	32
	.WORD	2
ALE8S1	==	.-ALT8S1

DDB8S1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00000001B
	.WORD	2
	.BYTE	2,36,0,26

	.WORD	26
	.BYTE	3,7,0
	.WORD	242
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	2

TRA8S1:	.BYTE	1,7,13,19,25,5,11,17,23,3,9,15,21
	.BYTE	2,8,14,20,26,6,12,18,24,4,10,16,22
DLE8S1	==	.-DDB8S1
LEN8S1	==	.-TB8S1


	.PAGE

;8" SINGLE DENSITY, 256 BYTE SECTORS

TB8S2:	.BYTE	'8','S','2'
	.BYTE	LEN8S2
	
D8S003:	.BYTE	DCMD8S
	.BYTE	40,0FFH,6,0H,0,0H,1,0FCH,26,0FFH
	.BYTE	15
	.BYTE	6,0H,0,0H,1,1H,11,0FFH,6,0H,0,0H
	.WORD	256
	.BYTE	0E5H,42,0FFH
	.WORD	170+200
	.BYTE	0FFH

	.BYTE	ALE8S2
	.BYTE	DLE8S2
	.BYTE	DDB8S2-TB8S2

ALT8S2:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00000011B
	.WORD	2
	.BYTE	2,36,1,30

	.WORD	30
	.BYTE	4,15,0
	.WORD	280
	.WORD	127
	.BYTE	11000000B,0
	.WORD	32
	.WORD	2
ALE8S2	==	.-ALT8S2

DDB8S2:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00000001B
	.WORD	2
	.BYTE	2,36,1,30

	.WORD	30
	.BYTE	4,15,1
	.WORD	139
	.WORD	63
	.BYTE	10000000B,0
	.WORD	16
	.WORD	2

TRA8S2:	.BYTE	1,2,13,14,25,26,7,8,19,20
	.BYTE	3,4,15,16,27,28,9,10,21,22
	.BYTE	5,6,17,18,29,30,11,12,23,24
DLE8S2	==	.-DDB8S2
LEN8S2	==	.-TB8S2


	.PAGE

;8" SINGLE DENSITY, 512 BYTE SECTORS

TB8S3:	.BYTE	'8','S','3'
	.BYTE	LEN8S3
	
D8S004:	.BYTE	DCMD8S
	.BYTE	40,0FFH,6,0H,0,0H,1,0FCH,26,0FFH
	.BYTE	8
	.BYTE	6,0H,0,0H,1,2H,11,0FFH,6,0H,0,0H
	.WORD	512
	.BYTE	0E5H,58,0FFH
	.WORD	311+200
	.BYTE	0FFH

	.BYTE	ALE8S3
	.BYTE	DLE8S3
	.BYTE	DDB8S3-TB8S3

ALT8S3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00000011B
	.WORD	2
	.BYTE	2,36,2,32

	.WORD	32
	.BYTE	4,15,0
	.WORD	299
	.WORD	127
	.BYTE	11000000B,0
	.WORD	32
	.WORD	2
ALE8S3	==	.-ALT8S3

DDB8S3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00000001B
	.WORD	2
	.BYTE	2,36,2,32

	.WORD	32
	.BYTE	4,15,1
	.WORD	149
	.WORD	63
	.BYTE	10000000B,0
	.WORD	16
	.WORD	2

TRA8S3:	.BYTE	1,2,3,4,13,14,15,16,25,26,27,28
	.BYTE	5,6,7,8,17,18,19,20,29,30,31,32
	.BYTE	9,10,11,12,21,22,23,24
DLE8S3	==	.-DDB8S3
LEN8S3	==	.-TB8S3


	.PAGE

;8" SINGLE DENSITY, 1024 BYTE SECTORS

TB8S4:
	.BYTE	'8','S','4'
	.BYTE	LEN8S4

D8S005:	.BYTE	DCMD8S
	.BYTE	40,0FFH,6,0H,0,0H,1,0FCH,16,0FFH
	.BYTE	4
	.BYTE	6,0H,0,0H,1,3H,16,0FFH,6,0H,0,0H
	.WORD	1024
	.BYTE	0E5H,40,0FFH
	.WORD	150+150
	.BYTE	0FFH

	.BYTE	ALE8S4
	.BYTE	DLE8S4
	.BYTE	DDB8S4-TB8S4

ALT8S4:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00000011B
	.WORD	2
	.BYTE	2,36,3,32

	.WORD	32
	.BYTE	4,15,0
	.WORD	297
	.WORD	191	
	.BYTE	11100000B,0
	.WORD	48	
	.WORD	2
ALE8S4	==	.-ALT8S4

DDB8S4:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00000001B
	.WORD	2
	.BYTE	2,36,3,32

	.WORD	32
	.BYTE	4,15,1
	.WORD	148
	.WORD	63
	.BYTE	10000000B,0
	.WORD	16
	.WORD	2

TRA8S4:	.BYTE	1,2,3,4,5,6,7,8
	.BYTE	25,26,27,28,29,30,31,32
	.BYTE	17,18,19,20,21,22,23,24
	.BYTE	09,10,11,12,13,14,15,16

DLE8S4	==	.-DDB8S4
LEN8S4	==	.-TB8S4


	.PAGE

;8" DOUBLE DENSITY, 128 BYTE SECTORS

TB8D1:	.BYTE	'8','D','1'
	.BYTE	LEN8D1

D8D001:	.BYTE	DCMD8D
	.BYTE	80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH
	.BYTE	42
	.BYTE	12,0H,3,0F5H,1,0H,22,04EH,12,0H,3,0F5H
	.WORD	128
	.BYTE	0E5H,46,04EH
	.WORD	359+400
	.BYTE	04EH

	.BYTE	ALE8D1
	.BYTE	DLE8D1
	.BYTE	DDB8D1-TB8D1

ALT8D1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00001011B
	.WORD	2
	.BYTE	2,36,0,42

	.WORD	42
	.BYTE	4,15,0
	.WORD	392
	.WORD	127	
	.BYTE	11100000B,0
	.WORD	32	
	.WORD	2
ALE8D1	==	.-ALT8D1

DDB8D1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00001001B
	.WORD	2
	.BYTE	2,36,0,42

	.WORD	42
	.BYTE	4,15,1
	.WORD	195
	.WORD	127
	.BYTE	11000000B,0
	.WORD	32
	.WORD	2

TRA8D1:	.BYTE	1,10,19,28,37,4,13,22,31,40,7
	.BYTE	16,25,34,2,11,20,29,38,5,14,23
	.BYTE	32,41,8,17,26,35,3,12,21,30,39
	.BYTE	6,15,24,33,42,9,18,27,36
DLE8D1	==	.-DDB8D1
LEN8D1	==	.-TB8D1


	.PAGE

;8" DOUBLE DENSITY, 256 BYTE SECTORS

TB8D2:	.BYTE	'8','D','2'
	.BYTE	LEN8D2

D8D002:	.BYTE	DCMD8D
	.BYTE	80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH
	.BYTE	26
	.BYTE	12,0H,3,0F5H,1,1H,22,04EH,12,0H,3,0F5H
	.WORD	256
	.BYTE	0E5H,54,04EH
	.WORD	598+400
	.BYTE	04EH

	.BYTE	ALE8D2
	.BYTE	DLE8D2
	.BYTE	DDB8D2-TB8D2

ALT8D2:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00001011B
	.WORD	2
	.BYTE	2,36,1,52

	.WORD	52
	.BYTE	4,15,0
	.WORD	486
	.WORD	191	
	.BYTE	11100000B,0
	.WORD	48	
	.WORD	2
ALE8D2	==	.-ALT8D2

DDB8D2:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00001001B
	.WORD	2
	.BYTE	2,36,1,52

	.WORD	52
	.BYTE	4,15,1
	.WORD	242
	.WORD	127
	.BYTE	11000000B,0
	.WORD	32
	.WORD	2

TRA8D2:	.BYTE	1,2,19,20,37,38,3,4,21,22,39,40
	.BYTE	5,6,23,24,41,42,7,8,25,26,43,44
	.BYTE	9,10,27,28,45,46,11,12,29,30,47,48                
	.BYTE	13,14,31,32,49,50,15,16,33,34
	.BYTE	51,52,17,18,35,36

DLE8D2	==	.-DDB8D2
LEN8D2	==	.-TB8D2


	.PAGE

;8" DOUBLE DENSITY, 512 BYTE SECTORS

TB8D3:	.BYTE	'8','D','3'
	.BYTE	LEN8D3

D8D003:	.BYTE	DCMD8D
	.BYTE	80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH
	.BYTE	15
	.BYTE	12,0H,3,0F5H,1,2H,22,04EH,12,0H,3,0F5H
	.WORD	512
	.BYTE	0E5H,84,04EH
	.WORD	400+400
	.BYTE	04EH

	.BYTE	ALE8D3
	.BYTE	DLE8D3
	.BYTE	DDB8D3-TB8D3

ALT8D3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00001011B
	.WORD	2
	.BYTE	2,36,2,60

	.WORD	60
	.BYTE	4,15,0
	.WORD	561
	.WORD	191		;MAXIMUM IS 255
	.BYTE	11100000B,0
	.WORD	48		;MAXIMUM IS 64
	.WORD	2
ALE8D3	==	.-ALT8D3

DDB8D3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00001001B
	.WORD	2
	.BYTE	2,36,2,60

	.WORD	60
	.BYTE	4,15,0
	.WORD	280
	.WORD	191
	.BYTE	11100000B,0
	.WORD	48
	.WORD	2

TRA8D3:	.BYTE	1,2,3,4,17,18,19,20,33,34,35,36
	.BYTE	49,50,51,52,5,6,7,8,21,22,23,24
	.BYTE	37,38,39,40,53,54,55,56,9,10,11,12
	.BYTE	25,26,27,28,41,42,43,44,57,58,59,60
	.BYTE	13,14,15,16,29,30,31,32,45,46,47,48
DLE8D3	==	.-DDB8D3
LEN8D3	==	.-TB8D3


	.PAGE

;8" DOUBLE DENSITY, 1024 BYTE SECTORS
;11 SECTORS PER TRACK
TB8D4:
        .BYTE   '8','D','4'
        .BYTE   LEN8D4
D8D004: .BYTE   DCMD8D
        .BYTE   30,04EH,12,0H,3,0F6H,1,0FCH,20,04EH
;       .BYTE   80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH <- JUST FOR INTEREST
        .BYTE   11
        .BYTE   12,0H,3,0F5H,1,3H,22,04EH,12,0H,3,0F5H
        .WORD   1024
        .BYTE   0E5H,26,04EH
;       .BYTE   0E5H,54,04EH <- JUST FOR INTEREST
        .WORD   400+400
        .BYTE   04EH
        .BYTE   ALE8D4
        .BYTE   DLE8D4
        .BYTE   DDB8D4-TB8D4
ALT8D4: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001011B
        .WORD   2
        .BYTE   2,36,3,88
        .WORD   88
        .BYTE   4,15,0
        .WORD   832
        .WORD   255             ;MAXIMUM IS 255 (256 ACTUAL)
        .BYTE   11110000B,0
        .WORD   64              ;MAXIMUM IS 64
        .WORD   2
ALE8D4  ==      .-ALT8D4
DDB8D4: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001001B
        .WORD   2
        .BYTE   2,36,3,88
        .WORD   88
        .BYTE   4,15,0
        .WORD   416
        .WORD   191
        .BYTE   11100000B,0
        .WORD   48
        .WORD   2
TRA8D4:
        .BYTE   1,2,3,4,5,6,7,8
        .BYTE   17,18,19,20,21,22,23,24
        .BYTE   33,34,35,36,37,38,39,40                
        .BYTE   49,50,51,52,53,54,55,56
        .BYTE   65,66,67,68,69,70,71,72
        .BYTE   81,82,83,84,85,86,87,88
        .BYTE   09,10,11,12,13,14,15,16
        .BYTE   25,26,27,28,29,30,31,32
        .BYTE   41,42,43,44,45,46,47,48
        .BYTE   57,58,59,60,61,62,63,64
        .BYTE   73,74,75,76,77,78,79,80
        
DLE8D4  ==      .-DDB8D4
LEN8D4  ==      .-TB8D4

	.PAGE

;5" SINGLE DENSITY, 128 BYTE SECTORS

TB5S1:	.BYTE	'5','S','1'
	.BYTE	LEN5S1

D5S001:	.BYTE	DCMD5S
	.BYTE	0,0H,0,0H,0,0H,0,0H,16,0FFH
	.BYTE	18
	.BYTE	4,0H,0,0H,1,0H,11,0FFH,6,0H,0,0H
	.WORD	128
	.BYTE	0E5H,10,0FFH
	.WORD	67+200
	.BYTE	0FFH

	.BYTE	ALE5S1
	.BYTE	DLE5S1
	.BYTE	DDB5S1-TB5S1

ALT5S1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00010111B
	.WORD	3
	.BYTE	2,36,0,18

	.WORD	18
	.BYTE	3,7,0
	.WORD	143
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3
ALE5S1	==	.-ALT5S1

DDB5S1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00010101B
	.WORD	3
	.BYTE	2,36,0,18

	.WORD	18
	.BYTE	3,7,0
	.WORD	71
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5S1:	.BYTE	1,5,9,13,17,3,7,11,15
	.BYTE	2,6,10,14,18,4,8,12,16
DLE5S1	==	.-DDB5S1
LEN5S1	==	.-TB5S1


	.PAGE

;5" SINGLE DENSITY, 512 BYTE SECTORS

TB5S3:	.BYTE	'5','S','3'
	.BYTE	LEN5S3
	
D5S002:	.BYTE	DCMD5S
	.BYTE	0,0H,0,0H,0,0H,0,0H,24,0FFH
	.BYTE	5
	.BYTE	6,0H,0,0H,1,2H,11,0FFH,6,0H,0,0H
	.WORD	512
	.BYTE	0E5H,46,0FFH
	.WORD	146+200
	.BYTE	0FFH

	.BYTE	ALE5S3
	.BYTE	DLE5S3
	.BYTE	DDB5S3-TB5S3

ALT5S3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00010111B
	.WORD	3
	.BYTE	2,36,2,20

	.WORD	20
	.BYTE	3,7,0
	.WORD	159
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3
ALE5S3	==	.-ALT5S3

DDB5S3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00010101B
	.WORD	3
	.BYTE	2,36,2,20

	.WORD	20
	.BYTE	3,7,0
	.WORD	79
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5S3:	.BYTE	1,2,3,4,9,10,11,12,17,18,19,20
	.BYTE	5,6,7,8,13,14,15,16
DLE5S3	==	.-DDB5S3
LEN5S3	==	.-TB5S3


	.PAGE

;5" SINGLE DENSITY, 1024 BYTE SECTORS

TB5S4:
	.BYTE	'5','S','4'
	.BYTE	LEN5S4

D5S003:	.BYTE	DCMD5S
	.BYTE	0,0H,0,0H,0,0H,0,0H,24,0FFH
	.BYTE	3
	.BYTE	6,0H,0,0H,1,3H,11,0FFH,6,0H,0,0H
	.WORD	1024
	.BYTE	0E5H,46,04EH
	.WORD	150+150
	.BYTE	04EH

	.BYTE	ALE5S4
	.BYTE	DLE5S4
	.BYTE	DDB5S4-TB5S4

ALT5S4:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00010111B
	.WORD	3
	.BYTE	2,36,3,24

	.WORD	24
	.BYTE	3,7,0
	.WORD	185
	.WORD	63	
	.BYTE	11000000B,0
	.WORD	16	
	.WORD	3
ALE5S4	==	.-ALT5S4

DDB5S4:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00010101B
	.WORD	3
	.BYTE	2,36,3,24

	.WORD	24
	.BYTE	3,7,0
	.WORD	92
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5S4:	.BYTE	1,2,3,4,5,6,7,8
	.BYTE	17,18,19,20,21,22,23,24
	.BYTE	09,10,11,12,13,14,15,16


DLE5S4	==	.-DDB5S4
LEN5S4	==	.-TB5S4


	.PAGE

;5" DOUBLE DENSITY, 128 BYTE SECTORS

TB5D1:	.BYTE	'5','D','1'
	.BYTE	LEN5D1

D5D001:	.BYTE	DCMD5D
	.BYTE	0,0H,0,0H,0,0H,0,0H,32,04EH
	.BYTE	27
	.BYTE	12,0H,3,0F5H,1,0H,22,04EH,12,0H,3,0F5H
	.WORD	128
	.BYTE	0E5H,30,04EH
	.WORD	278+400
	.BYTE	04EH

	.BYTE	ALE5D1
	.BYTE	DLE5D1
	.BYTE	DDB5D1-TB5D1

ALT5D1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00011111B
	.WORD	3
	.BYTE	2,36,0,27

	.WORD	27
	.BYTE	3,7,0
	.WORD	215
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3
ALE5D1	==	.-ALT5D1

DDB5D1:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00011101B
	.WORD	3
	.BYTE	2,36,0,27

	.WORD	27
	.BYTE	3,7,0
	.WORD	107
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5D1:	.BYTE	1,6,11,16,21,26,4,9,14
	.BYTE	19,24,2,7,12,17,22,27,5
	.BYTE	10,15,20,25,3,8,13,18,23
DLE5D1	==	.-DDB5D1
LEN5D1	==	.-TB5D1


	.PAGE

;5" DOUBLE DENSITY, 256 BYTE SECTORS

TB5D2:	.BYTE	'5','D','2'
	.BYTE	LEN5D2

D5D002:	.BYTE	DCMD5D
	.BYTE	0,0H,0,0H,0,0H,0,0H,32,04EH
	.BYTE	16
	.BYTE	12,0H,3,0F5H,1,1H,22,04EH,12,0H,3,0F5H
	.WORD	256
	.BYTE	0E5H,54,04EH
	.WORD	266+400
	.BYTE	04EH

	.BYTE	ALE5D2
	.BYTE	DLE5D2
	.BYTE	DDB5D2-TB5D2

ALT5D2:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00011111B
	.WORD	3
	.BYTE	2,36,1,32

	.WORD	32
	.BYTE	3,7,0
	.WORD	255
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3
ALE5D2	==	.-ALT5D2

DDB5D2:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00011101B
	.WORD	3
	.BYTE	2,36,1,32

	.WORD	32
	.BYTE	3,7,0
	.WORD	127
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5D2:	.BYTE	1,2,13,14,25,26,5,6,17,18,29,30
	.BYTE	9,10,21,22,3,4,15,16,27,28,7,8
	.BYTE	19,20,31,32,11,12,23,24
DLE5D2	==	.-DDB5D2
LEN5D2	==	.-TB5D2


	.PAGE

;5" DOUBLE DENSITY, 512 BYTE SECTORS

TB5D3:	.BYTE	'5','D','3'
	.BYTE	LEN5D3

D5D003:	.BYTE	DCMD5D
	.BYTE	0,0H,0,0H,0,0H,0,0H,32,04EH
	.BYTE	9
	.BYTE	12,0H,3,0F5H,1,2H,22,04EH,12,0H,3,0F5H
	.WORD	512
	.BYTE	0E5H,84,04EH
	.WORD	296+400
	.BYTE	04EH

	.BYTE	ALE5D3
	.BYTE	DLE5D3
	.BYTE	DDB5D3-TB5D3

ALT5D3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00011111B
	.WORD	3
	.BYTE	2,36,2,36

	.WORD	36
	.BYTE	4,15,1
	.WORD	143
	.WORD	63
	.BYTE	10000000B,0
	.WORD	16
	.WORD	3
ALE5D3	==	.-ALT5D3

DDB5D3:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00011101B
	.WORD	3
	.BYTE	2,36,2,36

	.WORD	36
	.BYTE	3,7,0
	.WORD	143
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5D3:	.BYTE	1,2,3,4,13,14,15,16,25,26,27,28
	.BYTE	5,6,7,8,17,18,19,20,29,30,31,32
	.BYTE	9,10,11,12,21,22,23,24,33,34,35,36
DLE5D3	==	.-DDB5D3
LEN5D3	==	.-TB5D3


	.PAGE

;5" DOUBLE DENSITY, 1024 BYTE SECTORS

TB5D4:
	.BYTE	'5','D','4'
	.BYTE	LEN5D4

D5D004:	.BYTE	DCMD5D
	.BYTE	0,0H,0,0H,0,0H,32,04EH
	.BYTE	5
	.BYTE	12,0H,3,0F5H,1,3H,22,04EH,12,0H,3,0F5H
	.WORD	1024
	.BYTE	0E5H,54,04EH
	.WORD	250+250
	.BYTE	04EH

	.BYTE	ALE5D4
	.BYTE	DLE5D4
	.BYTE	DDB5D4-TB5D4

ALT5D4:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	1H,0H,0H,0H,0H,0H

	.BYTE	00011111B
	.WORD	3
	.BYTE	2,36,3,40

	.WORD	40
	.BYTE	4,15,1
	.WORD	152
	.WORD	63	
	.BYTE	10000000B,0
	.WORD	16	
	.WORD	3
ALE5D4	==	.-ALT5D4

DDB5D4:	.BYTE	0DDH,0FDH,0DDH,0FDH
	.BYTE	0H,0H,0H,0H,0H,0H

	.BYTE	00011101B
	.WORD	3
	.BYTE	2,36,3,40

	.WORD	40
	.BYTE	3,7,0
	.WORD	152
	.WORD	63
	.BYTE	11000000B,0
	.WORD	16
	.WORD	3

TRA5D4:	.BYTE	1,2,3,4,5,6,7,8
	.BYTE	17,18,19,20,21,22,23,24
	.BYTE	33,34,35,36,37,38,39,40                
	.BYTE	09,10,11,12,13,14,15,16
	.BYTE	25,26,27,28,29,30,31,32

DLE5D4	==	.-DDB5D4
LEN5D4	==	.-TB5D4


	.BYTE	0	;END OF TABLES


;8" DOUBLE DENSITY, 1024 BYTE SECTORS
;9 SECTORS PER TRACK = 1.3 MBYTES
TB09S:
        .BYTE   '8','D','4'
        .BYTE   LEN8D4		;<- A LIE, BUT NEEDED FOR INDEX LEN09S
D8D005: .BYTE   DCMD8D
        .BYTE   80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH
        .BYTE   9
        .BYTE   12,0H,3,0F5H,1,3H,22,04EH,12,0H,3,0F5H
        .WORD   1024
        .BYTE   0E5H,54,04EH
        .WORD   400+400
        .BYTE   04EH
        .BYTE   ALE09S
        .BYTE   DLE09S
        .BYTE   DDB09S-TB09S
ALT09S: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001011B
        .WORD   2
        .BYTE   2,36,3,72
        .WORD   72
        .BYTE   4,15,0
        .WORD   670
        .WORD   255             ;MAXIMUM IS 255 (256 ACTUAL)
        .BYTE   11110000B,0
        .WORD   64              ;MAXIMUM IS 64
        .WORD   2
ALE09S  ==      .-ALT09S
DDB09S: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001001B
        .WORD   2
        .BYTE   2,36,3,72
        .WORD   72
        .BYTE   4,15,0
        .WORD   332
        .WORD   191
        .BYTE   11100000B,0
        .WORD   48
        .WORD   2
TRA09S: .BYTE   1,2,3,4,5,6,7,8
        .BYTE   17,18,19,20,21,22,23,24
        .BYTE   33,34,35,36,37,38,39,40                
        .BYTE   49,50,51,52,53,54,55,56
        .BYTE   65,66,67,68,69,70,71,72
        .BYTE   09,10,11,12,13,14,15,16
        .BYTE   25,26,27,28,29,30,31,32
        .BYTE   41,42,43,44,45,46,47,48
        .BYTE   57,58,59,60,61,62,63,64
DLE09S  ==      .-DDB09S
LEN09S  ==      .-TB09S

;8" DOUBLE DENSITY, 1024 BYTE SECTORS
;10 SECTORS PER TRACK = 1.56 MBYTES
TB10S:
        .BYTE   '8','D','4'
        .BYTE   LEN8D4	;<- A LIE, BUT NEEDED FOR INDEX LEN10S
D8D006: .BYTE   DCMD8D
        .BYTE   80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH
        .BYTE   10
        .BYTE   12,0H,3,0F5H,1,3H,22,04EH,12,0H,3,0F5H
        .WORD   1024
        .BYTE   0E5H,54,04EH
        .WORD   400+400
        .BYTE   04EH
        .BYTE   ALE10S
        .BYTE   DLE10S
        .BYTE   DDB10S-TB10S
ALT10S: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001011B
        .WORD   2
        .BYTE   2,36,3,80
        .WORD   80
        .BYTE   4,15,0
        .WORD   780
        .WORD   255             ;MAXIMUM IS 255 (256 ACTUAL)
        .BYTE   11110000B,0
        .WORD   64              ;MAXIMUM IS 64
        .WORD   2
ALE10S  ==      .-ALT10S
DDB10S: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001001B
        .WORD   2
        .BYTE   2,36,3,80
        .WORD   80
        .BYTE   4,15,0
        .WORD   360
        .WORD   191
        .BYTE   11100000B,0
        .WORD   48
        .WORD   2
TRA10S: .BYTE   1,2,3,4,5,6,7,8
        .BYTE   17,18,19,20,21,22,23,24
        .BYTE   33,34,35,36,37,38,39,40                
        .BYTE   49,50,51,52,53,54,55,56
        .BYTE   65,66,67,68,69,70,71,72
        .BYTE   09,10,11,12,13,14,15,16
        .BYTE   25,26,27,28,29,30,31,32
        .BYTE   41,42,43,44,45,46,47,48
        .BYTE   57,58,59,60,61,62,63,64
        .BYTE   73,74,75,76,77,78,79,80
        
DLE10S  ==      .-DDB10S
LEN10S  ==      .-TB10S
;8" DOUBLE DENSITY, 1024 BYTE SECTORS
;11 SECTORS PER TRACK
TB11S:
        .BYTE   '8','D','4'
        .BYTE   LEN11S		;<- EQUALS LEN8D4 FOR INDEX
D8D007: .BYTE   DCMD8D
        .BYTE   30,04EH,12,0H,3,0F6H,1,0FCH,20,04EH
;       .BYTE   80,04EH,12,0H,3,0F6H,1,0FCH,50,04EH ;JUST FOR INTEREST
        .BYTE   11
        .BYTE   12,0H,3,0F5H,1,3H,22,04EH,12,0H,3,0F5H
        .WORD   1024
        .BYTE   0E5H,26,04EH
;       .BYTE   0E5H,54,04EH		;JUST FOR INTEREST
        .WORD   400+400
        .BYTE   04EH
        .BYTE   ALE11S
        .BYTE   DLE11S
        .BYTE   DDB11S-TB11S
ALT11S: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001011B
        .WORD   2
        .BYTE   2,36,3,88
        .WORD   88
        .BYTE   4,15,0
        .WORD   832
        .WORD   255             ;MAXIMUM IS 255 (256 ACTUAL)
        .BYTE   11110000B,0
        .WORD   64              ;MAXIMUM IS 64
        .WORD   2
ALE11S  ==      .-ALT11S
DDB11S: .BYTE   0DDH,0FDH,0DDH,0FDH
        .BYTE   0H,0H,0H,0H,0H,0H
        .BYTE   00001001B
        .WORD   2
        .BYTE   2,36,3,88
        .WORD   88
        .BYTE   4,15,0
        .WORD   416
        .WORD   191
        .BYTE   11100000B,0
        .WORD   48
        .WORD   2
TRA11S: 
        .BYTE   1,2,3,4,5,6,7,8         ;01
        .BYTE   25,26,27,28,29,30,31,32 ;04
        .BYTE   41,42,43,44,45,46,47,48 ;06
        .BYTE   57,58,59,60,61,62,63,64 ;08
        .BYTE   73,74,75,76,77,78,79,80 ;10
        .BYTE   09,10,11,12,13,14,15,16 ;02
        .BYTE   33,34,35,36,37,38,39,40 ;05
        .BYTE   49,50,51,52,53,54,55,56 ;07
        .BYTE   65,66,67,68,69,70,71,72 ;09
        .BYTE   81,82,83,84,85,86,87,88 ;11
        .BYTE   17,18,19,20,21,22,23,24 ;03
  
DLE11S  ==      .-DDB11S
LEN11S  ==      .-TB11S

; OPTION STORAGE.

QUFLAG:	.BYTE	0	; 0 IF FIRST TIME THROUGH
TRSAV:	.BLKB	1	; TRACKS - S OR A (System or All)
SISAV:	.BLKB	1	; SIZE - 5 OR 8
DESAV:	.BLKB	1	; DENSITY - S OR D (Single or Double)
LESAV:	.BLKB	1	; SECTOR LENGTH - 1,2,3, OR 4
NESAV:	.BLKB	1	; TRACKS - S OR E (Standard or Extended 5" drives)	
SDSAV:	.BLKB	1	; SIDES - S OR D (Single or Double)
STDSAV:	.BLKB	1	; SYSTEM TRACKS (Standard or V2BIOS)
SDFORM:	.BLKB	1	; SIDES TO FORMAT FOR SYSTEM TRACKS
MEGSAV:	.BLKB	1	; 9, 10 or 11 SPT
CPMSAV:	.BLKB	1
VERFON:	.BLKB	1	; SKIP READ VERIFY


; MISCELLANEOUS VARIABLES.

DRIVE:	.BLKB	1	;DISK DRIVE
Z3SBYT:	.BLKB	1	;CURRENT Z3S CONTROL BYTE
Z3SSYS:	.BLKB	1	;SYSTEM TRACK Z3S CONTROL BYTE
TRAKK:	.BLKB	1	;CURRENT TRACK
MAXTRK:	.BLKB	1	;HIGHEST TRACK
SECTOR:	.BLKB	1	;CURRENT SECTOR
REPEAT:	.BLKB	1	;LOOP VARIABLE

CREATE:			;VARIABLES PASSED TO LTABLE
SIZE:	.BLKB	1
DEN:	.BLKB	1
SSIZ:	.BLKB	1


; DISK DESCRIPTION TABLE. THE TABLE WHICH DESCRIBES THE
; DISK TO BE FORMATTED IS MOVED HERE TO ALLOW MORE
; CONVENIENT ACCESS.

DTABLE:
	.BLKB	4	;HEADER
DPROTO:	.BLKB	1	;Z3S PROTOTYPE
G4AL:	.BLKB	1	;GAP 4 A
G4AV:	.BLKB	1
INSYAL:	.BLKB	1	;INDEX SYNC PATTENS
INSYAV:	.BLKB	1
INSYBL:	.BLKB	1
INSYBV:	.BLKB	1
INAML:	.BLKB	1	;INDEX AM
INAMV:	.BLKB	1
G1L:	.BLKB	1	;GAP 1
G1V:	.BLKB	1
RPTCNT:	.BLKB	1	;REPEAT COUNT - NUMBER OF SECS
IDSYAL:	.BLKB	1	;ID SYNC PATTERNS
IDSYAV:	.BLKB	1
IDSYBL:	.BLKB	1
IDSYBV:	.BLKB	1
LENL:	.BLKB	1	;SECTOR LENGTH CONTROL BYTE
LENV:	.BLKB	1
G2L:	.BLKB	1	;GAP 2
G2V:	.BLKB	1
DASYAL:	.BLKB	1	;DATA SYNC PATTERNS
DASYAV:	.BLKB	1
DASYBL:	.BLKB	1
DASYBV:	.BLKB	1
DACNTL:	.BLKW	1	;DATA
DACNTV:	.BLKB	1
G3L:	.BLKB	1	;GAP 3
G3V:	.BLKB	1
G4BL:	.BLKW	1	;GAP 4
G4BV:	.BLKB	1

ALTLEN:	.BLKB	1	;LENGTH OF DOUBLE SIDED
			;DDB WHICH REPLACES STANDARD
DDBLEN:	.BLKB	1	;LENGTH OF STANDARD DDB
DDBLOC:	.BLKB	1	;LOCATION OF STANDARD DDB
ALTDDB:	.BLKB	192	;ALTDDB AND DDB
DLEN	==	.-DTABLE ;TABLE LENGTH


; HEAD NUMBER AND TRACK NUMBER ADDRESSES SAVED HERE.

TRTAB:	.BLKW	50
TRLEN	==	.-TRTAB



;BDOS FUNCTIONS

	GCON	==	1	;GET CONSOL
	WCON	==	2	;OUTPUT CONSOL
	PRINT	==	9	;PRINT STRING
	GBUF	==	10	;GET CONSOL BUFFER

;SYSTEM LOCATIONS

	BDOS	==	5	;LOC OF ENTRY



CRLF2:
	LXI	D,CRLF1
	MVI	C,PRINT
	CALL	BDOS
	RET
	
CRLF1:
	.BYTE	LF,CR,LF,CR,24H


ASKFOR:
	LXI	SP,100H

	CALL	MSGF
	.BYTE	CR,LF,LF
	.ASCII	\Check the diskette and selected drive for binding, \
	.BYTE	CR,LF
	.ASCII	\write protection, or wrong media type for format options:\
	.BYTE	CR,LF,LF
	.ASCIS	\Enter R to (R)etry the same format or N to try a (N)ew format (R,N):\

	LXI	H,ASKOK
	CALL	GETOK
	CPI	'R'
	JZ	FORMAT
	MVI	A,0
	STA	QUFLAG
	JMP	FORMAT
	


; WE DO NOT DO A READ AFTER FULL FORMAT ANYMORE,
; SINCE THAT WAS BIOS DEPENDANT. WE USED TO
; FORMAT THE ENTIRE DISKETTE, THEN COME HERE
; AND EXECUTE CODE THAT READ THE ENTIRE DISKETTE
; THRU THE BIOS. THE OPERATION WAS FAST, BUT IF
; A DISKETTE HAD ERRORS, IT WOULD BE LONGER THAN
; THE READ-VERIFY TESTING NOW USED. IN ADDITION
; THE BIOS READ TESTING COULD NOT WORK WITH
; THE NEW 'STANDARD' FORMAT OPTION, SINCE
; NO SPECIAL SYSTEM TRACKS WITH A DDB ARE
; GENERATED FOR THAT OPTION.

READD:
GOBAK:
	LXI	SP,100H

	CALL	MSGF
	.BYTE	CLEAR,CR,LF,LF
	.ASCII	\Type R to return to the command prompt \
	.BYTE	CR,LF
	.ASCII	\Type F to format another diskette: \
	.BYTE	CR,LF,LF
	.ASCIS	\Make sure you have a working System Diskette in your Boot Drive (R,F): \

	LXI	H,QUITOK
	CALL	GETOK
	CPI	'F'
	JZ	FORMAT
GOMOR:
PIEND:
	JMP	0
EEXIT:
	JMP	0

;SET DRIVE TO HOME TRACK

HDRV:
	RET


;CONVERT THE BYTE IN C REG. TO TWO HEX NIBBLES AND PRINT

DOHEX:
	MOV	A,C
	ANI	0F0H
	RRC
	RRC
	RRC
	RRC
	ORI	30H
	CALL	COUT
	MOV	A,C
	ANI	0FH
	CPI	10
	JRNC	ALPH
	ORI	30H
	CALL	COUT
	MVI	A,CR
	CALL	COUT
	RET
ALPH:	SUI	9
	ORI	40H
	CALL	COUT
	MVI	A,CR
	CALL	COUT
	RET

TRFMES:	.ASCII	\                          formatting cylinder $\

TRVMES:	.ASCII	\                           verifying cylinder $\


COUT:
	PUSH	B
	MOV	E,A
	MVI	C,WCON
	CALL	BDOS
	POP	B
	RET


SKEWTB:	.BLKB	88
	.BYTE	0		;MARK TABLE END

SKEWGN:	.BYTE	1,0,3,4,5,6,0
 

		
; MORE PROGRAM STORAGE
; OH GOSH! SO MANY VARIABLES WERE USED ONCE.
; HERE THEY REMAIN UNTIL ANOTHER CLEANUP

SKEW:	.BYTE	0		;SKEW TABLE FOR CP/M OR MP/M
VERFLG:	.BYTE	0		;VERSION NUMBER, DEFAULT = CP/M
RTNTRK:	.BLKB	1		;RETURN TRACK
CTLBYT:	.BLKB	1		;CONTROL LATCH VALUE	
BOTVEC:	.BLKW	1		;BOOT O.K. LABEL
ALTB1:	.BYTE	0,'B'		;"B" FOR A:
ALTB2:	.BYTE	0,'B'		;"B" FOR B:
ALBONE:	.BLKW	1		;FIRST LABEL ON A
ANS1:	.BYTE	0		;SPECIAL "B" FORMAT ALLOWED
ACOP:	.BLKW	1		;VALUE OF "A" DISK #
CPFLG:	.BYTE	0		;DISK "A" COPIED FLAG
CURTRK:	.BLKW	1		;CURRENT TRACK
TTAB:	.WORD	1		; WAS DDBB+31-POINTER TO XLATE TABLE
SKWPTR:	.BLKW	1		;POINTER TO SKEW TABLE
NXTSEC:	.BLKW	1		;NEXT SECTOR TO R/W
SOURCE:	.BLKB	1		;SOURCE DRIVE
DESTIN:	.BLKB	1		;DESTINATION DRIVE
SCOUNT:	.BYTE	1		;SECT. COUNT 
STRK:	.BYTE	0		;INITIAL TRACK
TADD:	.BLKW	1		;CURRENT DMA ADDRESS
TLENS:	.BLKW	1		;TRACK LENGTH IN BYTES
DPSAV:	.BLKW	1		;DPH POINTER
NDSR:	.BLKB	1		;NUMBER OF USER SECTORS
FMDRV:	.BLKB	1		;DRIVE THAT WAS FORMATTED
CURDRV:	.BLKB	1		;CURRENT DRIVE
NDSR1:	.BLKB	1		;NUMBER OF SECTORS ON A:
TLENS1:	.BLKW	1		;TRACK LENGTH ON A:
LABA:	.BLKW	1		;SAVED DRIVE A: LABEL
LABB:	.BLKW	1		;SAVED DRIVE B: LABEL
TRKS:	.BLKB	1		;NUMBER OF DISK TRACKS
TNDSR:	.BLKB	1		;TEMP. # OF USER SECTORS
LABNAM:	.BLKW	1		;NAME OF LABEL TO WRITE
RTADD:	.BLKW	1		;POINTER TO READ DMA ADDRESS
RSTAT:	.BLKB	1
Z3SFLG:	.BLKB	1		;Z3S OR VFII FLAG, 0 = Z3S
.ASCII	\FAIL CODES+\
FAILED:	.BLKB	6		;SOME FORMAT FAILURE BYTES GO HERE
.ASCII	\FINAL+\
FINAL:	.WORD	0FFFFH
.ASCII	\FINFLG+\
FINFLG:	.BYTE	0
.ASCII	\CHKFKG+\
CHKFLG:	.BYTE	0
.ASCII	\VERADD+\	
VERADD:	.WORD	0FFFFH
.ASCII	\SECCOM+\
SECCOM:	.WORD	0FFFFH
.ASCII	\LENV+\
SECSZ:	.BYTE	0FFH
.ASCII	\BDSIZ+\
BDSIZ:	.BYTE	0FFH
.ASCII	\PSWSAV+\
PSWSAV:	.WORD	0FFFFH

PSIZE	==	.-FORMAT	
RSIZE	==	((.-FORMAT)/128)
SSIZE	==	RSIZE*128

	.IFG	PSIZE-SSIZE,[

	MRECS	==	RSIZE+1
		][
	MRECS	==	RSIZE
		]
	

;----------------------------------------------
; OLD DDB SAVE SPACE - OMIT IT HERE WITH ";"
;
;DDBB:
;	.BLKB	128	;DDB READ BUFFER
;DDB1:
;	.BLKB	128	;DRIVE B DDB BUFFER
;----------------------------------------------

; UPR TO 14K OF AREA FOR PROTOTYPE TRACK 

TBEGIN:

; THEN UP TO 11 K FOR A VERIFY READ BUFFER	


	.END
