;********************************************************
;*                        V2BOOT2
;*                CP/M COLD BOOT LOADER	                *
;*                RUN FROM WITHIN CP/M FOR 
;*                VERSAFLOPPY II BOOT STRAP
;*                BOOTS SECOND FLOPPY DRIVE
;*                OR USER SELECTED DRIVE      
;*                      12/15/03
;********************************************************


	.XLINK
	.Z80		;Z80 OPCODES USED
	.PHEX
	.PABS
	.LOC	100H	;THIS LOADER BEGINS HERE

; THE COLD START LOADER IS LOADED FROM THE FIRST 128
; BYTES OF TRACK 0, SECTOR 1 BY THE UNIVERSAL BOOT.
; THE LOADER READS IN THE REST OF THE CP/M SYSTEM.

; THE FIRST TWO TRACKS OF ANY SYSTEM DISK MUST HAVE AT
; LEAST 8 SECTORS OF 512 BYTES EACH. THE INFORMATION
; ON THESE SECTORS MUST BE:

;   TRACK 0, SECTOR 1, BYTES 0 THRU 127 - LOADER
;   TRACK 0, SECTOR 1, BYTES 128 THRU 511 - CP/M
;   TRACK 0, SECTOR 2 THRU SECTOR 7 - CP/M
;   TRACK 0, SECTOR 8, BYTES 0 THRU 383 - CP/M
;   TRACK 0, SECTOR 8, BYTES 384 THRU 511 - DDB
;   TRACK 0, SECTOR 9, BYTES 0 THRU 511 - CP/M
;   TRACK 1, SECTOR 1 THRU SECTOR 9 - CP/M, FOLLOWED
;	BY THE CBIOS

; THE LOADER EXTRACTS THE CP/M SECTORS FROM TRACK 0,
; SKIPPING OVER THE NON CP/M BYTES.
; THE LAYOUT OF THE SYSTEM TRACKS
; IS IDENTICAL FOR BOTH 5" AND 8" DISKETTES. THE SYSTEM
; TRACKS ON 5" DISKETTES ARE RECORDED IN DOUBLE DENSITY
; IN ORDER TO FIT ALL THE REQUIRED SECTORS.

; SINCE THE SYSTEM TRACK LAYOUT IS IDENTICAL, THIS ONE
; LOADER CAN BOOT FROM BOTH SIZES OF DISKS ONCE THE D3S
; OR D4S CONTROL BYTE HAS BEEN PROPERLY SET.

	.PAGE

BDOS	==	5
CR	==	13
LF	==	10
BELL	==	7

; PORT ADDRESSES.

DCMD	==	063H	;DMA DISC CONTROL PORT
WDC	==	064H	;WDC 179X BASE ADDRESS
WCMD	==	WDC+0	;COMMAND REGISTER
WSTAT	==	WDC+0	;STATUS REGISTER
WTRACK	==	WDC+1	;TRACK REGISTER
WSECT	==	WDC+2	;SECTOR REGISTER
WDATA	==	WDC+3	;DATA REGISTER

GETCON	==	1	;GET CONSOLE
PRINTS	==	9	;BDOS PRINT STRING
GCSTAT	==	11	;GET CONSOLE STATUS


BOOT	==	0	;TRACK LOADER GOES HERE

	DI
	LXI	SP,100H
	JMP	SAFE00

;MOVE TO A PLACE ABOVE THE FIRST SECTOR

	.LOC	200H
SAFE00:

; FUNCTION TO TURN OFF ANY ONBOARD RAM/ROM
; REMOVE ; IF YOU HAVE THE CORRECT CPU CARD
; ELSE INSERT CODE FOR YOUR SYSTEM

	
;	MVI	A,2	;SBC-200 RAM/ROM BIT
;	OUT	7FH	;TURN ONBOARD RAM/ROM OFF

;	OUT	0AH	;FOR ZEUS ROM DISABLE


; SEE IF THIS IS RUNNING WITH A CP/M TYPE BDOS

CHEKOS:
	LDA	BDOS
	CPI	0C3H
	MVI	A,0
	JZ	HAVDOS	;LOOKS OK FOR BDOS
	MVI	A,0FFH
	STA	DOSFLG
	JMP	NODOS	;NOT A BDOS
	
HAVDOS:
	STA	DOSFLG
	LXI	D,BOOTOP
	MVI	C,PRINTS
	CALL	BDOS

	LXI	D,0
	MVI	B,2
ANLOOP:
	PUSH	D
	PUSH	B
	MVI	C,GCSTAT
	CALL	BDOS
	POP	B
	POP	D
	CPI	0
	JNZ	HAVANS
	INX	D
	MOV	A,D
	ORA	E
	JZ	BLOOP
	JMP	ANLOOP
BLOOP:
	PUSH	D
	PUSH	B
	MVI	C,2
	MVI	E,'.'
	CALL	BDOS
	POP	B
	POP	D
	DCR	B
	JNZ	ANLOOP

PNODOS:
	MVI	A,0FFH
	STA	DOSFLG
	JMP	NODOS

HAVANS:
	LXI	H,OKDRIV
	CALL	GETOK

	STA	BOOTAN

	LXI	D,WAITOP
	MVI	C,PRINTS
	CALL	BDOS

NODOS:	

	MVI	C,20
CWAIT:
	LXI	H,0
HLWAIT:
	INX	H
	MOV	A,H
	ORA	L
	JNZ	HLWAIT

	LDA	DOSFLG
	CPI	0
	JNZ	SKIPP

	PUSH	H
	PUSH	B
	MVI	C,2
	MVI	E,'+'
	CALL	BDOS
	POP	B
	POP	H
SKIPP:
	DCR	C
	JZ	PRETRY
	LDA	DOSFLG
	CPI	0
	JNZ	CWAIT

	PUSH	B

	MVI	C,GCSTAT
	CALL	BDOS
	POP	B
	CPI	0
	JNZ	PRETRY
	JMP	CWAIT

PRETRY:
	LDA	BOOTAN
	CPI	'1'
DRIVE1:	MVI	A,7EH
	JZ	DOADRV
	LDA	BOOTAN
	CPI	'2'
	JZ	DRIVE2
	CPI	'3'
	JZ	DRIVE3
DRIVE4:	MVI	A,77H
	JMP	DOADRV
DRIVE2:	MVI	A,7DH
	JMP	DOADRV
DRIVE3:	MVI	A,7BH	


DOADRV:
	OUT	DCMD		
	LDA	BOOTAN
	CPI	'1'
	JZ	RETRY
	STA	THEDRV
	LXI	D,NOTA
	MVI	C,PRINTS
	CALL	BDOS

	MVI	B,8
	LXI	H,0
HWAIT:
	DCX	H
	MOV	A,H
	ORA	L
	JNZ	HWAIT
	DCR	B
	JNZ	HWAIT
	JMP	RETRY

NOTA:
	.BYTE	CR,LF,LF
	.ASCII	\BE SURE THE SYSGEN IMAGE USES DRIVE \
THEDRV:
	.BYTE	'X'
	.ASCII	\ AS A SYSTEM DRIVE $\





RETRY:
	LXI	H,BOOT
..HOME:
	MVI	A,0BH	;RESTORE THE DISC DRIVE
	OUT	WCMD	;SEND TO CONTROLLER
	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT

..NB:	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY (y/n)
	JRNZ	..NB	;YES,KEEP WAITING

	MVI	A,1	;START WITH SECTOR 1
	OUT	WSECT	;SET SECTOR REG
SECTOR:
	MVI	A,88H	;ISSUE READ SECTOR COMMAND 
	OUT	WCMD
	LXI	B,0067H	;SET UP BC FOR PIO READ NEXT
	INIR		;DO PIO SECTOR READ
	INIR

	MVI	B,200	;DELAY TILL VALID STATUS
..WAIT:	DJNZ	..WAIT

..NB:	IN	WSTAT	;GET STATUS
	BIT	0,A	;BUSY (y/n)
	JRNZ	..NB	;YES,KEEP WAITING
	ANI	9DH	;WAS READ SUCCESSFUL(y/n)
	JZ	BOOT	;GET SYSTEM
	JMPR	RETRY

;****************************************************
; GET A CHARACTER FROM THE CONSOLE. IF THE CHARACTER
; IS UNACCEPTABLE, BEEP AND WAIT FOR ANOTHER. RETURN
; TO CP/M IF ^C IS ENTERED. (BDOS DOES RETURN ON ^C)
;****************************************************
; THE CCIR Z80 INSTRUCTION CHECKS ALL ACCEPTABLE
; CHARACTERS FROM THE TABLE POINTED TO BY HL
; A BAD INPUT CAUSES A BELL, PLUS A BACKSPACE
; BLANK-OVER AND BACKSPACE TO ERASE THE WRONG
; INPUT ON CONSOLE, THEN THE ROUTINE IS RE-ENTERED
;====================================================

GETOK:	
..RTRY:	PUSH	H	;SAVE OK TABLE ADDR
	MOV	C,M	;GET COUNT
	INX	H
	MVI	B,0
	CALL	CI	;GET A CHAR
	CPI	'Q'	;IS IT QUIT 
	JZ	GOBAK	;YES, GO BACK TO CP/M
	CCIR		;IS IT OKAY
	POP	H
	RZ		;YES, RETURN IT

	MVI	C,BELL	;NO, RING BELL
	CALL	CO
	MVI	C,8	;BACK SPACE
	CALL	CO
	MVI	C,' '
	CALL	CO
	MVI	C,8
	CALL	CO
	JMP	..RTRY	;KEEP TRYING

;***************************************************
;       GET A CHARACTER FROM THE CONSOLE.
;***************************************************

CI:	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,1	;CONSOLE INPUT
	CALL	BDOS	;GET THE CHARACTER
	POP	H
	POP	D
	POP	B
	RET

;**************************************************
;      WRITE A CHARACTER TO THE CONSOLE.
;**************************************************

CO:	PUSH	B
	PUSH	D
	PUSH	H
	MOV	A,C
	ANI	7FH
	MOV	E,A	;MOVE CHARACTER TO E
	MVI	C,2	;CONSOLE OUTPUT
	CALL	BDOS	;OUTPUT THE CHARACTER
	POP	H
	POP	D
	POP	B
	MOV	A,C	;FIX UP ACC
	RET

GOBAK:
	LXI	D,QUITER
	MVI	C,PRINTS
	CALL	BDOS
	JMP	0

QUITER:
	.BYTE	CR,LF,LF,LF
	.ASCII	\EXITING TO COMMAND PROMPT $\



BOOTOP:
	.BYTE	CR,LF,LF,LF
	.ASCII	\WAIT FOR TIMED BOOT FROM SECOND DRIVE \
	.BYTE	CR,LF,LF
	.ASCII	\OR ENTER 1 OR 2, 3 OR 4 TO SELECT DRIVE $\

 
WAITOP:
	.BYTE	CR,LF,LF,LF
	.ASCII	\LOADER STARTS IN ABOUT 5 TO 20 SECONDS (8mhz to 2mhz system)\
	.BYTE	CR,LF
	.ASCII	\OR PRESS ANY KEY WHEN READY TO START BOOT  $\

OKDRIV:	.BYTE	4,'1','2','3','4'

BOOTAN:	.BYTE	'2'

DOSFLG:	.BYTE	0


	.END
