;********************************************************
;*                        PRINT.ASM
;*                         11/22/83
;********************************************************

;
; EQUATES
;
ASCII	EQU	7FH		;ASCII MASK
ASTER	EQU	2AH		;ASTERISK
CTRD	EQU	4		;CONTROL-D
TAB	EQU	9		;TAB
CR	EQU	0DH
LF	EQU	0AH
FF	EQU	0CH		;FORM FEED
EOFM	EQU	1AH		;CONTROL Z
LOCASE	EQU	20H		;LOWER CASE MASK
SEMICOL	EQU	3BH		;SEMICOLON
SPACE	EQU	20H
TICK	EQU	27H		;APOSTROPHE
UPCASE	EQU	5FH		;UPPER CASE MASK
;
;
	ORG	100H
;
;
;=======================================================================
;
; START - SEE IF ANY SOURCE FILE MENTIONED, IF NOT, DISPLAY INFORMATION
; TELLING HOW TO USE THE PROGRAM, THEN EXIT
;
START:	LXI	H,0
	DAD	SP		;GET 'CCP' STACK
	SHLD	STACK		;SAVE IT FOR EXIT
	LXI	SP,STACK	;SET LOCAL STACK
	LDA	FCB+1		;SOURCE FILE SPECIFIED?
	CPI	SPACE
	JZ	0

; SEE IF ANY DESTINATION FILE MENTIONED, IF NOT, COPY SOURCE NAME AS A
; DEFAULT NAME
;
	LDA	FCB2+1		;DESTINATION FILE NAMED?
	CPI	SPACE
	JNZ	START1		;IF YES, EXIT
	LXI	H,FCB		;OTHERWISE USE SAME FILENAME..	
	LXI	D,DEST		;..WITH .$$$ EXTENT FOR NOW
	MVI	B,9
	CALL	MOVE
	JMP	START2
;
;
;=======================================================================
;
; MOVE THE DESTINATION FILENAME INTO THE SPECIAL 'DEST' BUFFER
;
START1:	LXI	H,FCB2		;DESTINATION FILENAME
	LXI	D,DEST		;DESTINATION 'FCP' IN 'TPA'
	MVI	B,16		;NUMBER OF BYTES TO MOVE
	CALL	MOVE
;
;
;
;=======================================================================
;
; ZERO THE RECORD COUNT (IF STILL PRESENT)
;
START2:	XRA	A
	STA	SOURCE+32	;ZERO CURRENT RECORD BYTE
	STA	DEST+32
;
;	
;=======================================================================
;
; OPEN THE SOURCE FILE, ERASE THE DESTINATION FILE (IN CASE ONE BY THAT
; NAME) THEN OPEN THE DESTINATION FILE -- SHOW ERROR MESSAGE IF ANY OF
; THESE CANNOT BE ACCOMPLISHED.
;
	LXI	D,SOURCE	;FCB
	MVI	C,OPEN
	CALL	BDOS
	INR	A		;IF ERROR, 0FFH WAS RETURNED
	JZ	NOSOURCE	;REPORT ERROR AND EXIT
;
;
;
;=======================================================================
;
; NOW TRANSFER THE SOURCE FILE (OR THE FIRST 32K) INTO THE BUFFER
;


	MVI	A,FF
	CALL	LSTOUT


NEXT:	LXI	H,BUFFER
;
NEXT1:

	
	XCHG			;SECTOR ADDRESS TO 'DE'
	PUSH	D		;SAVE DMADR
	MVI	C,SETDMA
	CALL	BDOS
	LXI	D,SOURCE
	MVI	C,READ
	CALL	BDOS
	ORA	A
	JNZ	EOF		;END OF FILE
;
	LDA	COUNT		;COUNT IS ZERO INITIALLY (MOD 256)
	INR	A
	STA	COUNT		;CAN GO UP TO 256 (32K)
	POP	H		;GET DMADR BACK
	LXI	D,128		;BUMP IT BY ONE SECTOR
	DAD	D
	JNZ	NEXT1		;READ 256 (32K) SECTORS OR UNTIL 'EOF'
;
;
;=======================================================================
;
; NOW GO THROUGH THE BUFFER AND PRINT TO LIST DEVICE

;
FILTER:	LXI	H,BUFFER
;
FILT1:	MOV	A,M		;GET THE CHARACTER
	ANI	ASCII
	MOV	B,A		;SAVE IT
	CPI	EOFM		;^Z
	JZ	LAST
	CPI	TAB
	JNZ	NOTAB
	MVI	C,8
TABLOP:
	MVI	A,SPACE
	CALL	LSTOUT
	DCR	C
	JNZ	TABLOP
	JMP	CTL1

NOTAB:
	CPI	CTRD		;^D			
	MVI	A,SPACE
	JZ	CTL1		;SKIP IF SO
	MOV	A,B
	CPI	LF
	JZ	MAYBE
	CPI	CR
	JNZ	NOPE1
MAYBE:	INX	H		;NOW CHECK FOR NEW PAGE = '.P' MARKER
	MOV	A,M		;LOOK FOR '.'
	CPI	'.'
	JZ	YESPER		;O.K. IT IS A PERIODE
	DCX	H
	MOV	A,B
	JMP	NOPE1
YESPER:	INX	H		;LOOK FOR 'P' NEXT
	MOV	A,M
	CPI	'P'
	JZ	YESPG		;O.K. IT'S A NEW PAGE
	DCX	H		;ELSE RESET POINTER	
	DCX	H
	MOV	A,B
	JMP	NOPE1
YESPG:	MVI	A,FF
	CALL	LSTOUT
	MVI	A,LF

NOPE1:
	CALL	LSTOUT

	CALL	TSTEXT


;
CTL1:	INX	H
	PUSH	H		;SAVE IT FOR A MOMENT
	LXI	D,-(BUFFER+8000H)  ;END OF BUFFER
	DAD	D
	JC	NEXT		;DO ANOTHER BUFFER
	POP	H		;RESTORE 'HL'
	JMP	FILT1

;
; UTILTY ROUTINES AND ERROR MESSAGES
;
EOF:	MVI	A,1
	STA	EOFLG
	JMP	FILTER
;.....
;
;
LAST:
	MVI	C,5
	MVI	E,0CH
	CALL	5

EXIT:
	JMP	0

	LHLD	STACK		;GET 'CCP' STACK RETURN ADDRESS
	SPHL
	RET			;RETURN TO CPM
;.....
;
;
MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B		;DECREMENT BYTE COUNT
	JNZ	MOVE		;IF NOT ZERO, MOVE ANOTHER BYTE
	RET
;.....
;
;
NODIR:	LXI	D,NDIR
	JMP	PRINTMSG
;.....
;
;
NOCLOSE:
	LXI	D,NCLOS
	JMP	PRINTMSG
;.....
;
;
NOSOURCE:
	LXI	D,NSRC
	JMP	PRINTMSG
;.....
;
;
PRINTMSG:
	PUSH	D
	LXI	D,CRLF
	CALL	PRINT1
	POP	D
	CALL	PRINT1
	LXI	D,CRLF
	CALL	PRINT1
	JMP	EXIT
;
PRINT1:	MVI	C,PRINT
	JMP	BDOS
;.....
;
;
RSFLG:	XRA	A
	STA	CTLFLG
	STA	OKFLG
	STA	SCFLG
	JMP	CTL1
;.....
;
;
STFLG:	LDA	CTLFLG		;CONTROL-FLAG STILL SET TO ZERO?
	ORA	A
	JNZ	CTL1		;IF SET, NOT IN 1ST COLUMN, IGNORE
;
STFLG1:	MVI	A,1
	STA	CTLFLG		;SHOW NO LONGER IN 1ST COLUMN
	STA	SCFLG		;SET SEMICOLON FLAG
	JMP	CTL1
;.....
;
;
TKCHK:	LDA	OKFLG
	CMA
	STA	OKFLG
	JMP	CTL1

LSTOUT:

	PUSH	PSW
	PUSH	H
	PUSH	D
	PUSH	B

	MVI	C,5
	MOV	E,A
	CALL	5
	
	POP	B
	POP	D
	POP	H
	POP	PSW
	RET

TSTEXT:

	PUSH	PSW
	PUSH	H
	PUSH	D
	PUSH	B

	MVI	C,6
	MVI	E,0FFH
	CALL	5
	ORA	A
	JZ	FINTST
	CPI	3
	JZ	0
FINTST:
	POP	B
	POP	D
	POP	H
	POP	PSW
	RET

;.....
;
;
;
;=======================================================================
;
; MESSAGES
;
CRLF	DB	CR,LF,'$'
NDIR:	DB	'   No Directory Space Remains',CR,LF,'$'
NSRC:	DB	'   No Source File$'
WRER:	DB	'   Write Error, Disk is Full$'
NCLOS:	DB	'   Cannot Close Destination File, Directory full$'

COUNT:	DB	0
CTLFLG:	DB	0
EOFLG:	DB	0
OKFLG:	DB	0
SCFLG:	DB	0
DEST:	DB	0,'        $$$',0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0
ONAME:	DB	0,'           ',0,0,0,0,0,'        BAK',0,0,0,0
	DS	32		;STACK SPACE
BUFFER:	EQU	($+255)/256*256	;PAGE BOUNDARY
STACK:	EQU	BUFFER-2
;.....
;
;
; SYSTEM EQUATES
;
BDOS	EQU	0005H
PRINT	EQU	9
OPEN	EQU	15
DELETE	EQU	19
MAKE	EQU	22
RENAME	EQU	23
SETDMA	EQU	26
READ	EQU	20
WRITE	EQU	21
CLOSE	EQU	16
FCB	EQU	5CH		;DEFAULT FILE CONTROL BLOCK
FCB2	EQU	6CH		;SECOND DEFAULT FCB
SOURCE	EQU	FCB
;.....
;
;
	END	START
