;
;	SD monitor Version 3.00
;	Resurrected on 08/20/91
;	Restored to standard 08/26/91  04:59 pm
;
;	General equates
;
SBUFF	EQU	0FF60H		;buffer
STKTOP	EQU	0FFC0H		;stack top
BKBUFF	EQU	STKTOP+1H	;storage of original program data
BKADDR	EQU	STKTOP+4H	;breakpoint address storage
MNFLG1	EQU	STKTOP+6H	;monitor flag 1
PARMCT	EQU	STKTOP+7H	;parameters input counter
CHARIN	EQU	STKTOP+8H	;character inputted
SFFC9	EQU	STKTOP+9H	;byte storage
BUF0	EQU	STKTOP+10H	;parameter storage
BUF01	EQU	BUF0+1
BUF02	EQU	BUF0+2		;etc.
BUF04	EQU	BUF0+4
BUF05	EQU	BUF0+5
BUF06	EQU	BUF0+6
BUF08	EQU	BUF0+8
TEMPSP	EQU	BUF0+14H	;temp stack save
BRKSP	EQU	BUF0+16H	;breakpoint sp storage
;
;	The follow -> notations are used to indicate where
;	the cpu registers are stored for breakpoints
;
RSTSTK	EQU	BUF0+18H	;restore stack
;				 ->IY
SFFEA	EQU	BUF0+1AH	;->IX
SFFF4	EQU	0FFF4H		;->HL
SFFF9	EQU	0FFF9H
MNFLG0	EQU	0FFFAH		;monitor flag 0 ->I
TEMPB0	EQU	0FFFCH		;->AF
TEMPB1	EQU	0FFFDH
ADRBUF	EQU	0FFFEH		;word storage + ret addr
;
;	Bios entry points
;
WBOOTE	EQU	0F003H		;warm boot
HME	EQU	0F018H		;home vector
LDE	EQU	0F02DH		;load 'n' sectors
SVE	EQU	0F030H		;save 'n' records
FMATE	EQU	0F033H		;format vector
STDSDT	EQU	0F03FH		;start of density tables
TKSPS	EQU	0F040H		;tracks per side
;
;	Base ram equates
;
TADDR	EQU	0040H		;transfer address
UNIT	EQU	0042H		;drive select
SCTR	EQU	0043H		;sectors
TRK	EQU	0044H		;track
NREC	EQU	0045H		;number of records
ERMASK	EQU	0046H		;error mask
ERSTAT	EQU	0047H		;error status
SPSV	EQU	004DH		;stack save
CICHR	EQU	004FH		;same
;
;	Port equates
;
SELECT	EQU	063H		;disk select port
CDATA	EQU	07CH		;console data
CSTAT	EQU	07DH		;console status
;
	ORG	0E000H
;
;	Entry points
;
COLD:	JP	MCOLD
MONITR: JP	MENTRY
CSE:	JP	MCONST		;bios hooks
CIE:	JP	MCONIN
COE:	JP	MCONOT
;
MCOLD:	IN	A,(7FH) 	;clear port
	LD	HL,SBUFF
	LD	(BRKSP),HL	;set breakpoint stack
	XOR	A
	LD	(STKTOP),A	;clear stktop flag
	LD	A,4EH
	OUT	(CSTAT),A	;set serial modes
	LD	A,37H
	OUT	(CSTAT),A
	LD	A,45H
	OUT	(78H),A 	;???
	LD	A,40H
	OUT	(CSTAT),A	;more serial stuff
	LD	A,4EH
	OUT	(CSTAT),A
	LD	A,37H
	OUT	(CSTAT),A
	LD	A,0DH
	OUT	(78H),A 	;???
	LD	A,64H
MCLOOP: LD	B,0C8H
CLLOOP: DJNZ	CLLOOP		;delay for power up stabilization
	DEC	A
	JR	NZ,MCLOOP
	IN	A,(CDATA)	;clear keyboard port
	XOR	A
	LD	D,03H
WAIT0:	LD	C,A
WAIT1:	LD	B,A
WAIT2:	IN	A,(CSTAT)	;see if key input at startup
	AND	02H
	JR	NZ,CHKKIN
	DJNZ	WAIT2
	XOR	A
	DEC	C
	CP	C
	JR	NZ,WAIT1	;large delay for test of keyin
	DEC	D
	CP	D
	JR	NZ,WAIT0
DOWARM: LD	E,00H		;goto bios warmboot
	JP	WBOOTE
;
CHKKIN: IN	A,(CDATA)	;read the keyin
	CP	0DH		;return?
	JR	NZ,DOWARM	;if not then preceed to warmboot
MENTRY: XOR	A		;else clear monitor flag 0
	LD	(MNFLG0),A
	INC	A		;set monitor flag to 1
	LD	(MNFLG1),A
MONRUN: LD	SP,STKTOP	;set monitor's stack
	CALL	CRLF		;output to monitor
	LD	C,2EH		;our prompt '.'
	CALL	COE
	CALL	CHRINE		;get key with echo
	CP	2EH		;'.'?
	JR	Z,MONRUN	;restart monitor
	PUSH	BC
	CALL	SPACE		;output
	CALL	BUFINP		;get buffered parameter input
	POP	BC
	LD	A,C
	LD	HL,MONRUN	;put restart address on stack
	PUSH	HL
	LD	HL,(BUF02)	;get 2nd parameter value
	LD	DE,(BUF0)	;and 1st parameter value
	LD	IY,STKTOP	;set index Y reg
	CP	42H		;'B'?
	JR	NZ,CHGCMD
;
;	Break command
;
ISBCMD: PUSH	DE		;save 1st parameter
	LD	A,(STKTOP)	;test stacktop bit 0
	BIT	0,A
	JR	Z,BCCHPM	;brif clear
	LD	DE,(BKADDR)	;else move 3 bytes at
	LD	HL,BKBUFF	;bkbuff to breakpoint
	LD	BC,0003H	;address
	LDIR
	XOR	A
	LD	(STKTOP),A	;clear stacktop bit
BCCHPM: LD	A,(PARMCT)	;check for b command parameters
	AND	A
	POP	HL		;get 1st parameter back
	JR	Z,BCMEND	;if no parameters then back to monitor
SETBRK: LD	(BKADDR),HL	;set breakpoint address
	PUSH	HL
	LD	DE,BKBUFF
	LD	BC,0003H	;move 3 bytes at bp into buffer
	PUSH	BC
	LDIR
	LD	HL,BKPTJP	;then put out bp entry jump
	POP	BC		;into the program
	POP	DE
	LDIR
	LD	A,01H		;set stacktop bit 0 to indicate
	LD	(STKTOP),A	;that the bp is in the program
BCMEND: RET
;
;	This is the command written into
;	the breadpoint address
;
BKPTJP: JP	SAVMST
;
;	Go command
;
CHGCMD: CP	47H		;'G'?
	JR	NZ,CHRCMD
	LD	A,(PARMCT)	;test parameter count
	AND	A
	JR	Z,GCMD0 	;if 0 then use present address
	LD	(ADRBUF),DE	;else save parameter address
	POP	AF
GCMD0:	LD	A,01H		;set flag
	LD	(SFFC9),A
	JP	RESTOR		;now restore all registers and go
;
;	Read command - read a number of sectors
;
CHRCMD: CP	52H
	JR	NZ,CHWCMD
	CALL	RWSET
	JP	LDE		;load n sectors
;
;	Write command - write a number of sectors
;
CHWCMD: CP	57H
	JR	NZ,CHZCMD
	CALL	RWSET
	JP	SVE		;save n sectors
;
;	Setup the disk controller's variables
;
RWSET:	LD	A,(PARMCT)
	CP	05H
	JP	C,BADINP
	LD	(TADDR),DE	;1st parm is dma addr
	LD	A,L
	LD	HL,UNIT 	;2nd parm is unit code
	LD	(HL),A
	INC	HL
	LD	A,(BUF06)	;4th parm is sector
	LD	(HL),A
	INC	HL
	LD	A,(BUF04)	;3rd parm is track
	LD	(HL),A
	INC	HL
	LD	A,(BUF08)	;5th parm is number of sectors
	LD	(HL),A
	RET
;
;	Format command (Z) - parameter is select code
;
CHZCMD: CP	5AH
	JR	NZ,CHQCMD
	LD	A,(PARMCT)
	DEC	A		;check for one parameter only
	JP	NZ,BADINP
	LD	A,E
	LD	(UNIT),A	;parameter is unit code
	XOR	A
	LD	(TRK),A 	;track = 0
	INC	A
	LD	(SCTR),A	;sector = 1
	CALL	HME		;home the drive
ZCMD0:	IN	A,(SELECT)
	OR	50H		;set double sided/side = 0
	OUT	(SELECT),A
	CALL	FMATE		;do side 0
	CALL	CHK5_8		;see if 5 1/4" or 8" selected
	JR	Z,ZCMD1 	;if 8" then 0 only
	RES	4,A
	OUT	(SELECT),A
	CALL	FMATE		;else do side 1
ZCMD1:	CALL	BMPTRK		;next track
	JR	NZ,ZCMD0
	JP	HME		;then rehome the drive
;
;	Test for type drive
;	Returns: Zero flag set for 8"
;
CHK5_8: IN	A,(SELECT)
	BIT	5,A
	RET
;
;	Increment the track number
;	and test for last track
;
BMPTRK: LD	A,(TRK)
	INC	A
	LD	(TRK),A
	LD	B,A
	LD	A,(TKSPS)	;get tracks per sector from
	CP	B		;rom table for compare
	RET	
;
;	Query command - reads in the whole disk track by
;	track.	Can be stopped only by '.' input.  Prints
;	'P' one for each full disk read.
;
CHQCMD: CP	51H
	JR	NZ,CHMCMD
	LD	A,E		;put 1st parm into unit
	LD	(UNIT),A
QCMD0:	XOR	A
	LD	(TRK),A 	;track = 0
QCMD1:	LD	A,01H
	LD	(SCTR),A	;sector = 1
	LD	A,(STDSDT)	;get 8" sec/track
	LD	B,A
	CALL	CHK5_8		;test disk type
	JR	Z,QCMD2
	SLA	B		;double it if 5 1/4"
QCMD2:	LD	A,B
	LD	(NREC),A	;set # of records
	LD	HL,0100H
	LD	(TADDR),HL	;set dma addr
	CALL	LDE		;load in the track
	CALL	CHKPER		;see if we continue
	CALL	BMPTRK		;goto next track
	JR	NZ,QCMD1
	LD	C,50H		;'P' to console
	CALL	COE
	JR	QCMD0
;
;	Move command - Source start, source end, destination start
;
CHMCMD: CP	4DH
	JR	NZ,CHCCMD
	CALL	SBHLDE		;check to see if src end<src start
	LD	B,H		;save difference
	LD	C,L
	EX	DE,HL		;get src start ->hl
	LD	DE,(BUF04)	;get destination addr
	OR	A
	SBC	HL,DE		;if dest is in front
	JR	NC,MCMD0	;of src start
	LD	HL,(BUF04)	;else its behind
	ADD	HL,BC		;get end of dest move
	DEC	HL
	LD	D,H		;put into lddr dest reg
	LD	E,L
	LD	HL,(BUF02)	;get source end
	LDDR			;move from the back
	JR	RETRN
;
MCMD0:	LD	HL,(BUF0)	;get the src start
	LDIR			;move from the front
RETRN:	RET
;
;	Warm boot (C)
;
CHCCMD: CP	43H
	JP	Z,WBOOTE
;
CHHCMD:
	CP	48H		;check for (H) command
	JR	NZ,CHXCMD
;
;	Hex math command
;
ISHCMD: PUSH	HL
	ADD	HL,DE		;HL + DE
	LD	C,2BH		;'+'
	CALL	COE
	CALL	PRNTHL		;print addition
	CALL	SPACE
	POP	HL
	EX	DE,HL
	OR	A
	SBC	HL,DE		;HL - DE
	LD	C,2DH		;'-'
	CALL	COE
	CALL	PRNTHL		;print subtraction
	JP	MONRUN
;
;	eXamine registers command
;
CHXCMD: CP	58H
	JR	NZ,CHICMD
	XOR	A
	CP	E		;test for 0 parameters
	CALL	NZ,PRREGL	;if not print reg list header
	LD	A,(PARMCT)
	CP	02H		;if two parameters input
	JR	NZ,XCMDDO
	LD	A,(BUF02)	;get second parameter
	LD	(MNFLG1),A	;save in monitor flag 1
XCMDDO: JP	DMPLIN		;now dump line
;
;	Input command - 1st parameter is port number
;			2nd parameter is times to read port
;			If = 0 then port is read until '.' inputted
;
CHICMD: CP	49H
	JR	NZ,CHOCMD
	RES	0,(IY+10)	;clear repeat bit
	LD	A,(BUF0)
	LD	C,A		;get port to read
	LD	B,01H
	LD	A,(PARMCT)
	CP	02H		;two parameters inputted?
	JR	C,ICMD0
	LD	A,(BUF02)	;if so get 2nd parameter
	LD	B,A		;save count
	OR	A
	JR	NZ,ICMD0	;if <> 0 then b=count
	SET	0,(IY+10)	;else set endless loop bit
ICMD0:	LD	A,C
	CALL	PRHXSP		;print port number
	IN	A,(C)
	CALL	PRHXSP		;now print port data
	CALL	CHKPER		;see if break called
	PUSH	BC
	CALL	CRLF
	POP	BC
	BIT	0,(IY+10)	;see if loop forever mode set
	JR	NZ,ICMD0
	DJNZ	ICMD0		;if not, decrement the number
	RET			;of times to read and repeat
;
;	Output command - 1st value is port number
;			 2nd value is data
;			 3rd value(if present) is count
;			 If count = 0 then loop until '.' inputted
;
CHOCMD: CP	4FH
	JR	NZ,CHFCMD
	RES	0,(IY+10)	;clear repeat bit
	LD	A,(BUF0)
	LD	C,A		;get port to write
	LD	A,(BUF02)
	LD	D,A		;get data to d
	LD	B,01H
	LD	A,(PARMCT)
	CP	03H		;see if another parm inputted
	JR	C,OCMD0
	LD	A,(BUF04)
	LD	B,A		;save 3rd parm as count
	OR	A
	JR	NZ,OCMD0	;if <>0 then b is ocunt
	SET	0,(IY+10)	;else set endless loop bit
OCMD0:	OUT	(C),D		;send data
	CALL	CHKPER		;see if break called
	BIT	0,(IY+10)
	JR	NZ,OCMD0	;if endless loop bit set
	DJNZ	OCMD0		;else decrement count
	RET			;finish when 0
;
;	Fill command - start addr, endaddr, fill byte
;
CHFCMD: CP	46H
	JR	NZ,CHLCMD
	LD	A,(BUF04)	;get fill byte
	PUSH	HL
	CALL	SBHLDE		;ensure end addr<start addr
	POP	HL
FCMD0:	LD	(DE),A		;put in fill byte
	PUSH	HL
	OR	A
	SBC	HL,DE		;end addr - fill addr
	POP	HL
	INC	DE		;bump to next location
	JR	NZ,FCMD0	;repeat until filled
	RET
;
;   ????List command????
;
CHLCMD: CP	4CH
	JR	NZ,CHVCMD
	CALL	SBHLDE
	LD	A,(PARMCT)
	SUB	03H		;ensure we have 3 or
	JP	C,BADINP	;more parameters
	LD	B,A		;save excess
	INC	A		;bump one for parm count
	LD	(PARMCT),A
	LD	HL,BUF05	;high byte of 3rd parameter
	LD	DE,BUF06	;4th parameter
LCMD0:	LD	A,(DE)		;get data
	LD	(HL),A		;move it
	INC	HL		;bump pointersw
	INC	DE
	INC	DE		;de=de+2
	DJNZ	LCMD0
LCMD1:	LD	A,(PARMCT)
	LD	B,A
	LD	HL,(BUF0)
	LD	DE,BUF04
LCMD2:	LD	A,(DE)
	CP	(HL)
	JR	NZ,LCMD3
	INC	HL
	INC	DE
	DJNZ	LCMD2
	LD	HL,(BUF0)
	CALL	PRNTHL
	CALL	CRLF
	CALL	CHKPER		;see if break called
LCMD3:	LD	HL,(BUF02)
	LD	DE,(BUF0)
	OR	A
	SBC	HL,DE
	RET	Z
	INC	DE
	LD	(BUF0),DE
	JR	LCMD1
;
;	Verify command - start addr, end addr, verify addr
;
CHVCMD: CP	56H
	JR	NZ,CHTCMD
	CALL	SBHLDE		;ensure end addr<start addr
	PUSH	HL
	POP	BC		;difference to be
	EX	DE,HL		;get starting addr
	LD	DE,(BUF04)	;get verify addr
VCMD0:	LD	A,(DE)		;get data
	CPI			;check for match
	INC	DE		;bump verify addr
	JR	NZ,VCMD1	;brif on nonmatch
	RET	PO		;finish on end of verify
	JR	VCMD0		;else next location
;
VCMD1:	PUSH	AF
	PUSH	BC
	PUSH	DE
	DEC	HL
	CALL	PRNTHL		;put out error address
	LD	A,(HL)
	INC	HL
	CALL	PRHXSP		;print buffer data
	POP	DE
	PUSH	DE
	PUSH	HL
	EX	DE,HL
	DEC	HL
	CALL	PRNTHL		;put out verify address
	LD	A,(HL)
	CALL	PRHASC		;print verify data
	CALL	CRLF
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	RET	PO		;finish if ending address reached
	CALL	CHKPER		;check for break
	JR	VCMD0		;if more then do next location
;
;   ????T command?????
;
CHTCMD: CP	54H
	JR	NZ,CHDCMD
	EX	DE,HL
	INC	DE		;bump 1st parameter
	LD	B,00H
TCMD0:	LD	HL,(BUF0)	;retrieve 1st parameter
TCMD1:	LD	A,L
	XOR	H		;h exor l
	XOR	B		;exor w/b
	LD	(HL),A		;save in buf 0
	INC	HL		;bump to buf 1
	PUSH	HL
	OR	A
	SBC	HL,DE
	POP	HL
	JR	NZ,TCMD1
	LD	HL,(BUF0)	;get base of buffer
TCMD2:	LD	A,L
	XOR	H		;h exor l
	XOR	B		;exor w/b
	CP	(HL)		;compare
	CALL	NZ,TCMD3	;if differece
	INC	HL
	PUSH	HL
	OR	A
	SBC	HL,DE
	POP	HL
	JR	NZ,TCMD2
	INC	B
	CALL	CHKPER		;check for break
	LD	C,50H
	CALL	COE		;send 'P' to console
	JR	TCMD0
;
TCMD3:	PUSH	AF
	CALL	PRNTHL		;print word value
	POP	AF
	CALL	PRHXSP		;print hex
	LD	A,(HL)
	CALL	PRHXSP		;get (hl) and print
	JP	CRLF
;
;	Dump command - start addr, end addr
;
CHDCMD: CP	44H
	JR	NZ,CHECMD
	RES	0,(IY+10)	;clear ending line bit
	EX	DE,HL		;hl is starting addr
	LD	A,(PARMCT)
	CP	02H		;see if ending addr inputted
	JR	NC,DCMD1
DCMD0:	LD	DE,00FFH	;if not then default dump is 0100h
	PUSH	HL
	ADD	HL,DE
	LD	(BUF02),HL	;save dump end addr
	POP	HL
DCMD1:	CALL	CRLF
	PUSH	HL
	POP	BC		;starting addr into bc
	PUSH	HL
	LD	HL,(BUF02)	;get end addr
	OR	A
	SBC	HL,BC		;ensure end addr<start addr
	JP	C,BADINP	;difference in hl
	LD	BC,000FH	;check for one line
	OR	A
	SBC	HL,BC		;(diffenence-one line)
	LD	B,10H
	JR	Z,DCMD2 	;if it is then count is set
	JP	NC,DCMD3	;skip if > one line
	LD	A,L		;else get neg result
	ADD	A,B		;add to get difference bck
	LD	B,A		;and use for count
DCMD2:	SET	0,(IY+10)	;set ending line bit
DCMD3:	POP	HL
	PUSH	BC
	CALL	PRNTHL		;print address
	POP	BC
	CALL	DMPDAT		;dump a line of data
	CALL	CHKPER		;check for break
	BIT	0,(IY+10)	;was this the last line
	JR	Z,DCMD1
DCMD4:	CALL	CIE		;if so then
	CP	2EH		;'.' input?
	RET	Z
	CP	20H		;' ' input?
	JR	NZ,DCMD4
	RES	0,(IY+10)	;if ' ' then reset end line bit
	CALL	CRLF		;goto next line
	JR	DCMD0		;and contiune
;
;	Examine memory command
;
CHECMD: CP	45H
	JR	NZ,CHPCMD
	EX	DE,HL
ECMD0:	CALL	PRNTHL		;print examine address
	LD	A,(HL)
	CALL	PRHASC		;print contents
	LD	C,2DH		;'-'
	CALL	COE
	PUSH	HL
	CALL	BUFINP		;read in value
	POP	HL
	LD	A,(CHARIN)
	CP	2EH		;'.' inputted?
	RET	Z
	LD	A,(PARMCT)
	AND	03H		;was 3 parameters input?
	JR	Z,ECMD2
	LD	A,(BUF0)	;put value into memory
	LD	(HL),A
	INC	HL		;bump examine address
	LD	A,(CHARIN)
	CP	0DH		;if last char in was CR
	JR	Z,ECMD0 	;do next examine address
ECMD1:	DEC	HL		;else point to same addr
	JR	ECMD0		;and repeat
;
ECMD2:	LD	A,(CHARIN)
	CP	5EH		;'^' inputted?
	JR	Z,ECMD1 	;if so then decrease addr
	INC	HL		;else bump examine addr
	JR	ECMD0
;
;	Port(s) read command
;
CHPCMD: CP	50H
	JR	NZ,CHSCMD
	LD	A,(BUF0)
	LD	C,A		;1st parameter save
PCMD0:	LD	A,C
	CALL	PRHXSP		;print it
	IN	A,(C)		;read port
	CALL	PRHXSP		;print it
	PUSH	BC
	CALL	BUFINP		;read input
	POP	BC
	LD	A,(CHARIN)
	CP	2EH		;'.' inputted?
	RET	Z
	LD	H,A
	LD	A,(PARMCT)
	AND	A		;see if no parameters inputted?
	JR	Z,PCMD2
	LD	A,(BUF0)
	OUT	(C),A		;else send value inputted
	LD	A,5EH
	CP	H		;'^' inputted?
	JR	Z,PCMD0 	;if so then repeat
PCMD1:	INC	C		;else bump port value
	JR	PCMD0		;and repeat
;
PCMD2:	LD	A,5EH
	CP	H		;'^' inputted with no parms?
	JR	NZ,PCMD1	;if not then bump port and repeat
	DEC	C		;else decrease port number
	JR	PCMD0		;and repeat
CHSCMD: CP	53H
	JR	Z,ISSCMD	;match on 'S' input
;
;	Bad input handler
;
BADINP: LD	C,3FH		;'?' to console
	CALL	COE
	JP	MONRUN
;
;   ????S command????
;
ISSCMD: POP	AF
	CALL	PRREGL		;print register list
	LD	A,(PARMCT)
	AND	A		;check for no parm input
	JR	Z,SCMD0
	EX	DE,HL
	LD	(ADRBUF),HL	;save 1st parameter
SCMD0:	LD	A,(BUF02)	;get 2nd parameter
	AND	A
	JR	NZ,SCMD1
	INC	A		;if 0 then force to one
SCMD1:	LD	(SFFC9),A	;save it
	XOR	A
	LD	(PARMCT),A	;clear parameter count
	CALL	ISBCMD		;set breakpoint up
	LD	DE,(ADRBUF)
	LD	A,(DE)
	CP	40H
	JR	C,SCMD2
	CP	0C0H
	JP	C,SCMD20
SCMD2:	AND	03H
	LD	B,A
	LD	A,(DE)
	RRA
	RRA
	AND	1FH
	PUSH	BC
	LD	BC,SCDTB1
	ADD	A,C
	LD	L,A
	LD	H,B
	POP	BC
	LD	A,(HL)
	INC	B
SCMD3:	DJNZ	SHRA2
	AND	03H
	JP	Z,SCMD19
	PUSH	AF
	LD	A,(DE)
	LD	HL,(SFFF4)
	CP	0E9H
	JP	Z,SVMEND
	CP	0C3H
	JR	Z,SCMD15
	CP	0CDH
	JR	Z,SCMD15
	CP	0C9H
	JR	Z,SCMD14
	CP	10H
	JR	NZ,SCMD5
	LD	HL,SFFF9
	DEC	(HL)
	JR	NZ,SCMD11
	INC	(HL)
SCMD4:	JP	SCMD25

SHRA2:	SRL	A
	SRL	A
	JR	SCMD3
;
SCMD5:	CP	18H
	JR	Z,SCMD11
	CP	80H
	JR	NC,SCMD6
	XOR	20H
	LD	B,A
	AND	67H
	JR	NZ,SCMD4
	LD	A,B
	JR	SCMD8
;
SCMD6:	AND	0C7H
	CP	0C2H
	JR	Z,SCMD7
	AND	0C3H
	CP	0C0H
	JR	NZ,SCMD16
SCMD7:	LD	A,(DE)
SCMD8:	AND	30H
	LD	HL,SCDTB2
SCMD9:	INC	HL
	SUB	10H
	JR	NC,SCMD9
	LD	A,(TEMPB0)
	AND	(HL)
	LD	A,(DE)
	JR	Z,SCMD10
	CPL
SCMD10: BIT	3,A
	JR	NZ,SCMD4
	POP	AF
	PUSH	AF
	CP	02H
	JR	C,SCMD14
	JR	NZ,SCMD15
SCMD11: INC	DE
	LD	A,(DE)
	INC	DE
	LD	L,A
	RLA	
	LD	H,00H
	JR	NC,SCMD12
	DEC	H
SCMD12: ADD	HL,DE
	JR	SCMD18
;
SCMD13: DEC	DE
SCMD14: LD	HL,(BRKSP)
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	JR	SCMD28
;
SCMD15: LD	A,(DE)
	BIT	2,A
	INC	DE
	LD	A,(DE)
	LD	L,A
	INC	DE
	LD	A,(DE)
	LD	H,A
	JR	NZ,SCMD28
	JR	SCMD18
;
SCMD16: LD	A,(DE)
	AND	0C7H
	CP	0C7H
	LD	A,(DE)
	JR	NZ,SCMD17
	AND	38H
	LD	L,A
	LD	H,00H
	JR	SCMD28
;
SCMD17: CP	0FBH
	JR	NZ,SCMD25
	CPL
	LD	(MNFLG0),A
	EX	DE,HL
	INC	HL
SCMD18: JP	SVMEND
;
SCMD19: LD	A,(DE)
	INC	DE
	CP	0EDH
	JR	NZ,SCMD21
	LD	B,03H
	LD	A,(DE)
	AND	0F7H
	CP	45H
	JR	Z,SCMD13
	AND	0C7H
	CP	43H
	JR	Z,SCMD26
SCMD20: LD	B,01H
	JR	SCMD26
;
SCMD21: CP	0DDH
	LD	HL,(SFFEA)
	JR	Z,SCMD22
	LD	HL,(RSTSTK)
SCMD22: LD	A,(DE)
	CP	0E9H
	JR	Z,SCMD18
	LD	HL,SCDTB0	;get table start
	LD	BC,0005H
	CPIR			;compare against 1st 5 entries
	JR	NZ,SCMD29
	INC	B
SCMD23: INC	B
SCMD24: INC	B
	PUSH	BC
SCMD25: POP	BC
SCMD26: EX	DE,HL
SCMD27: INC	HL
	DJNZ	SCMD27
SCMD28: CALL	SETBRK
	JP	RESTOR
;
SCMD29: AND	0FEH
	CP	34H
	JR	Z,SCMD23
	LD	A,(DE)
	AND	07H
	CP	06H
	JR	Z,SCMD23
	LD	A,(DE)
	AND	0F8H
	CP	70H
	JR	Z,SCMD23
	JR	SCMD24
;
;	Tables are used in conjunction with
;	what seems to be some type of code checking
;
SCDTB0: DEFB	21H,22H,2AH,36H 	;!"*6
	DEFB	0CBH			;K
SCDTB1: DEFB	5DH,65H,55H,65H 	;]eUe
	DEFB	5EH,65H,56H,65H 	;^eVe
	DEFB	7EH,65H,76H,65H 	;~eve
	DEFB	7EH,65H,76H,65H 	;~eve
	DEFB	0F5H,67H,0B5H,6FH	;ug5o
	DEFB	0B5H,67H,0B5H,63H	;5g5c
	DEFB	75H,67H,75H,63H 	;uguc
	DEFB	75H,67H,75H		;ugu
SCDTB2: DEFB	63H,40H,01H,04H 	;c@..
	DEFB	80H			;.
;
;	Test for char being input and
;	restart monitor if '.'
;
CHKPER: CALL	CSE
	RET	Z
	CALL	CIE
	CP	2EH
	RET	NZ
	JP	MONRUN
;
;	(hl-de) will be returned if >0
;	else bad input is jumped to
;
SBHLDE: OR	A
	SBC	HL,DE
	JP	C,BADINP
	INC	HL
	RET
;
;	Save the whole machine state
;
SAVMST: LD	(BRKSP),SP	;save break stack
	LD	SP,0000H	;set stack for top of memory pushes
	PUSH	AF		;(fffe) <- return pc
	PUSH	AF		;(fffc) <- af
	OR	A
	LD	A,I
	PUSH	AF		;(fffb) <- i, (fffa) = mnflg0
	DI
	PUSH	BC		;(fff8) <- bc
	PUSH	DE		;(fff6) <- de
	PUSH	HL		;(fff4) <- hl
	EXX
	EX	AF,AF'
	PUSH	AF		;(fff2) <- af'
	PUSH	BC		;(fff0) <- bc'
	PUSH	DE		;(ffee) <- de'
	PUSH	HL		;(ffec) <- hl'
	LD	A,(MNFLG0)
	AND	04H		;strip bit 2 in mon. flag 0
	LD	(MNFLG0),A
	EXX
	EX	AF,AF'
	PUSH	IX		;(ffea) <- ix
	PUSH	IY		;(ffe8) <- iy
	LD	HL,BKBUFF
	LD	DE,(BKADDR)
	LD	BC,0003H
	LDIR			;restore original 3 bytes
	LD	HL,(BKADDR)
SVMEND: LD	A,80H
	LD	(STKTOP),A	;set bit 7 of stktop
	LD	(ADRBUF),HL	;put break addr -> (fffe)
	LD	SP,STKTOP	;reset stack
	JR	PRRLIN
;
;	Restore the machine state stacked from save
;
RESTOR: LD	SP,(BRKSP)	;get the break stack back
	LD	HL,(ADRBUF)	;break address -> stack
	PUSH	HL
	LD	HL,(TEMPB0)	;get af -> stack
	PUSH	HL
	LD	(TEMPSP),SP	;save present stack
	LD	SP,RSTSTK	;get restore stack base
	POP	IY		;(ffe8) -> iy
	POP	IX		;(ffea) -> ix
	EXX
	EX	AF,AF'
	POP	HL		;(ffec) -> hl'
	POP	DE		;(ffee) -> de'
	POP	BC		;(fff0) -> bc'
	POP	AF		;(fff2) -> af'
	EXX
	EX	AF,AF'
	POP	HL		;(fff4) -> hl
	POP	DE		;(fff6) -> de
	POP	BC		;(fff8) -> bc
	POP	AF		;(fffa) -> i
	LD	I,A
	LD	SP,(TEMPSP)	;restore break stack
	JP	PE,RETWEI	;and allow interrupts if on
	POP	AF		;(fffc) -> af
	DI			;else shut them off
	RET			;(fffe) -> pc
;
RETWEI: POP	AF		;(fffc) -> af
	EI
	RET			;(fffe) -> pc
;
PRRLIN: CALL	DMPLIN
	LD	A,(STKTOP)
	LD	B,A
	XOR	A
	LD	(STKTOP),A
	LD	HL,SFFC9
	DEC	(HL)
	JR	Z,PRRCTL
	CALL	CSE
	JR	NZ,PRRCTL
	JR	PCLF0
;
;	Print register control check
;
PRRCTL: CALL	CHRINE
	CP	2EH
	JP	Z,MONRUN	;'if '.'
	CP	0DH
	JR	Z,PRRCLF	;if cr
	CP	20H
	JR	NZ,PRRCTL	;if not space
	XOR	A
	CP	(HL)
	LD	(HL),00H
	JR	NZ,PRRCTL	;loop if first time thru
	CALL	CRLF		;print crlf out
	CALL	PRREGL		;print out register labels
	LD	A,0BH
	JP	SCMD1
;
PRRCLF: LD	(HL),01H
PCLF0:	CALL	CRLF
	LD	A,(HL)
	JP	SCMD1
;
;	Dump line
;
DMPLIN: LD	HL,(ADRBUF)	;get address to dump
	CALL	PRNTHL		;print it
	LD	A,(MNFLG1)
	RRA			;test bit 0 mon. flag 1
	LD	B,01H
	JR	NC,DMPLN0	;do one line if bit 0 clear
	LD	B,0CH		;else do twelve
DMPLN0: LD	HL,TEMPB1
DLINLP: LD	A,(HL)		;get byte
	CALL	PRHASC		;print it
	DEC	HL		;back one
	LD	A,(HL)		;get byte
	CALL	PRHXSP		;print it with space
	DEC	HL		;back one
	DJNZ	DLINLP		;count-1
	RET
;
;	Dump data - made to dump a line of data followed
;	by ascii representation of bytes
;
DMPDAT: PUSH	BC
	PUSH	HL
DDAT0:	LD	A,(HL)		;get data
	CALL	PRHXSP		;print it
	INC	HL		;bump pointer
	DJNZ	DDAT0		;repeat count in b
	CALL	SPACE
	CALL	SPACE
	POP	HL
	POP	BC
DDTASC: LD	A,(HL)		;get data again
	AND	7FH		;strip upper bit
	LD	C,A
	CP	20H		;if <20h then use '.'
	JR	C,PUTPER
	CP	7BH		;if <7bh then print data
	JR	C,DDTA0
PUTPER: LD	C,2EH		;put '.' out
DDTA0:	CALL	COE
	INC	HL		;increment pointer
	DJNZ	DDTASC
	RET
;
REGLST: DEFB	" PC "
	DEFB	" AF "
	DEFB	" I "
	DEFB	" IF "
	DEFB	" BC "
	DEFB	" DE "
	DEFB	" HL "
	DEFB	" AF' "
	DEFB	" BC' "
	DEFB	" DE' "
	DEFB	" HL' "
	DEFB	" IX "
	DEFB	" IY "
	DEFB	" SP",0DH,0AH
	DEFB	03H
;
;	Console status check
;
MCONST: IN	A,(CSTAT)
	AND	02H
	RET	Z
	LD	A,0FFH
	RET
;
;	Console input
;
MCONIN: CALL	MCONST
	JR	Z,MCONIN
	IN	A,(CDATA)
	AND	7FH
	RET
;
;	Console output
;
MCONOT: IN	A,(CSTAT)
	AND	01H
	JR	Z,MCONOT
	LD	A,C
	OUT	(CDATA),A
	RET
;
;	Print a as two ascii hex digits, then adds a space
;
PRHXSP: PUSH	BC
	CALL	PRHASC
	CALL	SPACE
	POP	BC
	RET
;
;	Garbage
;
	DEFB	28h,15h,10h,18h
	DEFB	11h,2bh,0b4h,06h
	DEFB	1fh,7eh,0feh,0dh
	DEFB	20h,02h,2bh,3eh
;
;	Send a CR, LF to the console
;
CRLF:	LD	C,0DH
	CALL	COE
	LD	C,0AH
	JP	COE
;
;	Send a SP to the console
;
SPACE:	LD	C,20H
	JP	COE
;
;	Print out the register labels AF BC etc.
;
PRREGL: LD	HL,REGLST	;get start of msg field
PRLOOP: LD	A,(HL)
	CP	03H		;print til found
	RET	Z
	LD	C,A
	CALL	COE
	INC	HL
	JR	PRLOOP
;
	DEC	B		;????
;
;	Print hex contents of a as 2 ascii chars
;
PRHASC: PUSH	AF
	RRCA			;get high nybble
	RRCA			;into low nybble
	RRCA
	RRCA
	CALL	PRHAS0
	POP	AF
PRHAS0: AND	0FH		;strip low nybble
	ADD	A,90H
	DAA			;old trick for bin to asc
	ADC	A,40H
	DAA
	LD	C,A
	JP	COE
;
;	Convert ascii hex char to binary nybble
;
HEXTBI: SUB	30H
	CP	0AH
	RET	M
	SUB	07H
	RET
;
;	Test for valid ascii hex char, returns 0 if found
;
ISHEX:	CP	30H
	JR	C,ISHEXF
	CP	3AH
	JR	C,ISHEXT
	CP	40H
	JR	C,ISHEXF
	CP	47H
	JR	NC,ISHEXF
ISHEXT: XOR	A
	RET
;
;	Return 1 if not valid ascii hex
;
ISHEXF: XOR	A
	INC	A
	RET
;
;	Check control input
;
CKCTLI: CP	20H		;' ' input?
	RET	Z
	CP	5EH		;'^' input?
	JR	Z,STCRLF
	CP	2EH		;'.' input?
	JP	Z,MONRUN
	CP	0DH		;CR input?
	RET	NZ
STCRLF: PUSH	BC
	CALL	CRLF
	POP	BC
	XOR	A		;set Z flag
	RET
;
	DEFB	0dah,16h,7bh,3eh
	DEFB	00
;
;	Use hl for possible numeric input
;
RDINPT: LD	HL,0000H
	LD	B,L
GETINP: CALL	CHRINE		;get a char
	INC	B
	CALL	CKCTLI		;is it a control char input
	RET	Z
	CALL	ISHEX		;if not then is it a hex digit
	RET	NZ
;
;	hex input shift over and add in
;
	LD	A,C
	CALL	HEXTBI
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	A,L
	LD	L,A
	JR	GETINP
;
;	Get a character from the console,
;	then echo it
;
CHRINE: CALL	CIE
	LD	C,A
	JP	COE
;
;	Buffer input - puts command parameters into BUF0
;	in word sequence.  Each parameter must be followed
;	by a space to be considered valid.
;
;
BUFINP: XOR	A
	LD	HL,BUF0 	;clear parameter buffer
	PUSH	HL
	POP	IX
	LD	(HL),A
	LD	BC,0009H
	LD	DE,BUF01
	LDIR
	LD	(PARMCT),A	;reset parameter count
INTINP: CALL	RDINPT		;get input
	JP	NZ,BADINP
	LD	A,C
	LD	(CHARIN),A	;save a copy of last char in
	CP	20H
	JR	Z,SPINP 	;if its a ' ' then save parameter
	DEC	B
	RET	Z		;if counter reached 0
;
;	Save last hex inputted in buf0
;
SPINP:	LD	(IX+0),L
	LD	(IX+1),H
	LD	A,(PARMCT)
	INC	A		;bump parameter count
	LD	(PARMCT),A
	INC	IX		;to next word location
	INC	IX
	LD	A,C
	CP	20H
	JR	Z,INTINP	;continue input if ' ' was last char
	RET
;
;	Print HL out as four hex digits
;
PRNTHL: LD	A,H
	CALL	PRHASC
	LD	A,L
	JP	PRHXSP
;
	DEFB	0ffh
;
	END
 char
	RET
;
;	Print HL out as four hex digits
;
PRNTHL: LD	A,H
	CALL	PRHASC
	LD	A,L
	JP	PRHXSP
;
	d