;
;	SD monitor Version 2.10
;	Resurrected on 08/29/91
;	Restored to standard 09/04/91  11:59 pm
;
;	General equates
;
SBUFF	EQU	0FF60H		;buffer
STKTOP	EQU	0FFC0H		;stack top
BKBUFF	EQU	STKTOP+1H	;storage of original program data
BKADDR	EQU	STKTOP+4H	;breakpoint address storage
MNFLG1	EQU	STKTOP+6H	;monitor flag 1
PARMCT	EQU	STKTOP+7H	;parameters input counter
CHARIN	EQU	STKTOP+8H	;character inputted
SFFC9	EQU	STKTOP+9H	;byte storage
BUF0	EQU	STKTOP+10H	;parameter storage
BUF01	EQU	BUF0+1
BUF02	EQU	BUF0+2		;etc.
BUF04	EQU	BUF0+4
BUF05	EQU	BUF0+5
BUF06	EQU	BUF0+6
BUF08	EQU	BUF0+8
TEMPSP	EQU	BUF0+14H	;temp stack save
BRKSP	EQU	BUF0+16H	;breakpoint sp storage
;
;	The follow -> notations are used to indicate where
;	the cpu registers are stored for breakpoints
;
RSTSTK	EQU	BUF0+18H	;restore stack
;				 ->IY
SFFEA	EQU	BUF0+1AH	;->IX
SFFF4	EQU	0FFF4H		;->HL
SFFF9	EQU	0FFF9H
MNFLG0	EQU	0FFFAH		;monitor flag 0 ->I
TEMPB0	EQU	0FFFCH		;->AF
TEMPB1	EQU	0FFFDH
ADRBUF	EQU	0FFFEH		;word storage + ret addr
;
;	Bios entry points
;
WBOOTE	EQU	0F003H		;warm boot
HME	EQU	0F018H		;home vector
LDE	EQU	0F02DH		;load 'n' sectors
SVE	EQU	0F030H		;save 'n' records
FMATE	EQU	0F033H		;format vector
STDSDT	EQU	0F03FH		;start of density tables
TKSPS	EQU	0F040H		;tracks per side
;
;	Base ram equates
;
TADDR	EQU	0040H		;transfer address
UNIT	EQU	0042H		;drive select
SCTR	EQU	0043H		;sectors
TRK	EQU	0044H		;track
NREC	EQU	0045H		;number of records
ERMASK	EQU	0046H		;error mask
ERSTAT	EQU	0047H		;error status
SPSV	EQU	004DH		;stack save
CICHR	EQU	004FH		;same
;
;	Port equates
;
SELECT	EQU	063H		;disk select port
CDATA	EQU	01H		;console data
CSTAT	EQU	00H		;console status
;
	ORG	0E000H
;
;	Entry points
;
COLDST: JP	MCOLD
MONITR: JP	MENTRY
CSE:	JP	MCONST
CIE:	JP	MCONIN
COE:	JP	MCONOT

MCOLD:	IN	A,(7FH)
	LD	HL,SBUFF
	LD	(BRKSP),HL
	XOR	A
	LD	(STKTOP),A
	LD	A,4EH
	OUT	(CSTAT),A
	LD	A,37H
	OUT	(CSTAT),A
	LD	A,05H
	OUT	(78H),A
	LD	A,01H
	OUT	(78H),A
	IN	A,(CSTAT)
MENTRY: XOR	A
	LD	(MNFLG0),A
	LD	A,01H
	LD	(MNFLG1),A
MONRUN: LD	SP,STKTOP
	CALL	CRLF
	LD	C,2EH
	CALL	COE
	CALL	CHRINE
	CP	2EH
	JR	Z,MONRUN
	PUSH	BC
	CALL	SPACE
	CALL	BUFINP
	POP	BC
	LD	A,C
	LD	HL,MONRUN
	PUSH	HL
	LD	HL,(BUF02)
	LD	DE,(BUF0)
	LD	IY,STKTOP
	CP	42H
	JR	NZ,CHGCMD
ISBCMD: PUSH	DE
	LD	A,(STKTOP)
	BIT	0,A
	JR	Z,BCCMPM
	LD	DE,(BKADDR)
	LD	HL,BKBUFF
	LD	BC,0003H
	LDIR	
	XOR	A
	LD	(STKTOP),A
BCCMPM: LD	A,(PARMCT)
	AND	A
	POP	HL
	JR	Z,BCMEND
SETBRK: LD	(BKADDR),HL
	PUSH	HL
	LD	DE,BKBUFF
	LD	BC,0003H
	PUSH	BC
	LDIR	
	LD	HL,BKPTJP
	POP	BC
	POP	DE
	LDIR	
	LD	A,01H
	LD	(STKTOP),A
BCMEND: RET	
BKPTJP: JP	SAVMST

CHGCMD: CP	47H
	JR	NZ,CHRCMD
	LD	A,(PARMCT)
	AND	A
	JR	Z,GCMD0
	LD	(ADRBUF),DE
	POP	AF
GCMD0:	LD	A,01H
	LD	(SFFC9),A
	JP	RESTOR

CHRCMD: CP	52H
	JR	NZ,CHWCMD
	CALL	RWSET
	JP	LDE

CHWCMD: CP	57H
	JR	NZ,CHZCMD
	CALL	RWSET
	JP	SVE

RWSET:	LD	A,(PARMCT)
	CP	05H
	JP	C,BADINP
	LD	(TADDR),DE
	LD	A,L
	LD	(UNIT),A
	LD	A,(BUF04)
	LD	(TRK),A
	LD	A,(BUF06)
	LD	(SCTR),A
	LD	A,(BUF08)
	LD	(NREC),A
	RET	

CHZCMD: CP	5AH
	JR	NZ,CHQCMD
	LD	A,(PARMCT)
	DEC	A
	JP	NZ,BADINP
	LD	A,E
	LD	(UNIT),A
	XOR	A
	LD	(TRK),A
	INC	A
	LD	(SCTR),A
	CALL	HME
ZCMD0:	IN	A,(SELECT)
	OR	50H
	OUT	(SELECT),A
	CALL	FMATE
	CALL	CHK5_8
	JR	Z,ZCMD1
	RES	4,A
	OUT	(SELECT),A
	CALL	FMATE
ZCMD1:	CALL	BMPTRK
	JR	NZ,ZCMD0
	JP	HME

CHK5_8: IN	A,(SELECT)
	BIT	5,A
	RET	

BMPTRK: LD	A,(TRK)
	INC	A
	LD	(TRK),A
	LD	B,A
	LD	A,(TKSPS)
	CP	B
	RET	

CHQCMD: CP	51H
	JR	NZ,CHMCMD
	LD	A,E
	LD	(UNIT),A
QCMD0:	XOR	A
	LD	(TRK),A
QCMD1:	LD	A,01H
	LD	(SCTR),A
	LD	A,(STDSDT)
	LD	B,A
	CALL	CHK5_8
	JR	Z,QCMD2
	SLA	B
QCMD2:	LD	A,B
	LD	(NREC),A
	LD	HL,0100H
	LD	(TADDR),HL
	CALL	LDE
	CALL	CHKPER
	CALL	BMPTRK
	JR	NZ,QCMD1
	LD	C,50H
	CALL	COE
	JR	QCMD0

CHMCMD: CP	4DH
	JR	NZ,CHCCMD
	CALL	SBHLDE
	LD	B,H
	LD	C,L
	EX	DE,HL
	LD	DE,(BUF04)
	OR	A
	SBC	HL,DE
	JR	NC,MCMD0
	LD	HL,(BUF04)
	ADD	HL,BC
	DEC	HL
	LD	D,H
	LD	E,L
	LD	HL,(BUF02)
	LDDR	
	JR	RETRN

MCMD0:	LD	HL,(BUF0)
	LDIR	
RETRN:	RET	

CHCCMD: CP	43H
	JP	Z,WBOOTE
CHHCMD: CP	48H
	JR	NZ,CHXCMD
	PUSH	HL
	ADD	HL,DE
	LD	C,2BH
	CALL	COE
	CALL	PRNTHL
	CALL	SPACE
	POP	HL
	EX	DE,HL
	OR	A
	SBC	HL,DE
	LD	C,2DH
	CALL	COE
	CALL	PRNTHL
	JP	MONRUN

CHXCMD: CP	58H
	JR	NZ,CHICMD
	XOR	A
	CP	E
	CALL	NZ,PRREGL
	LD	A,(PARMCT)
	CP	02H
	JR	NZ,XCMD0
	LD	A,(BUF02)
	LD	(MNFLG1),A
XCMD0:	JP	DMPLIN

CHICMD: CP	49H
	JR	NZ,CHOCMD
	RES	0,(IY+10)
	LD	A,(BUF0)
	LD	C,A
	LD	B,01H
	LD	A,(PARMCT)
	CP	02H
	JR	C,ICMD0
	LD	A,(BUF02)
	LD	B,A
	OR	A
	JR	NZ,ICMD0
	SET	0,(IY+10)
ICMD0:	LD	A,C
	CALL	PRHXSP
	IN	A,(C)
	CALL	PRHXSP
	CALL	CHKPER
	PUSH	BC
	CALL	CRLF
	POP	BC
	BIT	0,(IY+10)
	JR	NZ,ICMD0
	DJNZ	ICMD0
	RET	

CHOCMD: CP	4FH
	JR	NZ,CHFCMD
	RES	0,(IY+10)
	LD	A,(BUF0)
	LD	C,A
	LD	A,(BUF02)
	LD	D,A
	LD	B,01H
	LD	A,(PARMCT)
	CP	03H
	JR	C,OCMD0
	LD	A,(BUF04)
	LD	B,A
	OR	A
	JR	NZ,OCMD0
	SET	0,(IY+10)
OCMD0:	OUT	(C),D
	CALL	CHKPER
	BIT	0,(IY+10)
	JR	NZ,OCMD0
	DJNZ	OCMD0
	RET	

CHFCMD: CP	46H
	JR	NZ,CHLCMD
	LD	A,(BUF04)
	PUSH	HL
	CALL	SBHLDE
	POP	HL
FCMD0:	LD	(DE),A
	PUSH	HL
	OR	A
	SBC	HL,DE
	POP	HL
	INC	DE
	JR	NZ,FCMD0
	RET	

CHLCMD: CP	4CH
	JR	NZ,CHVCMD
	CALL	SBHLDE
	LD	A,(PARMCT)
	SUB	03H
	JP	C,BADINP
	LD	B,A
	INC	A
	LD	(PARMCT),A
	LD	HL,BUF05
	LD	DE,BUF06
LCMD0:	LD	A,(DE)
	LD	(HL),A
	INC	HL
	INC	DE
	INC	DE
	DJNZ	LCMD0
LCMD1:	LD	A,(PARMCT)
	LD	B,A
	LD	HL,(BUF0)
	LD	DE,BUF04
LCMD2:	LD	A,(DE)
	CP	(HL)
	JR	NZ,LCMD3
	INC	HL
	INC	DE
	DJNZ	LCMD2
	LD	HL,(BUF0)
	CALL	PRNTHL
	CALL	CRLF
	CALL	CHKPER
LCMD3:	LD	HL,(BUF02)
	LD	DE,(BUF0)
	OR	A
	SBC	HL,DE
	RET	Z
	INC	DE
	LD	(BUF0),DE
	JR	LCMD1

CHVCMD: CP	56H
	JR	NZ,CHTCMD
	CALL	SBHLDE
	PUSH	HL
	POP	BC
	EX	DE,HL
	LD	DE,(BUF04)
VCMD0:	LD	A,(DE)
	CPI	
	INC	DE
	JR	NZ,VCMD1
	RET	PO
	JR	VCMD0

VCMD1:	PUSH	AF
	PUSH	BC
	PUSH	DE
	DEC	HL
	CALL	PRNTHL
	LD	A,(HL)
	INC	HL
	CALL	PRHXSP
	POP	DE
	PUSH	DE
	PUSH	HL
	EX	DE,HL
	DEC	HL
	CALL	PRNTHL
	LD	A,(HL)
	CALL	PRHASC
	CALL	CRLF
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	RET	PO
	CALL	CHKPER
	JR	VCMD0

CHTCMD: CP	54H
	JR	NZ,CHDCMD
	EX	DE,HL
	INC	DE
	LD	B,00H
TCMD0:	LD	HL,(BUF0)
TCMD1:	LD	A,L
	XOR	H
	XOR	B
	LD	(HL),A
	INC	HL
	PUSH	HL
	OR	A
	SBC	HL,DE
	POP	HL
	JR	NZ,TCMD1
	LD	HL,(BUF0)
TCMD2:	LD	A,L
	XOR	H
	XOR	B
	CP	(HL)
	CALL	NZ,TCMD3
	INC	HL
	PUSH	HL
	OR	A
	SBC	HL,DE
	POP	HL
	JR	NZ,TCMD2
	INC	B
	CALL	CHKPER
	LD	C,50H
	CALL	COE
	JR	TCMD0

TCMD3:	PUSH	AF
	CALL	PRNTHL
	POP	AF
	CALL	PRHXSP
	LD	A,(HL)
	CALL	PRHXSP
	JP	CRLF

CHDCMD: CP	44H
	JP	NZ,CHECMD
	RES	0,(IY+10)
	EX	DE,HL
	LD	A,(PARMCT)
	CP	02H
	JR	NC,DCMD1
DCMD0:	LD	DE,00FFH
	PUSH	HL
	ADD	HL,DE
	LD	(BUF02),HL
	POP	HL
DCMD1:	CALL	CRLF
	PUSH	HL
	POP	BC
	PUSH	HL
	LD	HL,(BUF02)
	OR	A
	SBC	HL,BC
	JP	C,BADINP
	LD	BC,000FH
	OR	A
	SBC	HL,BC
	LD	B,10H
	JR	Z,DCMD2
	JP	NC,DCMD3
	LD	A,L
	ADD	A,B
	LD	B,A
DCMD2:	SET	0,(IY+10)
DCMD3:	POP	HL
	PUSH	BC
	CALL	PRNTHL
	POP	BC
	CALL	DMPDAT
	CALL	CHKPER
	BIT	0,(IY+10)
	JR	Z,DCMD1
DCMD4:	CALL	CSE
	JR	Z,DCMD4
	CALL	CIE
	CP	2EH
	RET	Z
	CP	20H
	JR	NZ,DCMD4
	RES	0,(IY+10)
	CALL	CRLF
	JR	DCMD0

CHECMD: CP	45H
	JP	NZ,CHPCMD
	EX	DE,HL
ECMD0:	CALL	PRNTHL
	LD	A,(HL)
	CALL	PRHASC
	LD	C,2DH
	CALL	COE
	PUSH	HL
	CALL	BUFINP
	POP	HL
	LD	A,(CHARIN)
	CP	2EH
	RET	Z
	LD	A,(PARMCT)
	AND	03H
	JR	Z,ECMD2
	LD	A,(BUF0)
	LD	(HL),A
	INC	HL
	LD	A,(CHARIN)
	CP	0DH
	JR	Z,ECMD0
ECMD1:	DEC	HL
	JR	ECMD0

ECMD2:	LD	A,(CHARIN)
	CP	5EH
	JR	Z,ECMD1
	INC	HL
	JR	ECMD0

CHPCMD: CP	50H
	JR	NZ,CHSCMD
	LD	A,(BUF0)
	LD	C,A
PCMD0:	LD	A,C
	CALL	PRHXSP
	IN	A,(C)
	CALL	PRHXSP
	PUSH	BC
	CALL	BUFINP
	POP	BC
	LD	A,(CHARIN)
	CP	2EH
	RET	Z
	LD	H,A
	LD	A,(PARMCT)
	AND	A
	JR	Z,PCMD2
	LD	A,(BUF0)
	OUT	(C),A
	LD	A,5EH
	CP	H
	JR	Z,PCMD0
PCMD1:	INC	C
	JR	PCMD0

PCMD2:	LD	A,5EH
	CP	H
	JR	NZ,PCMD1
	DEC	C
	JR	PCMD0

CHSCMD: CP	53H
	JR	Z,ISSCMD
BADINP: LD	C,3FH
	CALL	COE
	JP	MONRUN

ISSCMD: POP	AF
	CALL	PRREGL
	LD	A,(PARMCT)
	AND	A
	JR	Z,SCMD0
	EX	DE,HL
	LD	(ADRBUF),HL
SCMD0:	LD	A,(BUF02)
	AND	A
	JR	NZ,SCMD1
	INC	A
SCMD1:	LD	(SFFC9),A
	XOR	A
	LD	(PARMCT),A
	CALL	ISBCMD
	LD	DE,(ADRBUF)
	LD	A,(DE)
	CP	40H
	JR	C,SCMD2
	CP	0C0H
	JP	C,SCMD20
SCMD2:	AND	03H
	LD	B,A
	LD	A,(DE)
	RRA	
	RRA	
	AND	1FH
	PUSH	BC
	LD	BC,SCDTB1
	ADD	A,C
	LD	L,A
	LD	H,B
	POP	BC
	LD	A,(HL)
	INC	B
SCMD3:	DJNZ	SHRA2
	AND	03H
	JP	Z,SCMD19
	PUSH	AF
	LD	A,(DE)
	LD	HL,(SFFF4)
	CP	0E9H
	JP	Z,SVMEND
	CP	0C3H
	JR	Z,SCMD15
	CP	0CDH
	JR	Z,SCMD15
	CP	0C9H
	JR	Z,SCMD14
	CP	10H
	JR	NZ,SCMD5
	LD	HL,SFFF9
	DEC	(HL)
	JR	NZ,SCMD11
	INC	(HL)
SCMD4:	JP	SCMD25

SHRA2:	SRL	A
	SRL	A
	JR	SCMD3

SCMD5:	CP	18H
	JR	Z,SCMD11
	CP	80H
	JR	NC,SCMD6
	XOR	20H
	LD	B,A
	AND	67H
	JR	NZ,SCMD4
	LD	A,B
	JR	SCMD8

SCMD6:	AND	0C7H
	CP	0C2H
	JR	Z,SCMD7
	AND	0C3H
	CP	0C0H
	JR	NZ,SCMD16
SCMD7:	LD	A,(DE)
SCMD8:	AND	30H
	LD	HL,SCDTB2
SCMD9:	INC	HL
	SUB	10H
	JR	NC,SCMD9
	LD	A,(TEMPB0)
	AND	(HL)
	LD	A,(DE)
	JR	Z,SCMD10
	CPL	
SCMD10: BIT	3,A
	JR	NZ,SCMD4
	POP	AF
	PUSH	AF
	CP	02H
	JR	C,SCMD14
	JR	NZ,SCMD15
SCMD11: INC	DE
	LD	A,(DE)
	INC	DE
	LD	L,A
	RLA	
	LD	H,00H
	JR	NC,SCMD12
	DEC	H
SCMD12: ADD	HL,DE
	JR	SCMD18

SCMD13: DEC	DE
SCMD14: LD	HL,(BRKSP)
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	JR	SCMD28

SCMD15: LD	A,(DE)
	BIT	2,A
	INC	DE
	LD	A,(DE)
	LD	L,A
	INC	DE
	LD	A,(DE)
	LD	H,A
	JR	NZ,SCMD28
	JR	SCMD18

SCMD16: LD	A,(DE)
	AND	0C7H
	CP	0C7H
	LD	A,(DE)
	JR	NZ,SCMD17
	AND	38H
	LD	L,A
	LD	H,00H
	JR	SCMD28

SCMD17: CP	0FBH
	JR	NZ,SCMD25
	CPL	
	LD	(MNFLG0),A
	EX	DE,HL
	INC	HL
SCMD18: JP	SVMEND

SCMD19: LD	A,(DE)
	INC	DE
	CP	0EDH
	JR	NZ,SCMD21
	LD	B,03H
	LD	A,(DE)
	AND	0F7H
	CP	45H
	JR	Z,SCMD13
	AND	0C7H
	CP	43H
	JR	Z,SCMD26
SCMD20: LD	B,01H
	JR	SCMD26

SCMD21: CP	0DDH
	LD	HL,(SFFEA)
	JR	Z,SCMD22
	LD	HL,(RSTSTK)
SCMD22: LD	A,(DE)
	CP	0E9H
	JR	Z,SCMD18
	LD	HL,SCDTB0
	LD	BC,0005H
	CPIR	
	JR	NZ,SCMD29
	INC	B
SCMD23: INC	B
SCMD24: INC	B
	PUSH	BC
SCMD25: POP	BC
SCMD26: EX	DE,HL
SCMD27: INC	HL
	DJNZ	SCMD27
SCMD28: CALL	SETBRK
	JP	RESTOR

SCMD29: AND	0FEH
	CP	34H
	JR	Z,SCMD23
	LD	A,(DE)
	AND	07H
	CP	06H
	JR	Z,SCMD23
	LD	A,(DE)
	AND	0F8H
	CP	70H
	JR	Z,SCMD23
	JR	SCMD24

SCDTB0: DEFB	21H,22H,2AH,36H 	;!"*6
	DEFB	0CBH			;K
SCDTB1: DEFB	5DH,65H,55H,65H 	;]eUe
	DEFB	5EH,65H,56H,65H 	;^eVe
	DEFB	7EH,65H,76H,65H 	;~eve
	DEFB	7EH,65H,76H,65H 	;~eve
	DEFB	0F5H,67H,0B5H,6FH	;ug5o
	DEFB	0B5H,67H,0B5H,63H	;5g5c
	DEFB	75H,67H,75H,63H 	;uguc
	DEFB	75H,67H,75H		;ugu
SCDTB2: DEFB	63H,40H,01H,04H 	;c@..
	DEFB	80H			;.

CHKPER: CALL	CSE
	RET	Z
	CALL	CIE
	CP	2EH
	RET	NZ
	JP	MONRUN

SBHLDE: OR	A
	SBC	HL,DE
	JP	C,BADINP
	INC	HL
	RET	

SAVMST: LD	(BRKSP),SP
	LD	SP,0000H
	PUSH	AF
	PUSH	AF
	OR	A
	LD	A,I
	PUSH	AF
	DI	
	PUSH	BC
	PUSH	DE
	PUSH	HL
	EXX	
	EX	AF,AF'
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	A,(MNFLG0)
	AND	04H
	LD	(MNFLG0),A
	EXX	
	EX	AF,AF'
	PUSH	IX
	PUSH	IY
	LD	HL,BKBUFF
	LD	DE,(BKADDR)
	LD	BC,0003H
	LDIR	
	LD	HL,(BKADDR)
SVMEND: LD	A,80H
	LD	(STKTOP),A
	LD	(ADRBUF),HL
	LD	SP,STKTOP
	JR	PRRLIN

RESTOR: LD	SP,(BRKSP)
	LD	HL,(ADRBUF)
	PUSH	HL
	LD	HL,(TEMPB0)
	PUSH	HL
	LD	(TEMPSP),SP
	LD	SP,RSTSTK
	POP	IY
	POP	IX
	EXX	
	EX	AF,AF'
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	EXX	
	EX	AF,AF'
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	LD	I,A
	LD	SP,(TEMPSP)
	JP	PE,RETWEI
	POP	AF
	DI	
	RET	

RETWEI: POP	AF
	EI	
	RET	

PRRLIN: CALL	DMPLIN
	LD	A,(STKTOP)
	LD	B,A
	XOR	A
	LD	(STKTOP),A
	LD	HL,SFFC9
	DEC	(HL)
	JR	Z,PRRCTL
	CALL	CSE
	JR	NZ,PRRCTL
	JR	PCLF0

PRRCTL: CALL	CHRINE
	CP	2EH
	JP	Z,MONRUN
	CP	0DH
	JR	Z,PRRCLF
	CP	20H
	JR	NZ,PRRCTL
	XOR	A
	CP	(HL)
	LD	(HL),00H
	JR	NZ,PRRCTL
	CALL	CRLF
	CALL	PRREGL
	LD	A,0BH
	JP	SCMD1

PRRCLF: LD	(HL),01H
PCLF0:	CALL	CRLF
	LD	A,(HL)
	JP	SCMD1

DMPLIN: LD	HL,(ADRBUF)
	CALL	PRNTHL
	LD	A,(MNFLG1)
	RRA	
	LD	B,01H
	JR	NC,DMPLN0
	LD	B,0CH
DMPLN0: LD	HL,TEMPB1
DLINLP: LD	A,(HL)
	CALL	PRHASC
	DEC	HL
	LD	A,(HL)
	CALL	PRHXSP
	DEC	HL
	DJNZ	DLINLP
	RET	

DMPDAT: PUSH	BC
	PUSH	HL
DDAT0:	LD	A,(HL)
	CALL	PRHXSP
	INC	HL
	DJNZ	DDAT0
	CALL	SPACE
	CALL	SPACE
	POP	HL
	POP	BC
DDTASC: LD	A,(HL)
	AND	7FH
	LD	C,A
	CP	20H
	JR	C,PUTPER
	CP	7BH
	JR	C,DDTA0
PUTPER: LD	C,2EH
DDTA0:	CALL	COE
	INC	HL
	DJNZ	DDTASC
	RET	

REGLST: DEFB	20H,50H,43H,20H 	;.PC.
	DEFB	20H,20H,41H,46H 	;..AF
	DEFB	20H,20H,49H,20H 	;..I.
	DEFB	49H,46H,20H,20H 	;IF..
	DEFB	42H,43H,20H,20H 	;BC..
	DEFB	20H,44H,45H,20H 	;.DE.
	DEFB	20H,20H,48H,4CH 	;..HL
	DEFB	20H,20H,41H,27H 	;..A'
	DEFB	46H,27H,20H,42H 	;F'.B
	DEFB	27H,43H,27H,20H 	;'C'.
	DEFB	44H,27H,45H,27H 	;D'E'
	DEFB	20H,48H,27H,4CH 	;.H'L
	DEFB	27H,20H,20H,49H 	;'..I
	DEFB	58H,20H,20H,20H 	;X...
	DEFB	49H,59H,20H,20H 	;IY..
	DEFB	20H,53H,50H,0DH 	;.SP.
	DEFB	0AH,03H 		;..

MCONST: IN	A,(CSTAT)
	AND	02H
	RET	Z
	LD	A,0FFH
	RET	

MCONIN: CALL	MCONST
	JP	Z,MCONIN
	IN	A,(CDATA)
	AND	7FH
	RET	

MCONOT: IN	A,(CSTAT)
	AND	04H
	JP	Z,MCONOT
	LD	A,C
	OUT	(CDATA),A
	RET	

PRHXSP: PUSH	BC
	CALL	PRHASC
	CALL	SPACE
	POP	BC
	RET	

CRLF:	LD	C,0DH
	CALL	COE
	LD	C,0AH
	JP	COE

SPACE:	LD	C,20H
	JP	COE

PRREGL: LD	HL,REGLST
PRLOOP: LD	A,(HL)
	CP	03H
	RET	Z
	LD	C,A
	CALL	COE
	INC	HL
	JP	PRLOOP

PRHASC: PUSH	AF
	RRCA	
	RRCA	
	RRCA	
	RRCA	
	CALL	PRHAS0
	POP	AF
PRHAS0: AND	0FH
	ADD	A,90H
	DAA	
	ADC	A,40H
	DAA	
	LD	C,A
	JP	COE

HEXTBI: SUB	30H
	CP	0AH
	RET	M
	SUB	07H
	RET	

ISHEX:	CP	30H
	JP	C,ISHEXF
	CP	3AH
	JP	C,ISHEXT
	CP	40H
	JP	C,ISHEXF
	CP	47H
	JP	NC,ISHEXF
ISHEXT: XOR	A
	RET	

ISHEXF: XOR	A
	INC	A
	RET	

CKCTLI: CP	20H
	RET	Z
	CP	5EH
	JP	Z,STCRLF
	CP	2EH
	JP	Z,MONRUN
	CP	0DH
	RET	NZ
STCRLF: PUSH	BC
	CALL	CRLF
	POP	BC
	XOR	A
	RET	

RDINPT: LD	HL,0000H
	LD	B,L
GETINP: CALL	CHRINE
	INC	B
	CALL	CKCTLI
	RET	Z
	CALL	ISHEX
	RET	NZ
	LD	A,C
	CALL	HEXTBI
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	A,L
	LD	L,A
	JP	GETINP

CHRINE: CALL	CIE
	LD	C,A
	JP	COE

BUFINP: XOR	A
	LD	HL,BUF0
	PUSH	HL
	POP	IX
	LD	(HL),A
	LD	BC,0009H
	LD	DE,BUF01
	LDIR	
	LD	(PARMCT),A
INTINP: CALL	RDINPT
	JP	NZ,BADINP
	LD	A,C
	LD	(CHARIN),A
	CP	20H
	JR	Z,SPINP
	DEC	B
	RET	Z
SPINP:	LD	(IX+0),L
	LD	(IX+1),H
	LD	A,(PARMCT)
	INC	A
	LD	(PARMCT),A
	INC	IX
	INC	IX
	LD	A,C
	CP	20H
	JR	Z,INTINP
	RET	

PRNTHL: LD	A,H
	CALL	PRHASC
	LD	A,L
	JP	PRHXSP

	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH,0FFH,0FFH	;....
	DEFB	0FFH,0FFH		;..
	END
	;.