;
; S. D. SYSTEMS Z-80 MONITOR FOR THE SBC-200
;
                ORG     0E000H
;
SINIT:          JP      SERIALINIT
NSINIT:         JP      NOSERINIT
STAT:           JP      STATUS
IN:             JP      INPUT
PR:             JP      PRINT
;
SERIALINIT:     IN      A,(7FH)
                LD      HL,0FF60H
                LD      (0FFE6H),HL
                XOR     A
                LD      (0FFC0H),A
                LD      A,4EH        ; INITIALIZE CTC
                OUT     (7DH),A      ;      AND UART
                LD      A,37H
                OUT     (7DH),A
                LD      A,5
                OUT     (78H),A
                LD      A,1
                OUT     (78H),A
                IN      A,(1)
NOSERINIT:      XOR     A
                LD      (0FFFAH),A
                LD      A,1
                LD      (0FFC6H),A
INIT0:          LD      SP,0FFC0H
                CALL    CRLF         ; CR/LF
                LD      C,'.'
                CALL    PR           ; PRINT
                CALL    INANDPR      ; INPUT & DISPLAY
                CP      '.'
                JR      Z,INIT0
                PUSH    BC
                CALL    0E6FFH       ; SPACE
                CALL    0E784H
                POP     BC
                LD      A,C
                LD      HL,INIT0     ; SET RETURN TO
                PUSH    HL           ;    COMMAND LOOP
                LD      HL,(0FFD2H)
                LD      DE,(0FFD0H)
                LD      IY,0FFC0H
;
;  IS IT A 'B' -- BREAKPOINT?
;
                CP      'B'
                JR      NZ,TRYG      ; NO, TRY 'G'
                PUSH    DE
                LD      A,(0FFC0H)
                BIT     0,A
                JR      Z,BRKPT1
                LD      DE,(0FFC4H)
                LD      HL,0FFC1H
                LD      BC,003
                LDIR                                          
                XOR     A                                     
                LD      (0FFC0H),A                            
BRKPT1:         LD      A,(0FFC7H)                            
                AND     A                                     
                POP     HL                                    
                JR      Z,BRKPT2
                LD      (0FFC4H),HL                           
                PUSH    HL                                    
                LD      DE,0FFC1H                             
                LD      BC,003                                
                PUSH    BC                                    
                LDIR                                          
                LD      HL,0E09DH                             
                POP     BC                                    
                POP     DE                                    
                LDIR                                          
                LD      A,1                                   
                LD      (0FFC0H),A                            
BRKPT2:         RET                                           
;
                JP      0E591H                                
;
;  IS IT A 'G' -- GO?
;
TRYG:           CP      'G'                                   
                JR      NZ,TRYR      ; NO, TRY 'R'
                LD      A,(0FFC7H)                            
                AND     A                                     
                JR      Z,GO1
                LD      (0FFFEH),DE                           
                POP     AF                                    
GO1:            LD      A,1                                   
                LD      (0FFC9H),A                            
                JP      0E5D2H                                
;
;  IS IT AN 'R' -- READ?
;
TRYR:           CP      'R'                                   
                JR      NZ,TRYW      ; NO, TRY 'W'
                CALL    IO            
                JP      0F02DH                                
;
;  IS IT A 'W' -- WRITE?
;
TRYW:           CP      'W'                                   
                JR      NZ,TRYZ      ; NO, TRY 'Z'
                CALL    IO
                JP      0F030H                                
;
IO:             LD      A,(0FFC7H)                            
                CP      5                                     
                JP      C,0E407H                              
                LD      (040H),DE                             
                LD      A,L                                   
                LD      (042H),A                              
                LD      A,(0FFD4H)                            
                LD      (044H),A                              
                LD      A,(0FFD6H)                            
                LD      (043H),A                              
                LD      A,(0FFD8H)                            
                LD      (045H),A                              
                RET                                           
;
;  IS IT A 'Z' -- FORMAT (IBM 3740)?
;
TRYZ:           CP      'Z'                                   
                JR      NZ,TRYQ      ; NO, TRY 'Q'
                LD      A,(0FFC7H)                            
                DEC     A                                     
                JP      NZ,0E407H                             
                LD      A,E                                   
                LD      (042H),A                              
                XOR     A                                     
                LD      (044H),A                              
                INC     A                                     
                LD      (043H),A                              
                CALL    0F018H                                
Z1:             IN      A,(63H)                               
                OR      'P'                                   
                OUT     (63H),A                               
                CALL    0F033H                                
                CALL    0E125H                                
                JR      Z,Z2
                RES     4,A                                   
                OUT     (63H),A                               
                CALL    0F033H                                
Z2:             CALL    0E12AH                                
                JR      NZ,Z1
                JP      0F018H                                
;
E125:           IN      A,(63H)                               
                BIT     5,A                                   
                RET                                           
;
E12A:           LD      A,(044H)                              
                INC     A                                     
                LD      (044H),A                              
                LD      B,A                                   
                LD      A,(0F040H)                            
                CP      B                                     
                RET                                           
;
;  IS IT A 'Q' -- ?
;
TRYQ:           CP      'Q'                                   
                JR      NZ,TRYM
                LD      A,E                                   
                LD      (042H),A                              
Q1:             XOR     A                                     
                LD      (044H),A                              
Q2:             LD      A,1
                LD      (043H),A                              
                LD      A,(0F03FH)                            
                LD      B,A                                   
                CALL    0E125H                                
                JR      Z,Q3
                SLA     B                                     
Q3:             LD      A,B                                   
                LD      (045H),A                              
                LD      HL,100H                               
                LD      (040H),HL                             
                CALL    0F02DH                                
                CALL    0E57CH                                
                CALL    0E12AH                                
                JR      NZ,Q2                              
                LD      C,'P'                                 
                CALL    0E00CH                                
                JR      Q1
;
;  IS IT AN 'M' -- MOVE MEMORY?
;
TRYM:           CP      'M'
                JR      NZ,TRYC       ; NO, TRY 'C'
                CALL    0E589H                                
                LD      B,H                                   
                LD      C,L                                   
                EX      DE,HL                                 
                LD      DE,(0FFD4H)                           
                OR      A                                     
                SBC     HL,DE                                 
                JR      NC,M1
                LD      HL,(0FFD4H)                           
                ADD     HL,BC                                 
                DEC     HL                                    
                LD      D,H                                   
                LD      E,L                                   
                LD      HL,(0FFD2H)                           
                LDDR                                          
                JR      M2
;
M1:             LD      HL,(0FFD0H)                           
                LDIR                                          
M2:             RET                                           
;
;  IS IT A 'C' -- BOOT CP/M?
;
TRYC:           CP      'C'                                   
                JP      Z,0F003H       ; YES, JUMP TO BOOT
;
;  IS IT AN 'H' -- HEX ARITHMETIC?
;
TRYH:           CP      'H'                                   
                JR      NZ,TRYX        ; NO, TRY 'X'
                PUSH    HL                                    
                ADD     HL,DE                                 
                LD      C,'+'                                 
                CALL    0E00CH                                
                CALL    0E7BEH                                
                CALL    0E6FFH                                
                POP     HL                                    
                EX      DE,HL                                 
                OR      A                                     
                SBC     HL,DE                                 
                LD      C,'-'                                 
                CALL    0E00CH                                
                CALL    0E7BEH                                
                JP      0E036H                                
;
;  IS IT AN 'X' -- DISPLAY REGISTERS?
;
TRYX:           CP      'X'
                JR      NZ,TRYI        ; NO, TRY 'I'
                XOR     A                                     
                CP      E                                     
                CALL    NZ,0E704H                             
                LD      A,(0FFC7H)                            
                CP      2                                     
                JR      NZ,REGS1
                LD      A,(0FFD2H)                            
                LD      (0FFC6H),A                            
REGS1:          JP      0E646H                                
;
;  IS IT AN 'I' -- INPUT?
;
TRYI:           CP      'I'                                   
                JR      NZ,TRYO        ; NO, TRY 'O'
                RES     0,(IY+0AH)                            
                LD      A,(0FFD0H)                            
                LD      C,A                                   
                LD      B,1                                   
                LD      A,(0FFC7H)                            
                CP      2                                     
                JR      C,INP1
                LD      A,(0FFD2H)                            
                LD      B,A                                   
                OR      A                                     
                JR      NZ,INP1
                SET     0,(IY+0AH)                            
INP1:           LD      A,C                                   
                CALL    0E6ECH                                
                IN      A,(C)                                 
                CALL    0E6ECH                                
                CALL    0E57CH                                
                PUSH    BC                                    
                CALL    0E6F5H                                
                POP     BC                                    
                BIT     0,(IY+0AH)                            
                JR      NZ,INP1
                DJNZ    INP1
                RET                                           
;
;  IS IT AN 'O' -- OUTPUT?
;
TRYO:           CP      'O'
                JR      NZ,TRYF        ; NO, TRY 'F'
                RES     0,(IY+0AH)
                LD      A,(0FFD0H)
                LD      C,A
                LD      A,(0FFD2H)                            
                LD      D,A                                   
                LD      B,1                                   
                LD      A,(0FFC7H)                            
                CP      3                                     
                JR      C,OUT1
                LD      A,(0FFD4H)                            
                LD      B,A                                   
                OR      A                                     
                JR      NZ,OUT1
                SET     0,(IY+0AH)                            
OUT1:           OUT     (C),D
                CALL    0E57CH
                BIT     0,(IY+0AH)                            
                JR      NZ,OUT1
                DJNZ    OUT1
                RET                                           
;
;  IS IT AN 'F' -- FILL?
;
TRYF:           CP      'F'
                JR      NZ,TRYL        ; NO, TRY 'L'
                LD      A,(0FFD4H)                            
                PUSH    HL                                    
                CALL    0E589H                                
                POP     HL                                    
FILL1:          LD      (DE),A                                
                PUSH    HL                                    
                OR      A                                     
                SBC     HL,DE                                 
                POP     HL                                    
                INC     DE                                    
                JR      NZ,FILL1
                RET                                           
;
;  IS IT AN 'L' -- LOCATE STRING?
;
TRYL:           CP      'L'
                JR      NZ,TRYV       ; NO, TRY 'V'
                CALL    0E589H                                
                LD      A,(0FFC7H)                            
                SUB     3                                     
                JP      C,0E407H                              
                LD      B,A                                   
                INC     A                                     
                LD      (0FFC7H),A                            
                LD      HL,0FFD5H                             
                LD      DE,0FFD6H                             
LOC1:           LD      A,(DE)                                
                LD      (HL),A                                
                INC     HL                                    
                INC     DE                                    
                INC     DE                                    
                DJNZ    LOC1
LOC4:           LD      A,(0FFC7H)                            
                LD      B,A                                   
                LD      HL,(0FFD0H)                           
                LD      DE,0FFD4H                             
LOC2:           LD      A,(DE)                                
                CP      (HL)                                  
                JR      NZ,LOC3
                INC     HL                                    
                INC     DE                                    
                DJNZ    LOC2
                LD      HL,(0FFD0H)                           
                CALL    0E7BEH                                
                CALL    0E6F5H                                
                CALL    0E57CH                                
LOC3:           LD      HL,(0FFD2H)                           
                LD      DE,(0FFD0H)                           
                OR      A                                     
                SBC     HL,DE                                 
                RET     Z                                     
                INC     DE                                    
                LD      (0FFD0H),DE                           
                JR      LOC4
;
;  IS IT A 'V' -- VERIFY MEMORY?
;
TRYV:           CP      'V'
                JR      NZ,TRYT       ; NO, TRY 'T'
                CALL    0E589H                                
                PUSH    HL                                    
                POP     BC                                    
                EX      DE,HL                                 
                LD      DE,(0FFD4H)                           
V1:             LD      A,(DE)                                
                CPI                                           
                INC     DE                                    
                JR      NZ,V2
                RET     PO                                    
                JR      V1
;
V2:             PUSH    AF
                PUSH    BC                                    
                PUSH    DE                                    
                DEC     HL                                    
                CALL    0E7BEH                                
                LD      A,(HL)                                
                INC     HL                                    
                CALL    0E6ECH                                
                POP     DE                                    
                PUSH    DE                                    
                PUSH    HL                                    
                EX      DE,HL                                 
                DEC     HL                                    
                CALL    0E7BEH                                
                LD      A,(HL)                                
                CALL    0E713H                                
                CALL    0E6F5H                                
                POP     HL                                    
                POP     DE                                    
                POP     BC                                    
                POP     AF                                    
                RET     PO                                    
                CALL    0E57CH                                
                JR      V1
;
;  IS IT A 'T' -- TEST MEMORY?
;
TRYT:           CP      'T'
                JR      NZ,TRYD       ; NO, TRY 'D'
                EX      DE,HL                                 
                INC     DE                                    
                LD      B,0                                   
T1:             LD      HL,(0FFD0H)                           
T2:             LD      A,L                                   
                XOR     H                                     
                XOR     B                                     
                LD      (HL),A                                
                INC     HL                                    
                PUSH    HL                                    
                OR      A                                     
                SBC     HL,DE                                 
                POP     HL                                    
                JR      NZ,T2
                LD      HL,(0FFD0H)                           
T3:             LD      A,L                                   
                XOR     H                                     
                XOR     B                                     
                CP      (HL)                                  
                CALL    NZ,0E318H                             
                INC     HL                                    
                PUSH    HL                                    
                OR      A                                     
                SBC     HL,DE                                 
                POP     HL                                    
                JR      NZ,T3
                INC     B                                     
                CALL    0E57CH                                
                LD      C,'P'                                 
                CALL    PR
                JR      T1
;
E318:           PUSH    AF                                    
                CALL    0E7BEH                                
                POP     AF                                    
                CALL    0E6ECH                                
                LD      A,(HL)                                
                CALL    0E6ECH                                
                JP      0E6F5H                                
;
;  IS IT A 'D' -- DUMP MEMORY?
;
TRYD:           CP      'D'
                JP      NZ,TRYE       ; NO, TRY 'E'
                RES     0,(IY+0AH)                            
                EX      DE,HL                                 
                LD      A,(0FFC7H)                            
                CP      2                                     
                JR      NC,D2
D1:             LD      DE,0FFH                               
                PUSH    HL                                    
                ADD     HL,DE                                 
                LD      (0FFD2H),HL                           
                POP     HL                                    
D2:             CALL    0E6F5H                                
                PUSH    HL                                    
                POP     BC                                    
                PUSH    HL                                    
                LD      HL,(0FFD2H)                           
                OR      A                                     
                SBC     HL,BC                                 
                JP      C,0E407H                              
                LD      BC,00FH                               
                OR      A                                     
                SBC     HL,BC                                 
                LD      B,10H                                 
                JR      Z,D3
                JP      NC,0E364H                             
                LD      A,L                                   
                ADD     A,B                                   
                LD      B,A                                   
D3:             SET     0,(IY+0AH)                            
                POP     HL                                    
                PUSH    BC                                    
                CALL    0E7BEH                                
                POP     BC                                    
                CALL    0E666H                                
                CALL    0E57CH                                
                BIT     0,(IY+0AH)                            
                JR      Z,D2
D4:             CALL    STAT
                JR      Z,D4
                CALL    0E009H                                
                CP      '.'                                   
                RET     Z                                     
                CP      ' '                                   
                JR      NZ,D4
                RES     0,(IY+0AH)                            
                CALL    0E6F5H                                
                JR      D1
;
;  IS IT AN 'E' -- EXAMINE MEMORY?
;
TRYE:           CP      'E'
                JP      NZ,TRYP        ; NO, TRY 'P'
                EX      DE,HL                                 
E1:             CALL    0E7BEH
                LD      A,(HL)
                CALL    0E713H
                LD      C,'-'
                CALL    PR
                PUSH    HL
                CALL    0E784H
                POP     HL
                LD      A,(0FFC8H)
                CP      '.'
                RET     Z
                LD      A,(0FFC7H)
                AND     3
                JR      Z,E3C1
                LD      A,(0FFD0H)
                LD      (HL),A
                INC     HL
                LD      A,(0FFC8H)
                CP      0DH
                JR      Z,E1
E2:             DEC     HL
                JR      E1
;
E3C1:           LD      A,(0FFC8H)                            
                CP      '^'                                   
                JR      Z,E2
                INC     HL                                    
                JR      E1
;
;  IS IT A 'P' -- EXAMINE PORT?
;
TRYP:           CP      'P'
                JR      NZ,TRYS         ; NO, TRY 'S'
                LD      A,(0FFD0H)
                LD      C,A
P1:             LD      A,C
                CALL    0E6ECH
                IN      A,(C)
                CALL    0E6ECH
                PUSH    BC
                CALL    0E784H
                POP     BC
                LD      A,(0FFC8H)
                CP      '.'
                RET     Z
                LD      H,A
                LD      A,(0FFC7H)
                AND     A
                JR      Z,E3FB
                LD      A,(0FFD0H)                            
                OUT     (C),A                                 
                LD      A,'^'                                 
                CP      H                                     
                JR      Z,P1
P2:             INC     C
                JR      P1
;
E3FB:           LD      A,'^'
                CP      H
                JR      NZ,P2
                DEC     C
                JR      P1
;
;  IS IT AN 'S' -- SINGLE STEP?
;
TRYS:           CP      'S'                                   
                JR      Z,ONESTEP      ; YES, DO IT
                LD      C,'?'          ; COMMAND NOT
                CALL    PR             ;    RECOGNIZED
                JP      INIT0          ; ERROR
;
;  DO SINGLE STEP
;
ONESTEP:        POP     AF
                CALL    0E704H
                LD      A,(0FFC7H)
                AND     A
                JR      Z,S1
                EX      DE,HL
                LD      (0FFFEH),HL
S1:             LD      A,(0FFD2H)
                AND     A
                JR      NZ,S2
                INC     A
S2:             LD      (0FFC9H),A
                XOR     A
                LD      (0FFC7H),A
                CALL    0E064H
                LD      DE,(0FFFEH)
                LD      A,(DE)
                CP      '@'
                JR      C,S3
                CP      0C0H
                JP      C,0E511H
S3:             AND     3
                LD      B,A
                LD      A,(DE)
                RRA
                RRA
                AND     1FH
                PUSH    BC
                LD      BC,0E558H
                ADD     A,C
                LD      L,A                                   
                LD      H,B
                POP     BC
                LD      A,(HL)
                INC     B
S4:             DJNZ    E479
                AND     3                                     
                JP      Z,0E4FCH                              
                PUSH    AF                                    
                LD      A,(DE)                                
                LD      HL,(0FFF4H)                           
                CP      0E9H                                  
                JP      Z,0E5C5H                              
                CP      0C3H                                  
                JR      Z,E4D3
                CP      0CDH
                JR      Z,E4D3
                CP      0C9H                                  
                JR      Z,E4CA
                CP      10H                                   
                JR      NZ,E47F
                LD      HL,0FFF9H
                DEC     (HL)
                JR      NZ,E4BC
                INC     (HL)                                  
S5:             JP      0E532H                                
;
E479:           SRL     A
                SRL     A
                JR      S4
;
E47F:           CP      18H
                JR      Z,E4BC
                CP      80H
                JR      NC,E491
                XOR     ' '
                LD      B,A
                AND     'G'
                JR      NZ,S5
                LD      A,B
                JR      E49E
;
E491:           AND     0C7H
                CP      0C2H
                JR      Z,E49D
                AND     0C3H
                CP      0C0H
                JR      NZ,E4E0
E49D:           LD      A,(DE)
E49E:           AND     '0'
                LD      HL,0E577H
E4A3:           INC     HL
                SUB     10H
                JR      NC,E4A3
                LD      A,(0FFFCH)                            
                AND     (HL)                                  
                LD      A,(DE)                                
                JR      Z,E4B0
                CPL
E4B0:           BIT     3,A
                JR      NZ,S5
                POP     AF
                PUSH    AF
                CP      2
                JR      C,E4CA
                JR      NZ,E4D3
E4BC:           INC     DE
                LD      A,(DE)
                INC     DE
                LD      L,A
                RLA
                LD      H,0
                JR      NC,E4C6
                DEC     H
E4C6:           ADD     HL,DE
                JR      E4F9
;
E4C9:           DEC     DE
E4CA:           LD      HL,(0FFE6H)
                LD      A,(HL)
                INC     HL
                LD      H,(HL)
                LD      L,A
                JR      E537
;
E4D3:           LD      A,(DE)
                BIT     2,A
                INC     DE
                LD      A,(DE)
                LD      L,A
                INC     DE
                LD      A,(DE)
                LD      H,A
                JR      NZ,E537
                JR      E4F9
;
E4E0:           LD      A,(DE)
                AND     0C7H
                CP      0C7H
                LD      A,(DE)
                JR      NZ,E4EF
                AND     '8'
                LD      L,A
                LD      H,0
                JR      E537
;
E4EF:           CP      0FBH
                JR      NZ,E532
                CPL
                LD      (0FFFAH),A
                EX      DE,HL
                INC     HL
E4F9:           JP      0E5C5H
;
E4FC:           LD      A,(DE)
                INC     DE
                CP      0EDH
                JR      NZ,E515
                LD      B,3
                LD      A,(DE)
                AND     0F7H                                  
                CP      'E'
                JR      Z,E4C9
                AND     0C7H
                CP      'C'
                JR      Z,E533
                LD      B,1
                JR      E533
;
E515:           CP      0DDH
                LD      HL,(0FFEAH)
                JR      Z,E51F
                LD      HL,(0FFE8H)
E51F:           LD      A,(DE)
                CP      0E9H
                JR      Z,E4F9
                LD      HL,0E553H
                LD      BC,5
                CPIR
                JR      NZ,E53D
                INC     B
E52F:           INC     B
E530:           INC     B
                PUSH    BC
E532:           POP     BC
E533:           EX      DE,HL
E534:           INC     HL
                DJNZ    E534
E537:           CALL    0E083H
                JP      0E5D2H
;
E53D:           AND     0FEH
                CP      '4'
                JR      Z,E52F
                LD      A,(DE)
                AND     7
                CP      6
                JR      Z,E52F
                LD      A,(DE)
                AND     0F8H
                CP      'P'
                JR      Z,E52F
                JR      E530
;
E553:           LD      HL,2A22H
                LD      (HL),0CBH
                LD      E,L
                LD      H,L
                LD      D,L
                LD      H,L
                LD      E,(HL)
                LD      H,L
                LD      D,(HL)
                LD      H,L
                LD      A,(HL)
                LD      H,L
                HALT
;
E563:           LD      H,L
                LD      A,(HL)
                LD      H,L
                HALT
;
E567:           LD      H,L
                PUSH    AF
                LD      H,A
                OR      L
                LD      L,A
                OR      L
                LD      H,A
                OR      L
                LD      H,E
                LD      (HL),L
                LD      H,A
                LD      (HL),L
                LD      H,E
                LD      (HL),L
                LD      H,A
                LD      (HL),L
                LD      H,E
                LD      B,B
                LD      BC,8004H
                CALL    0E006H
                RET     Z
                CALL    IN
                CP      '.'
                RET     NZ
                JP      INIT0
;
E589:           OR      A
                SBC     HL,DE
                JP      C,0E407H
                INC     HL
                RET
;
E591:           LD      (0FFE6H),SP
                LD      SP,0
                PUSH    AF
                PUSH    AF
                OR      A
                LD      A,I
                PUSH    AF
                DI
                PUSH    BC
                PUSH    DE
                PUSH    HL
                EXX
                EX      AF,AF'
                PUSH    AF
                PUSH    BC
                PUSH    DE
                PUSH    HL
                LD      A,(0FFFAH)
                AND     4
                LD      (0FFFAH),A
                EXX
                EX      AF,AF'
                PUSH    IX
                PUSH    IY
                LD      HL,0FFC1H
                LD      DE,(0FFC4H)
                LD      BC,3
                LDIR
                LD      HL,(0FFC4H)
                LD      A,80H
                LD      (0FFC0H),A
                LD      (0FFFEH),HL
                LD      SP,0FFC0H
                JR      E604
;
E5D2:           LD      SP,(0FFE6H)
                LD      HL,(0FFFEH)
                PUSH    HL
                LD      HL,(0FFFCH)
                PUSH    HL
                LD      (0FFE4H),SP
                LD      SP,0FFE8H
                POP     IY
                POP     IX
                EXX
                EX      AF,AF'
                POP     HL
                POP     DE
                POP     BC
                POP     AF
                EXX
                EX      AF,AF'
                POP     HL
                POP     DE
                POP     BC
                POP     AF
                LD      I,A
                LD      SP,(0FFE4H)
                JP      PE,0E601H
                POP     AF
                DI
                RET
;
E601:           POP     AF
                EI
                RET
;
E604:           CALL    0E646H
                LD      A,(0FFC0H)
                LD      B,A
                XOR     A
                LD      (0FFC0H),A
                LD      HL,0FFC9H
                DEC     (HL)
                JR      Z,E61C
                CALL    STAT
                JR      NZ,E61C
                JR      E63F
;
E61C:           CALL    0E77DH
                CP      '.'
                JP      Z,INIT0
                CP      0DH
                JR      Z,E63D
                CP      ' '
                JR      NZ,E61C
                XOR     A
                CP      (HL)
                LD      (HL),0
                JR      NZ,E61C
                CALL    0E6F5H
                CALL    0E704H
                LD      A,0BH
                JP      0E424H
;
E63D:           LD      (HL),1
E63F:           CALL    0E6F5H
                LD      A,(HL)
                JP      0E424H
;
E646:           LD      HL,(0FFFEH)
                CALL    0E7BEH
                LD      A,(0FFC6H)
                RRA
                LD      B,1
                JR      NC,E656
                LD      B,0CH
E656:           LD      HL,0FFFDH
E659:           LD      A,(HL)
                CALL    0E713H
                DEC     HL
                LD      A,(HL)
                CALL    0E6ECH
                DEC     HL
                DJNZ    E659
                RET
;
E666:           PUSH    BC
                PUSH    HL
E668:           LD      A,(HL)
                CALL    0E6ECH
                INC     HL
                DJNZ    E668
                CALL    0E6FFH
                CALL    0E6FFH
                POP     HL
                POP     BC
E677:           LD      A,(HL)
                AND     7FH
                LD      C,A
                CP      ' '
                JR      C,E683
                CP      '{'
                JR      C,E685
E683:           LD      C,'.'
E685:           CALL    PR
                INC     HL                                    
                DJNZ    E677
                RET
;
HEADX:          DEFB      " PC   AF  I IF  BC   DE   HL  A'"
                DEFB      "F' B'C' D'E' H'L'  IX   IY   SP"
                DEFB      0DH,0AH,3
;
STATUS:         IN      A,(0)      ; STATUS
                AND     2          ;   (A)=0, NOT READY
                RET     Z          ;   (A)<>0, READY
                LD      A,0FFH
                RET
;
INPUT:          CALL    STATUS     ; INPUT
                JP      Z,INPUT
                IN      A,(1)
                AND     7FH
                RET
;
PRINT:          IN      A,(0)      ; PRINT CHAR.
                AND     4          ;   IN (C)
                JP      Z,PRINT
                LD      A,C
                OUT     (1),A
                RET
;
E6EC:           PUSH    BC
                CALL    0E713H
                CALL    SPACE
                POP     BC
                RET
;
CRLF:           LD      C,0DH       ;   CR/LF
                CALL    PR
                LD      C,0AH
                JP      PR
;
SPACE:          LD      C,' '       ;  SPACE
                JP      PR
;
E704:           LD      HL,0E68CH   ;  MSG
E707:           LD      A,(HL)
                CP      3
                RET     Z
                LD      C,A
                CALL    PR
                INC     HL
                JP      E707
;
E713:           PUSH    AF
                RRCA
                RRCA
                RRCA
                RRCA
                CALL    0E71CH
                POP     AF
E71C:           AND     0FH
                ADD     A,90H
                DAA
                ADC     A,'@'
                DAA
                LD      C,A
                JP      PR
;
E728:           SUB     '0'
                CP      0AH
                RET     M
                SUB     7
                RET 
;
E730:           CP      '0'
                JP      C,0E746H
                CP      ':'
                JP      C,0E744H
                CP      '@'
                JP      C,0E746H
                CP      'G'
                JP      NC,0E746H
E744:           XOR     A          ; A=0
                RET
;
E746:           XOR     A          ; A=1
                INC     A
                RET
;
E749:           CP      ' '
                RET     Z
                CP      '^'
                JP      Z,0E759H
                CP      '.'
                JP      Z,INIT0
                CP      0DH                                   
                RET     NZ
E759:           PUSH    BC
                CALL    0E6F5H
                POP     BC
                XOR     A
                RET
;
E760:           LD      HL,0
                LD      B,L
E764:           CALL    0E77DH
                INC     B
                CALL    0E749H
                RET     Z
                CALL    0E730H
                RET     NZ
                LD      A,C
                CALL    0E728H
                ADD     HL,HL
                ADD     HL,HL
                ADD     HL,HL
                ADD     HL,HL
                ADD     A,L
                LD      L,A
                JP      0E764H
;
INANDPR:        CALL    IN
                LD      C,A
                JP      PR
;
E784:           XOR     A
                LD      HL,0FFD0H
                PUSH    HL
                POP     IX
                LD      (HL),A
                LD      BC,9
                LD      DE,0FFD1H
                LDIR
                LD      (0FFC7H),A
E797:           CALL    0E760H
                JP      NZ,0E407H
                LD      A,C
                LD      (0FFC8H),A
                CP      ' '
                JR      Z,E7A7
                DEC     B
                RET     Z
E7A7:           LD      (IX+0),L
                LD      (IX+1),H
                LD      A,(0FFC7H)
                INC     A
                LD      (0FFC7H),A
                INC     IX
                INC     IX
                LD      A,C
                CP      ' '
                JR      Z,E797
                RET
;
E7BE:           LD      A,H
                CALL    0E713H
                LD      A,L
                JP      0E6ECH
;
                END
